/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.material.AbstractMaterial;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundMaterialItem
extends Item
implements IColoredMaterialItem {
    public CompoundMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static List<MaterialInstance> getSubMaterials(ItemStack stack) {
        List<MaterialInstance> materialList = (List<MaterialInstance>)stack.get(SgDataComponents.MATERIAL_LIST);
        return materialList != null ? materialList : Collections.emptyList();
    }

    public ItemStack create(List<MaterialInstance> materials) {
        return this.create(materials, materials.size());
    }

    public ItemStack create(List<MaterialInstance> materials, int craftedCount) {
        ItemStack result = new ItemStack((ItemLike)this, craftedCount);
        List<MaterialInstance> materialsWithoutEnhancements = materials.stream().map(AbstractMaterial::removeEnhancements).toList();
        result.set(SgDataComponents.MATERIAL_LIST, materialsWithoutEnhancements);
        return result;
    }

    @Nullable
    private static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        List materialList = (List)stack.get(SgDataComponents.MATERIAL_LIST);
        return materialList != null ? (MaterialInstance)materialList.getFirst() : null;
    }

    public static String getModelKey(ItemStack stack) {
        return SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#" + CompoundMaterialItem.getSubMaterials(stack).stream().map(mat -> SilentGear.shortenId(mat.getId())).collect(Collectors.joining(","));
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        if (layer == 0) {
            return ColorUtils.getBlendedColorForCompoundMaterial(CompoundMaterialItem.getSubMaterials(stack));
        }
        return -1;
    }

    public Component getName(ItemStack stack) {
        MaterialInstance material = CompoundMaterialItem.getPrimaryMaterial(stack);
        MutableComponent text = material != null ? material.getDisplayName((PartType)PartTypes.MAIN.get()) : TextUtil.misc("unknown", new Object[0]);
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{text});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (((Boolean)Config.Client.showMaterialTooltips.get()).booleanValue()) {
            MaterialInstance material = MaterialInstance.from(stack);
            if (material == null) {
                return;
            }
            List<MaterialInstance> subMaterials = CompoundMaterialItem.getSubMaterials(stack);
            List traits = (List)material.getProperty((Supplier<PartType>)PartTypes.MAIN, PropertyKey.of(GearProperties.TRAITS, GearTypes.ALL));
            float synergy = SynergyUtils.getSynergy((PartType)PartTypes.MAIN.get(), subMaterials, traits);
            tooltipAdder.accept(SynergyUtils.getDisplayText(synergy));
            TextListBuilder materialListBuilder = new TextListBuilder();
            for (MaterialInstance subMaterial : subMaterials) {
                int nameColor = subMaterial.getNameColor((PartType)PartTypes.MAIN.get(), (GearType)GearTypes.ALL.get());
                materialListBuilder.add((Component)TextUtil.withColor(subMaterial.getDisplayName((PartType)PartTypes.MAIN.get()).copy(), nameColor));
            }
            materialListBuilder.build().forEach(tooltipAdder);
        }
    }
}

