/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundPartItem
extends Item {
    private final Supplier<PartType> partType;

    public CompoundPartItem(Supplier<PartType> partType, Item.Properties properties) {
        super(properties.component(SgDataComponents.MATERIAL_LIST, List.of(MaterialInstance.of(Const.Materials.EXAMPLE))));
        this.partType = partType;
    }

    public PartType getPartType() {
        return this.partType.get();
    }

    public GearType getGearType() {
        return (GearType)GearTypes.NONE.get();
    }

    public static List<MaterialInstance> getMaterials(ItemStack stack) {
        return (List)stack.getOrDefault(SgDataComponents.MATERIAL_LIST, List.of());
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        List<MaterialInstance> materials = CompoundPartItem.getMaterials(stack);
        return !materials.isEmpty() ? materials.getFirst() : null;
    }

    public ItemStack create(MaterialInstance material) {
        return this.create(material, 1);
    }

    public ItemStack create(MaterialInstance material, @Nonnegative int materialCount) {
        ArrayList<MaterialInstance> materials = new ArrayList<MaterialInstance>();
        for (int i = 0; i < materialCount; ++i) {
            materials.add(material);
        }
        return this.create(materials);
    }

    public ItemStack create(List<MaterialInstance> materials) {
        ItemStack result = new ItemStack((ItemLike)this);
        result.set(SgDataComponents.MATERIAL_LIST, List.copyOf(materials));
        return result;
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        List<MaterialInstance> materials = CompoundPartItem.getMaterials(stack);
        for (MaterialInstance material : materials) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    @Deprecated
    public int getColor(ItemStack stack, int layer) {
        if (layer == 0) {
            MaterialInstance primaryMaterial = CompoundPartItem.getPrimaryMaterial(stack);
            return primaryMaterial != null ? primaryMaterial.getColor(this.getGearType(), this.getPartType()) | 0xFF000000 : -1;
        }
        return -1;
    }

    public int getColorWeight(int index, int totalCount) {
        return totalCount - index;
    }

    public Component getName(ItemStack stack) {
        PartInstance part = PartInstance.from(stack);
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && material != null) {
            Component materialDisplayName = material.getDisplayName(this.partType.get(), ItemStack.EMPTY);
            MutableComponent nameText = Component.translatable((String)(this.getDescriptionId() + ".nameProper"), (Object[])new Object[]{materialDisplayName});
            int nameColor = Color.blend((int)part.getColor(ItemStack.EMPTY), (int)-1, (float)0.25f) & 0xFFFFFF;
            return TextUtil.withColor(nameText, nameColor);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        MutableComponent basicItemName = Component.translatable((String)this.getDescriptionId());
        MutableComponent gearPartText = Component.translatable((String)"item.silentgear.compound_part.part_name", (Object[])new Object[]{basicItemName});
        tooltipAdder.accept((Component)gearPartText.withStyle(ChatFormatting.ITALIC));
        PartInstance part = PartInstance.from(stack);
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && material != null && ((Boolean)Config.Client.showPartTooltips.get()).booleanValue()) {
            int nameColor = material.getNameColor(part.getType(), this.getGearType());
            MutableComponent displayNameWithModifiers = material.getDisplayNameWithModifiers(part.getType(), ItemStack.EMPTY);
            tooltipAdder.accept((Component)TextUtil.withColor(displayNameWithModifiers, nameColor));
        }
    }
}

