/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.item.ItemWithSubItems;
import net.silentchaos512.gear.item.SingleMaterialItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;

public class CustomMaterialItem
extends SingleMaterialItem
implements IColoredMaterialItem,
ItemWithSubItems {
    public CustomMaterialItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (layer == 0 && material != null) {
            return material.getColor((GearType)GearTypes.ALL.get(), (PartType)PartTypes.MAIN.get()) | 0xFF000000;
        }
        return -1;
    }

    public Component getName(ItemStack stack) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (material == null) {
            return super.getName(stack);
        }
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{material.getDisplayName((PartType)PartTypes.MAIN.get())});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        MutableComponent translatable = Component.translatable((String)(this.getDescriptionId() + ".literal"));
        MutableComponent withStyle = translatable.withStyle(ChatFormatting.ITALIC);
        tooltipAdder.accept((Component)withStyle);
    }

    @Override
    public void addSubItems(CreativeModeTab.Output output) {
        output.accept(this.create(MaterialInstance.of(Const.Materials.EXAMPLE)));
        for (Material material : SgRegistries.MATERIAL) {
            if (!(material instanceof CustomCompoundMaterial)) continue;
            MaterialInstance mat = MaterialInstance.of(material);
            ItemStack stack = this.create(mat);
            if (!mat.getIngredient().isPresent() || !mat.getIngredient().get().test(stack)) continue;
            output.accept(stack);
        }
    }
}

