/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.core.BuiltinMaterials;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;

public final class GearItemSet<I extends Item> {
    private final DeferredHolder<GearType, GearType> type;
    private final String partName;
    private DeferredItem<I> gearItem;
    private DeferredItem<MainPartItem> mainPart;
    private DeferredItem<GearBlueprintItem> blueprint;
    private DeferredItem<GearBlueprintItem> template;
    private Function<Item.Properties, I> gearItemFactory;
    private final Item.Properties gearItemProperties;
    private Function<Item.Properties, MainPartItem> mainPartFactory;
    private Function<Item.Properties, GearBlueprintItem> blueprintFactory;
    private Function<Item.Properties, GearBlueprintItem> templateFactory;

    public GearItemSet(DeferredHolder<GearType, GearType> type, String partName, BiFunction<Supplier<GearType>, Item.Properties, I> gearItem, Item.Properties gearItemProperties) {
        this(type, partName, (Item.Properties properties) -> (Item)gearItem.apply(() -> ((DeferredHolder)type).value(), (Item.Properties)properties), gearItemProperties);
    }

    public GearItemSet(DeferredHolder<GearType, GearType> type, String partName, Function<Item.Properties, I> gearItem, Item.Properties gearItemProperties) {
        this(type, partName, gearItem, gearItemProperties, properties -> new MainPartItem(() -> ((DeferredHolder)type).value(), (Item.Properties)properties), properties -> new GearBlueprintItem(() -> ((DeferredHolder)type).value(), BlueprintType.BLUEPRINT, (Item.Properties)properties), properties -> new GearBlueprintItem(() -> ((DeferredHolder)type).value(), BlueprintType.TEMPLATE, (Item.Properties)properties));
    }

    public GearItemSet(DeferredHolder<GearType, GearType> type, String partName, Function<Item.Properties, I> gearItem, Item.Properties gearItemProperties, Function<Item.Properties, MainPartItem> mainPart, Function<Item.Properties, GearBlueprintItem> blueprint, Function<Item.Properties, GearBlueprintItem> template) {
        this.type = type;
        this.partName = partName;
        this.gearItemFactory = gearItem;
        this.gearItemProperties = gearItemProperties;
        this.mainPartFactory = mainPart;
        this.blueprintFactory = blueprint;
        this.templateFactory = template;
    }

    public GearType type() {
        return (GearType)this.type.value();
    }

    public String name() {
        return this.type.getId().getPath();
    }

    public String partName() {
        return this.partName;
    }

    public I gearItem() {
        return (I)((Item)this.gearItem.get());
    }

    public MainPartItem mainPart() {
        return (MainPartItem)((Object)this.mainPart.get());
    }

    public GearBlueprintItem blueprint() {
        return (GearBlueprintItem)this.blueprint.get();
    }

    public GearBlueprintItem template() {
        return (GearBlueprintItem)this.template.get();
    }

    public void registerGearItem(DeferredRegister.Items registrar) {
        this.checkNotRegistered(this.gearItemFactory, "gear item");
        this.gearItem = registrar.registerItem(this.name(), this.gearItemFactory, this.gearItemProperties);
        this.gearItemFactory = null;
    }

    public void registerMainPartItem(DeferredRegister.Items registrar) {
        this.checkNotRegistered(this.mainPartFactory, "main part");
        this.mainPart = registrar.registerItem(this.partName, this.mainPartFactory, new Item.Properties().stacksTo(1).setNoCombineRepair());
        this.mainPartFactory = null;
    }

    public void registerBlueprintItem(DeferredRegister.Items registrar) {
        this.checkNotRegistered(this.blueprintFactory, "blueprint");
        this.blueprint = registrar.registerItem(this.name() + "_blueprint", this.blueprintFactory);
        this.blueprintFactory = null;
    }

    public void registerTemplateItem(DeferredRegister.Items registrar) {
        this.checkNotRegistered(this.templateFactory, "template");
        this.template = registrar.registerItem(this.name() + "_template", this.templateFactory);
        this.templateFactory = null;
    }

    private void checkNotRegistered(@Nullable Function<Item.Properties, ?> constructor, String itemTypeName) {
        if (constructor == null) {
            Identifier gearTypeName = SgRegistries.GEAR_TYPE.getKey((Object)((GearType)this.type.get()));
            throw new IllegalStateException(itemTypeName + " for " + String.valueOf(gearTypeName) + " has already been registered!");
        }
    }

    public ItemStack constructBasicItem(BuiltinMaterials builtinMaterial) {
        GearItem item = (GearItem)this.gearItem();
        ArrayList<PartInstance> parts = new ArrayList<PartInstance>();
        parts.add(PartInstance.from(this.mainPart().create(MaterialInstance.of(builtinMaterial.getMaterial()))));
        if (item.requiresPartOfType((PartType)PartTypes.ROD.get())) {
            parts.add(PartInstance.from(((CompoundPartItem)((Object)SgItems.ROD.get())).create(MaterialInstance.of(Const.Materials.WOOD))));
        }
        if (item.requiresPartOfType((PartType)PartTypes.CORD.get())) {
            parts.add(PartInstance.from(((CompoundPartItem)((Object)SgItems.CORD.get())).create(MaterialInstance.of(Const.Materials.STRING))));
        }
        if (item.requiresPartOfType((PartType)PartTypes.BINDING.get())) {
            parts.add(PartInstance.from(((CompoundPartItem)((Object)SgItems.BINDING.get())).create(MaterialInstance.of(Const.Materials.STRING))));
        }
        if (item.requiresPartOfType((PartType)PartTypes.SETTING.get())) {
            parts.add(PartInstance.from(((CompoundPartItem)((Object)SgItems.SETTING.get())).create(MaterialInstance.of(Const.Materials.DIAMOND))));
        }
        ItemStack result = item.construct(parts);
        result.setCount(1);
        return result;
    }
}

