/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public class ModKitItem
extends Item
implements ICycleItem {
    public ModKitItem(Item.Properties properties) {
        super(properties);
    }

    public static PartType getSelectedType(ItemStack stack) {
        PartType type = (PartType)stack.get(SgDataComponents.PART_TYPE);
        return type != null ? type : (PartType)PartTypes.NONE.get();
    }

    private static void setSelectedType(ItemStack stack, PartType type) {
        stack.set(SgDataComponents.PART_TYPE, (Object)type);
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, ICycleItem.Direction direction) {
        PartType selected = ModKitItem.getSelectedType(stack);
        List<PartType> types = ModKitItem.getRemovableTypes();
        if (types.isEmpty()) {
            return;
        }
        if (selected == PartTypes.NONE.get()) {
            if (direction == ICycleItem.Direction.BACK) {
                ModKitItem.setSelectedType(stack, types.getLast());
            } else if (direction == ICycleItem.Direction.NEXT) {
                ModKitItem.setSelectedType(stack, types.getFirst());
            }
        } else {
            int index = types.indexOf(selected) + direction.scale;
            if (index < 0) {
                index = types.size() - 1;
            }
            if (index >= types.size()) {
                index = 0;
            }
            ModKitItem.setSelectedType(stack, types.get(index));
        }
    }

    private static List<PartType> getRemovableTypes() {
        ArrayList<PartType> list = new ArrayList<PartType>();
        for (PartType partType : SgRegistries.PART_TYPE) {
            if (!partType.isRemovable()) continue;
            list.add(partType);
        }
        return list;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        PartType selected = ModKitItem.getSelectedType(stack);
        MutableComponent selectedName = selected.getDisplayName().withStyle(ChatFormatting.GRAY);
        tooltipAdder.accept((Component)TextUtil.withColor(TextUtil.translate("item", "mod_kit.selected", selectedName), Color.SKYBLUE));
        tooltipAdder.accept((Component)TextUtil.translate("item", "mod_kit.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE)));
        if (flag.isAdvanced()) {
            MutableComponent text = Component.literal((String)("Removable types: " + ModKitItem.getRemovableTypes().size()));
            tooltipAdder.accept((Component)TextUtil.withColor(text, ChatFormatting.DARK_GRAY));
        }
    }

    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        return itemStack.copy();
    }
}

