/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainerMenu;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.network.payload.client.SelectBlueprintInBookPayload;
import net.silentchaos512.lib.util.Color;

public class BlueprintBookContainerScreen
extends AbstractContainerScreen<BlueprintBookContainerMenu> {
    private static final Identifier TEXTURE = Identifier.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private final Inventory playerInventory;
    private final int inventoryRows;
    private int selected;

    public BlueprintBookContainerScreen(BlueprintBookContainerMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.playerInventory = playerInventory;
        ItemStack stack = container.item;
        IContainerItem item = (IContainerItem)stack.getItem();
        this.inventoryRows = item.getInventoryRows(stack);
        this.imageHeight = 114 + this.inventoryRows * 18;
        this.selected = BlueprintBookItem.getSelectedSlot(container.item);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean p_432883_) {
        Slot slot;
        if (KeyTracker.isControlDown() && (slot = this.getSlotUnderMouse()) != null && !slot.getItem().isEmpty()) {
            this.selected = slot.index;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SelectBlueprintInBookPayload(((BlueprintBookContainerMenu)this.menu).bookSlot, this.selected), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.minecraft != null) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        return super.mouseClicked(event, p_432883_);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, this.getTitle().getString(), 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventory.getDisplayName().getString(), 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        if (this.minecraft == null) {
            return;
        }
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.inventoryRows * 18 + 17, 256, 256);
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, i, j + this.inventoryRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        int left = this.leftPos + 8 + 18 * (this.selected % 9);
        int top = this.topPos + 18 + 18 * (this.selected / 9);
        graphics.fill(left, top, left + 16, top + 16, Color.SEAGREEN.getColor());
    }
}

