/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public abstract class BasicGearItem
extends Item
implements GearItem {
    public BasicGearItem(Item.Properties properties) {
        super(properties);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getProperties(stack).getNumberInt(this.getDurabilityStat());
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (!GearHelper.isBroken(stack)) {
            return super.mineBlock(stack, level, state, pos, miningEntity);
        }
        return true;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        GearHelper.inventoryTick(stack, level, entity, slot);
    }

    public InteractionResult useOn(UseOnContext context) {
        return GearHelper.useOn(context);
    }
}

