/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.MaterialEquippableInfo;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.gear.BasicGearItem;
import net.silentchaos512.gear.setup.SgAttributes;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearArmorItem
extends BasicGearItem
implements GearArmor {
    private final Supplier<GearType> gearType;
    private final ArmorType armorType;

    public GearArmorItem(Supplier<GearType> gearType, ArmorType armorType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
        this.armorType = armorType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
        super.onRecalculatePost(gear, player, finalProperties);
        GearConstructionData construction = GearData.getConstruction(gear);
        MaterialInstance primaryMaterial = construction.getMainTextureMaterialOrPlaceholder();
        if (primaryMaterial.isValid()) {
            MaterialEquippableInfo equippableInfo = primaryMaterial.get().getEquippableInfo();
            gear.set(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)this.armorType.getSlot()).setEquipSound(equippableInfo.equipSound()).setAsset(equippableInfo.assetId()).build());
        }
    }

    @Override
    public void buildAttributes(ItemStack gear, ItemAttributeModifiers.Builder builder) {
        GearPropertiesData properties = GearData.getProperties(gear);
        float armor = properties.getNumber(GearProperties.ARMOR);
        float toughness = properties.getNumber(GearProperties.ARMOR_TOUGHNESS);
        float knockbackResistance = properties.getNumber(GearProperties.KNOCKBACK_RESISTANCE) / 10.0f;
        float magicArmor = properties.getNumber(GearProperties.MAGIC_ARMOR);
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)this.armorType.getSlot());
        Identifier id = Identifier.withDefaultNamespace((String)("armor." + this.armorType.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(id, (double)armor, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(id, (double)toughness, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        if (knockbackResistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(id, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        if (magicArmor > 0.0f) {
            builder.add(SgAttributes.MAGIC_ARMOR, new AttributeModifier(id, (double)magicArmor, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        super.buildAttributes(gear, builder);
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return this.getGearType().armorDurabilityMultiplier();
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = (int)GearData.getProperties(stack).getNumber(this.getDurabilityStat());
        return (int)this.getGearType().armorDurabilityMultiplier() * maxDamageFactor;
    }

    @Override
    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.clamp((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, item -> {
            GearHelper.onBroken(stack, entity instanceof Player ? (Player)entity : null, this.armorType.getSlot());
            onBroken.accept((Item)item);
        });
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return this.getEquipmentSlot(stack) == EquipmentSlot.FEET && TraitHelper.hasTrait(stack, Const.Traits.SNOW_WALKER);
    }

    public static int getArmorColor(ItemStack stack) {
        GearConstructionData data = GearData.getConstruction(stack);
        PartInstance part = data.getCoatingOrMainPart();
        if (part != null) {
            return part.getColor(stack);
        }
        return 0xFFFFFF;
    }
}

