/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearRangedWeapon;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public class GearBowItem
extends BowItem
implements GearRangedWeapon {
    private static final int MIN_DRAW_DELAY = 10;
    private static final int MAX_DRAW_DELAY = 100;
    private final Supplier<GearType> gearType;

    public GearBowItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public float getDrawDelay(@Nonnull ItemStack stack) {
        return Mth.clamp((float)GearRangedWeapon.super.getDrawDelay(stack), (float)10.0f, (float)100.0f);
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / this.getDrawDelay(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected Projectile createProjectile(Level pLevel, LivingEntity pShooter, ItemStack pWeapon, ItemStack pAmmo, boolean pIsCrit) {
        Projectile projectile = super.createProjectile(pLevel, pShooter, pWeapon, pAmmo, pIsCrit);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            float arrowDamage = this.getArrowDamage(pAmmo);
            float bowDamage = GearData.getProperties(pWeapon).getNumber(GearProperties.RANGED_DAMAGE);
            arrow.setBaseDamage((double)(arrowDamage + bowDamage));
        }
        return projectile;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (GearHelper.isBroken(stack)) {
            return InteractionResult.PASS;
        }
        return super.use(level, player, hand);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getProperties(stack).getNumberInt(GearProperties.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        GearHelper.inventoryTick(stack, level, entity, slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

