/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.gear.BasicGearItem;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearElytraItem
extends BasicGearItem
implements GearArmor {
    private static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableSet.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.BINDING.get())));
    private final Supplier<GearType> gearType;

    public GearElytraItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
        super.onRecalculatePost(gear, player, finalProperties);
        if (!GearHelper.isBroken(gear)) {
            gear.set(DataComponents.GLIDER, (Object)Unit.INSTANCE);
        }
        gear.set(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(SoundEvents.ARMOR_EQUIP_ELYTRA).setAsset(EquipmentAssets.ELYTRA).setDamageOnHurt(false).build());
    }

    @Override
    public void buildAttributes(ItemStack gear, ItemAttributeModifiers.Builder builder) {
        float armor = GearData.getProperties(gear).getNumber(GearProperties.ARMOR);
        if (armor > 0.0f) {
            ArmorType armorType = ArmorType.CHESTPLATE;
            EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
            Identifier id = Identifier.withDefaultNamespace((String)("armor." + armorType.getName()));
            builder.add(Attributes.ARMOR, new AttributeModifier(id, (double)armor, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        super.buildAttributes(gear, builder);
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    @Override
    public boolean supportsPart(ItemStack gear, PartInstance part) {
        if (!part.isValid()) {
            return false;
        }
        PartType type = part.getType();
        boolean canAdd = part.get().canAddToGear(gear, part);
        boolean supported = this.requiresPartOfType(part.getType()) && canAdd || canAdd;
        return type == PartTypes.MAIN.get() && supported || type == PartTypes.LINING.get() || supported;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return this.getGearType().armorDurabilityMultiplier();
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        float durability = GearData.getProperties(stack).getNumber(this.getDurabilityStat());
        return (int)(this.getGearType().armorDurabilityMultiplier() * durability);
    }

    @Override
    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.clamp((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, item -> {
            Player player = entity instanceof Player ? (Player)entity : null;
            GearHelper.onBroken(stack, player, this.getEquipmentSlot(stack));
            onBroken.accept((Item)item);
        });
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }
}

