/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import net.silentchaos512.gear.api.item.GearDiggerTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public class GearHoeItem
extends HoeItem
implements GearDiggerTool {
    private final Supplier<GearType> gearType;

    public GearHoeItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(ToolMaterial.NETHERITE, -4.0f, 0.0f, properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public TagKey<Block> getToolBlockSet(GearPropertiesData properties) {
        return BlockTags.MINEABLE_WITH_HOE;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return this.getGearType().canPerformAction(itemAbility);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (GearHelper.isBroken(stack)) {
            return InteractionResult.PASS;
        }
        InteractionResult result = GearHelper.useOn(context);
        if (result == InteractionResult.PASS) {
            return super.useOn(context);
        }
        return result;
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getProperties(stack).getNumberInt(this.getDurabilityStat());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (!GearHelper.isBroken(stack)) {
            return super.mineBlock(stack, level, state, pos, miningEntity);
        }
        return true;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        GearHelper.inventoryTick(stack, level, entity, slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

