/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.item.BreakEventHandler;
import net.silentchaos512.gear.api.item.GearDiggerTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.HarvestTier;
import net.silentchaos512.gear.api.property.HarvestTierPropertyValue;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.item.gear.GearSwordItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearHelper;

public class GearMacheteItem
extends GearSwordItem
implements BreakEventHandler,
GearDiggerTool {
    private static final int BREAK_RANGE = 2;

    public GearMacheteItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(gearType, properties);
    }

    @Override
    public void onBlockBreakEvent(ItemStack stack, Player player, Level level, BlockPos pos, BlockState state) {
        if (!player.isCrouching()) {
            GearItemSets.SICKLE.gearItem().breakPlantsInRange(stack, pos, player, 2);
        }
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float axeSpeed = GearHelper.getDestroySpeed(stack, state);
        float speed = Math.max(axeSpeed, super.getDestroySpeed(stack, state));
        if (GearHelper.isCorrectToolForDrops(stack, state, (TagKey<Block>)this.getToolBlockSet(stack))) {
            return speed * 0.4f;
        }
        return speed;
    }

    @Override
    public TagKey<Block> getToolBlockSet(GearPropertiesData properties) {
        return SgTags.Blocks.MINEABLE_WITH_MACHETE;
    }

    @Override
    public Tool createToolProperties(ItemStack gear, GearPropertiesData properties, HolderGetter<Block> blocks) {
        float rawSpeed = properties.getNumber(GearProperties.HARVEST_SPEED);
        float harvestSpeed = Float.isNaN(rawSpeed) || rawSpeed < 0.1f ? 0.1f : rawSpeed;
        HarvestTierPropertyValue harvestTier = properties.getOrDefault(GearProperties.HARVEST_TIER, new HarvestTierPropertyValue(HarvestTier.ZERO));
        return new Tool(List.of(Tool.Rule.deniesDrops((HolderSet)blocks.getOrThrow(((HarvestTier)harvestTier.value()).incorrectForTool())), Tool.Rule.minesAndDrops((HolderSet)blocks.getOrThrow(this.getToolBlockSet(gear)), (float)harvestSpeed), Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Holder.direct((Object)Blocks.COBWEB)}), (float)15.0f), Tool.Rule.overrideSpeed((HolderSet)blocks.getOrThrow(BlockTags.SWORD_INSTANTLY_MINES), (float)Float.MAX_VALUE), Tool.Rule.overrideSpeed((HolderSet)blocks.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)1.5f)), 1.0f, 2, false);
    }
}

