/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.gear.api.item.GearDiggerTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.item.gear.BasicGearItem;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearPickaxeItem
extends BasicGearItem
implements GearDiggerTool {
    private final Supplier<GearType> gearType;

    public GearPickaxeItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public TagKey<Block> getToolBlockSet(GearPropertiesData properties) {
        if (TraitHelper.hasTrait(properties, Const.Traits.SPOON)) {
            return SgTags.Blocks.MINEABLE_WITH_PICKAXE_WITH_SPOON;
        }
        return BlockTags.MINEABLE_WITH_PICKAXE;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (GearHelper.isBroken(context.getItemInHand()) || context.getPlayer() != null && context.getPlayer().isCrouching()) {
            return InteractionResult.PASS;
        }
        InteractionResult result = GearHelper.useOn(context);
        if (result == InteractionResult.PASS) {
            return GearHelper.useAndCheckBroken(context, x$0 -> super.useOn((UseOnContext)x$0));
        }
        return result;
    }
}

