/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.item.gear.GearPickaxeItem;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;

public class GearProspectorHammerItem
extends GearPickaxeItem {
    public GearProspectorHammerItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(gearType, properties);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return this.getGearType().canPerformAction(itemAbility);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        int range = this.getProspectingRange(context.getItemInHand());
        Player player = context.getPlayer();
        Direction face = context.getClickedFace();
        if (range <= 0 || player == null || face.getAxis() == Direction.Axis.Y) {
            return GearHelper.useOn(context);
        }
        if (context.getLevel().isClientSide() || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        Set<BlockState> matches = this.getTargetedBlocks(context, range, face);
        player.displayClientMessage(GearProspectorHammerItem.listFoundBlocks(matches), false);
        GearHelper.attemptDamage(context.getItemInHand(), 2, (LivingEntity)player, context.getHand());
        player.getCooldowns().addCooldown(context.getItemInHand(), 20);
        return InteractionResult.SUCCESS;
    }

    public Integer getProspectingRange(ItemStack stack) {
        return (Integer)Config.Common.prospectorHammerRange.get();
    }

    private static Component listFoundBlocks(Collection<BlockState> blocksFound) {
        return (Component)blocksFound.stream().map(state -> state.getBlock().getName()).reduce((t1, t2) -> t1.append(", ").append((Component)t2)).orElseGet(() -> TextUtil.translate("item", "prospector_hammer.no_finds"));
    }

    public Set<BlockState> getTargetedBlocks(UseOnContext context, int range, Direction face) {
        HashSet<BlockState> matches = new HashSet<BlockState>();
        Direction direction = face.getOpposite();
        for (int i = 0; i < range; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos pos = context.getClickedPos().relative(direction, i).relative(direction.getCounterClockWise(), j).relative(Direction.DOWN, k);
                    BlockState state = context.getLevel().getBlockState(pos);
                    if (!state.is(SgTags.Blocks.PROSPECTOR_HAMMER_TARGETS)) continue;
                    matches.add(state);
                }
            }
        }
        return matches;
    }
}

