/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.BreakEventHandler;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.item.gear.GearAxeItem;
import net.silentchaos512.gear.util.GearHelper;

public class GearSawItem
extends GearAxeItem
implements BreakEventHandler {
    public GearSawItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(gearType, properties);
    }

    @Override
    public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
        super.onRecalculatePost(gear, player, finalProperties);
        if (!GearHelper.isBroken(gear)) {
            gear.set(DataComponents.WEAPON, (Object)new Weapon(2));
        }
    }

    @Override
    public void onBlockBreakEvent(ItemStack stack, Player player, Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide() && GearSawItem.isLog(state) && GearSawItem.detectTree((BlockGetter)level, pos.getX(), pos.getY(), pos.getZ(), state.getBlock())) {
            if (player.getAbilities().instabuild) {
                return;
            }
            TreeBreakResult result = new TreeBreakResult(stack, player);
            this.breakTree(result, level, pos, pos, 0);
            SilentGear.LOGGER.debug("{} chopped down a tree with {} blocks using {}. Max recursion depth: {}", (Object)player.getScoreboardName(), (Object)result.blocksBroken, (Object)stack.getHoverName().getString(), (Object)result.maxDepth);
        }
    }

    private static boolean detectTree(BlockGetter world, int x, int y, int z, Block wood) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        int height = y;
        boolean foundTop = false;
        do {
            if (GearSawItem.checkForLogs(world, pos.relative(Direction.UP, ++height - y))) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int foliageCount = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        BlockState leaves = world.getBlockState((BlockPos)pos.set(xPos, yPos, zPos));
                        if (!GearSawItem.isFoliage(leaves)) continue;
                        ++foliageCount;
                    }
                }
            }
        }
        return foliageCount > 3;
    }

    private static boolean checkForLogs(BlockGetter world, BlockPos pos) {
        return GearSawItem.isLog(world.getBlockState(pos)) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.NORTH))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.SOUTH))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.EAST))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.WEST))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.NORTH).relative(Direction.EAST))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.NORTH).relative(Direction.WEST))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.SOUTH).relative(Direction.EAST))) || GearSawItem.isLog(world.getBlockState(pos.relative(Direction.SOUTH).relative(Direction.WEST)));
    }

    private static boolean isLog(BlockState state) {
        return GearSawItem.isLog(state, null);
    }

    private static boolean isLog(BlockState state, @Nullable TreeBreakResult result) {
        if (result != null && result.firstLog != null) {
            return state.getBlock() == result.firstLog;
        }
        return state.is(BlockTags.LOGS);
    }

    private static boolean isFoliage(BlockState state) {
        return GearSawItem.isFoliage(state, null);
    }

    private static boolean isFoliage(BlockState state, @Nullable TreeBreakResult result) {
        if (state.getBlock() == Blocks.SHROOMLIGHT) {
            return true;
        }
        if (state.hasProperty((Property)LeavesBlock.PERSISTENT) && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
            return false;
        }
        if (result != null && result.firstFoliage != null) {
            return state.getBlock() == result.firstFoliage;
        }
        return state.is(BlockTags.LEAVES) || state.is(BlockTags.WART_BLOCKS);
    }

    private void breakTree(TreeBreakResult result, Level world, BlockPos pos, BlockPos startPos, int recursionDepth) {
        result.maxDepth = recursionDepth;
        if (recursionDepth > (Integer)Config.Common.sawRecursionDepth.get()) {
            return;
        }
        for (int xPos = pos.getX() - 1; xPos <= pos.getX() + 1; ++xPos) {
            for (int yPos = pos.getY() - 1; yPos <= pos.getY() + 1; ++yPos) {
                for (int zPos = pos.getZ() - 1; zPos <= pos.getZ() + 1; ++zPos) {
                    int zDist;
                    int yDist;
                    int xDist;
                    BlockPos localPos = new BlockPos(xPos, yPos, zPos);
                    BlockState localState = world.getBlockState(localPos);
                    Block localBlock = localState.getBlock();
                    boolean isLog = GearSawItem.isLog(localState, result);
                    boolean isFoliage = GearSawItem.isFoliage(localState, result);
                    if (!isLog && !isFoliage) continue;
                    if (isLog && result.firstLog == null) {
                        result.firstLog = localBlock;
                    }
                    if (isFoliage && result.firstFoliage == null) {
                        result.firstFoliage = localBlock;
                    }
                    float localHardness = localState.getDestroySpeed((BlockGetter)world, localPos);
                    if (!this.isCorrectToolForDrops(result.tool, localState) || !(localHardness >= 0.0f) || 9 * (xDist = xPos - startPos.getX()) * xDist + (yDist = yPos - startPos.getY()) * yDist + 9 * (zDist = zPos - startPos.getZ()) * zDist >= 1000) continue;
                    if (!result.player.getAbilities().instabuild) {
                        localBlock.playerDestroy(world, result.player, pos, localState, world.getBlockEntity(pos), result.tool);
                        this.mineBlock(result.tool, world, localState, localPos, (LivingEntity)result.player);
                        ++result.blocksBroken;
                    }
                    world.removeBlock(localPos, false);
                    this.breakTree(result, world, localPos, startPos, recursionDepth + 1);
                }
            }
        }
    }

    private static final class TreeBreakResult {
        final ItemStack tool;
        final Player player;
        int blocksBroken;
        int maxDepth;
        @Nullable
        Block firstLog;
        @Nullable
        Block firstFoliage;

        private TreeBreakResult(ItemStack tool, Player player) {
            this.tool = tool;
            this.player = player;
        }
    }
}

