/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.api.item.BreakEventHandler;
import net.silentchaos512.gear.api.item.GearDiggerTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.item.gear.BasicGearItem;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.util.GearHelper;

public class GearSickleItem
extends BasicGearItem
implements GearDiggerTool,
BreakEventHandler {
    private static final int DURABILITY_USAGE = 3;
    private static final int BREAK_RANGE = 4;
    private static final int HARVEST_RANGE = 2;
    private final Supplier<GearType> gearType;

    public GearSickleItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public TagKey<Block> getToolBlockSet(GearPropertiesData properties) {
        return SgTags.Blocks.MINEABLE_WITH_SICKLE;
    }

    private static boolean canRightClickHarvestBlock(BlockState state) {
        Block block = state.getBlock();
        return block instanceof CropBlock || block instanceof SweetBerryBushBlock;
    }

    private static boolean tryHarvest(ServerLevel level, BlockPos pos, BlockState state, Player player, ItemStack sickle) {
        Block block = state.getBlock();
        BonemealableBlock growable = (BonemealableBlock)block;
        if (!growable.isValidBonemealTarget((LevelReader)level, pos, state)) {
            if (block instanceof SweetBerryBushBlock) {
                GearSickleItem.harvestBerryBush(level, pos, state, player);
            } else {
                GearSickleItem.harvestCrops(level, pos, state, player, sickle, block);
            }
            level.setBlock(pos, GearSickleItem.getHarvestedBlockState(state), 2);
            return true;
        }
        return false;
    }

    private static void harvestBerryBush(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        state.useWithoutItem((Level)level, player, new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Direction.UP, pos, false));
    }

    private static void harvestCrops(ServerLevel world, BlockPos pos, BlockState state, Player player, ItemStack sickle, Block block) {
        NonNullList drops = NonNullList.create();
        drops.addAll((Collection)Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)player, (ItemStack)sickle));
        boolean foundSeed = false;
        for (ItemStack drop : drops) {
            Item item = drop.getItem();
            if (!foundSeed && item instanceof BlockItem && ((BlockItem)item).getBlock() == block) {
                foundSeed = true;
                continue;
            }
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)drop);
        }
    }

    private static BlockState getHarvestedBlockState(BlockState original) {
        if (original.getBlock() instanceof SweetBerryBushBlock) {
            return (BlockState)original.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
        }
        return original.getBlock().defaultBlockState();
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level;
        ItemStack sickle = context.getItemInHand();
        if (GearHelper.isBroken(sickle) || !((level = context.getLevel()) instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = context.getClickedPos();
        BlockState state = serverLevel.getBlockState(pos);
        if (!GearSickleItem.canRightClickHarvestBlock(state)) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        int harvestCount = 0;
        int radius = 2;
        for (int z = pos.getZ() - 2; z <= pos.getZ() + 2; ++z) {
            for (int x = pos.getX() - 2; x <= pos.getX() + 2; ++x) {
                BlockPos target = new BlockPos(x, pos.getY(), z);
                state = serverLevel.getBlockState(target);
                if (!GearSickleItem.canRightClickHarvestBlock(state) || !GearSickleItem.tryHarvest(serverLevel, target, state, player, sickle)) continue;
                ++harvestCount;
            }
        }
        if (harvestCount > 0) {
            int damageToTool = Math.min(3, harvestCount);
            GearHelper.attemptDamage(sickle, damageToTool, (LivingEntity)player, context.getHand());
            player.causeFoodExhaustion(0.02f);
            return InteractionResult.SUCCESS;
        }
        return GearHelper.useOn(context);
    }

    @Override
    public void onBlockBreakEvent(ItemStack stack, Player player, Level level, BlockPos pos, BlockState state) {
        this.breakPlantsInRange(stack, pos, player, 4);
    }

    void breakPlantsInRange(ItemStack sickle, BlockPos pos, Player player, int range) {
        if (GearHelper.isBroken(sickle)) {
            return;
        }
        Level world = player.level();
        BlockState state = world.getBlockState(pos);
        if (!state.is(this.getToolBlockSet(sickle))) {
            return;
        }
        int blocksBroken = 1;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                BlockPos target = new BlockPos(xPos, y, zPos);
                if (xPos == x && zPos == z || world.getBlockState(target) != state || !GearSickleItem.breakExtraBlock(sickle, world, target, player)) continue;
                ++blocksBroken;
            }
        }
    }

    private static boolean breakExtraBlock(ItemStack sickle, Level level, BlockPos pos, Player player) {
        if (level.isEmptyBlock(pos) || !(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (serverPlayer.getAbilities().instabuild) {
            block.playerWillDestroy(level, pos, state, player);
            if (block.onDestroyedByPlayer(state, level, pos, (Player)serverPlayer, sickle, false, state.getFluidState())) {
                block.destroy((LevelAccessor)level, pos, state);
            }
            if (!level.isClientSide()) {
                serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
            return true;
        }
        if (!level.isClientSide() && level instanceof ServerLevel) {
            block.playerWillDestroy(level, pos, state, (Player)serverPlayer);
            if (block.onDestroyedByPlayer(state, level, pos, (Player)serverPlayer, sickle, true, state.getFluidState())) {
                block.destroy((LevelAccessor)level, pos, state);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                block.playerDestroy(level, player, pos, state, blockEntity, sickle);
                block.popExperience((ServerLevel)level, pos, state.getExpDrop((LevelAccessor)level, pos, blockEntity, (Entity)player, sickle));
            }
            serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
        } else {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
            if (block.onDestroyedByPlayer(state, level, pos, (Player)serverPlayer, sickle, true, state.getFluidState())) {
                block.destroy((LevelAccessor)level, pos, state);
            }
            sickle.mineBlock(level, state, pos, (Player)serverPlayer);
        }
        return true;
    }
}

