/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.UseEffects;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.GearWeapon;
import net.silentchaos512.gear.api.property.KineticWeaponPropertyValue;
import net.silentchaos512.gear.api.property.SwingAnimationPropertyValue;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.gear.BasicGearItem;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public class GearSpearItem
extends BasicGearItem
implements GearWeapon {
    private final Supplier<GearType> gearType;

    public GearSpearItem(Supplier<GearType> gearType, Item.Properties properties) {
        super(properties);
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
        GearWeapon.super.onRecalculatePost(gear, player, finalProperties);
        PartInstance primaryPart = GearData.getConstruction(gear).getPrimaryPart();
        MaterialInstance primaryMaterial = primaryPart != null ? primaryPart.getPrimaryMaterial() : null;
        boolean isWood = primaryMaterial != null && (primaryMaterial.is(Const.Materials.WOOD) || primaryMaterial.parentIs(Const.Materials.WOOD));
        gear.set(DataComponents.DAMAGE_TYPE, (Object)new EitherHolder(DamageTypes.SPEAR));
        gear.set(DataComponents.KINETIC_WEAPON, (Object)this.getKineticWeaponComponent(gear, finalProperties));
        gear.set(DataComponents.PIERCING_WEAPON, (Object)new PiercingWeapon(true, false, Optional.of(isWood ? SoundEvents.SPEAR_WOOD_ATTACK : SoundEvents.SPEAR_ATTACK), Optional.of(isWood ? SoundEvents.SPEAR_WOOD_HIT : SoundEvents.SPEAR_HIT)));
        gear.set(DataComponents.ATTACK_RANGE, (Object)new AttackRange(2.0f, 4.5f, 2.0f, 6.5f, 0.125f, 0.5f));
        gear.set(DataComponents.MINIMUM_ATTACK_CHARGE, (Object)Float.valueOf(1.0f));
        gear.set(DataComponents.SWING_ANIMATION, (Object)this.getSwingAnimationComponent(gear, finalProperties));
        gear.set(DataComponents.USE_EFFECTS, (Object)new UseEffects(true, false, 1.0f));
    }

    protected KineticWeapon getKineticWeaponComponent(ItemStack gear, GearPropertiesData properties) {
        KineticWeaponPropertyValue kineticWeapon;
        if (properties.contains(GearProperties.KINETIC_WEAPON) && (kineticWeapon = (KineticWeaponPropertyValue)properties.get(GearProperties.KINETIC_WEAPON)) != null && !GearProperties.KINETIC_WEAPON.get().isZero((KineticWeapon)kineticWeapon.value())) {
            return (KineticWeapon)kineticWeapon.value();
        }
        return GearHelper.Spear.createKineticWeapon(gear, properties);
    }

    protected SwingAnimation getSwingAnimationComponent(ItemStack gear, GearPropertiesData properties) {
        SwingAnimationPropertyValue swingAnimation;
        if (properties.contains(GearProperties.SWING_ANIMATION) && (swingAnimation = (SwingAnimationPropertyValue)properties.get(GearProperties.SWING_ANIMATION)) != null && !GearProperties.SWING_ANIMATION.get().isZero((SwingAnimation)swingAnimation.value())) {
            return (SwingAnimation)swingAnimation.value();
        }
        return GearHelper.Spear.createSwingAnimation(gear, properties);
    }
}

