/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.modifier;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.LootModifier;

public abstract class EnchantedDropsTraitLootModifier
extends LootModifier {
    protected final int traitLevel;

    public EnchantedDropsTraitLootModifier(int traitLevel, LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.traitLevel = traitLevel;
    }

    protected abstract void addEnchantments(HolderLookup.RegistryLookup<Enchantment> var1, ItemEnchantments.Mutable var2, int var3);

    private ItemStack createEnchantedCopy(ItemStack tool, ServerLevel level) {
        ItemStack copy = tool.copy();
        copy.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        Registry registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        EnchantmentHelper.updateEnchantments((ItemStack)copy, enchantments -> this.addEnchantments((HolderLookup.RegistryLookup<Enchantment>)registry, (ItemEnchantments.Mutable)enchantments, this.traitLevel));
        return copy;
    }

    private LootContext createEnchantedLootContext(LootContext original, ItemStack enchantedTool) {
        LootParams.Builder builder = new LootParams.Builder(original.getLevel()).withLuck(original.getLuck()).withParameter(LootContextParams.BLOCK_STATE, (Object)((BlockState)original.getParameter(LootContextParams.BLOCK_STATE))).withParameter(LootContextParams.ORIGIN, (Object)((Vec3)original.getParameter(LootContextParams.ORIGIN))).withParameter(LootContextParams.TOOL, (Object)enchantedTool);
        if (original.hasParameter(LootContextParams.THIS_ENTITY)) {
            builder.withParameter(LootContextParams.THIS_ENTITY, (Object)((Entity)original.getParameter(LootContextParams.THIS_ENTITY)));
        }
        if (original.hasParameter(LootContextParams.BLOCK_ENTITY)) {
            builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)((BlockEntity)original.getParameter(LootContextParams.BLOCK_ENTITY)));
        }
        if (original.hasParameter(LootContextParams.EXPLOSION_RADIUS)) {
            builder.withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)((Float)original.getParameter(LootContextParams.EXPLOSION_RADIUS)));
        }
        LootParams lootParams = builder.create(LootContextParamSets.BLOCK);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!context.hasParameter(LootContextParams.TOOL)) {
            return generatedLoot;
        }
        ItemStack tool = (ItemStack)context.getParameter(LootContextParams.TOOL);
        ItemStack enchantedTool = this.createEnchantedCopy(tool, context.getLevel());
        LootContext newContext = this.createEnchantedLootContext(context, enchantedTool);
        HolderLookup.RegistryLookup lootTableLookup = (HolderLookup.RegistryLookup)context.getLevel().getServer().reloadableRegistries().lookup().lookup(Registries.LOOT_TABLE).orElseThrow();
        Optional lootTableOptional = lootTableLookup.get(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)context.getQueriedLootTableId()));
        if (lootTableOptional.isPresent()) {
            LootTable lootTable = (LootTable)((Holder.Reference)lootTableOptional.get()).value();
            generatedLoot.clear();
            lootTable.getRandomItemsRaw(newContext, arg_0 -> generatedLoot.add(arg_0));
        }
        return generatedLoot;
    }
}

