/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MagmaticTraitLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<MagmaticTraitLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> MagmaticTraitLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, MagmaticTraitLootModifier::new)));

    public MagmaticTraitLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList ret = new ObjectArrayList();
        generatedLoot.forEach(s -> ret.add((Object)MagmaticTraitLootModifier.smelt(s, context)));
        return ret;
    }

    private static ItemStack smelt(ItemStack stack, LootContext context) {
        return context.getLevel().recipeAccess().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel()).map(r -> ((SmeltingRecipe)r.value()).assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)context.getLevel().registryAccess())).filter(s -> !s.isEmpty()).map(s -> s.copyWithCount(stack.getCount() * s.getCount())).orElse(stack);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

