/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.item.gear.GearArrowItem;
import net.silentchaos512.gear.item.gear.GearAxeItem;
import net.silentchaos512.gear.item.gear.GearBowItem;
import net.silentchaos512.gear.item.gear.GearCrossbowItem;
import net.silentchaos512.gear.item.gear.GearCurioItem;
import net.silentchaos512.gear.item.gear.GearDaggerItem;
import net.silentchaos512.gear.item.gear.GearElytraItem;
import net.silentchaos512.gear.item.gear.GearExcavatorItem;
import net.silentchaos512.gear.item.gear.GearFishingRodItem;
import net.silentchaos512.gear.item.gear.GearHammerItem;
import net.silentchaos512.gear.item.gear.GearHoeItem;
import net.silentchaos512.gear.item.gear.GearMaceItem;
import net.silentchaos512.gear.item.gear.GearMacheteItem;
import net.silentchaos512.gear.item.gear.GearMattockItem;
import net.silentchaos512.gear.item.gear.GearPaxelItem;
import net.silentchaos512.gear.item.gear.GearPickaxeItem;
import net.silentchaos512.gear.item.gear.GearProspectorHammerItem;
import net.silentchaos512.gear.item.gear.GearSawItem;
import net.silentchaos512.gear.item.gear.GearShearsItem;
import net.silentchaos512.gear.item.gear.GearShieldItem;
import net.silentchaos512.gear.item.gear.GearShovelItem;
import net.silentchaos512.gear.item.gear.GearSickleItem;
import net.silentchaos512.gear.item.gear.GearSlingshotItem;
import net.silentchaos512.gear.item.gear.GearSpearItem;
import net.silentchaos512.gear.item.gear.GearSwordItem;
import net.silentchaos512.gear.item.gear.GearTridentItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.GearHelper;

public class GearItemSets {
    private static final List<GearItemSet<?>> LIST = new ArrayList();
    public static final GearItemSet<GearSwordItem> SWORD = GearItemSets.set(GearTypes.SWORD, "sword_blade", GearSwordItem::new);
    public static final GearItemSet<GearSwordItem> KATANA = GearItemSets.set(GearTypes.KATANA, "katana_blade", GearSwordItem::new);
    public static final GearItemSet<GearMacheteItem> MACHETE = GearItemSets.set(GearTypes.MACHETE, "machete_blade", GearMacheteItem::new);
    public static final GearItemSet<GearDaggerItem> KNIFE = GearItemSets.set(GearTypes.KNIFE, "knife_blade", GearDaggerItem::new);
    public static final GearItemSet<GearDaggerItem> DAGGER = GearItemSets.set(GearTypes.DAGGER, "dagger_blade", GearDaggerItem::new);
    public static final GearItemSet<GearSpearItem> SPEAR = GearItemSets.set(GearTypes.SPEAR, "spearhead", GearSpearItem::new);
    public static final GearItemSet<GearTridentItem> TRIDENT = GearItemSets.set(GearTypes.TRIDENT, "trident_prongs", GearTridentItem::new);
    public static final GearItemSet<GearMaceItem> MACE = GearItemSets.set(GearTypes.MACE, "mace_core", GearMaceItem::new);
    public static final GearItemSet<GearShieldItem> SHIELD = GearItemSets.set(GearTypes.SHIELD, "shield_plate", GearShieldItem::new);
    public static final GearItemSet<GearBowItem> BOW = GearItemSets.set(GearTypes.BOW, "bow_limbs", GearBowItem::new);
    public static final GearItemSet<GearCrossbowItem> CROSSBOW = GearItemSets.set(GearTypes.CROSSBOW, "crossbow_limbs", GearCrossbowItem::new);
    public static final GearItemSet<GearSlingshotItem> SLINGSHOT = GearItemSets.set(GearTypes.SLINGSHOT, "slingshot_limbs", GearSlingshotItem::new);
    public static final GearItemSet<GearArrowItem> ARROW = GearItemSets.set(GearTypes.ARROW, "arrow_heads", GearArrowItem::new, new Item.Properties().stacksTo(64));
    public static final GearItemSet<GearPickaxeItem> PICKAXE = GearItemSets.set(GearTypes.PICKAXE, "pickaxe_head", GearPickaxeItem::new);
    public static final GearItemSet<GearShovelItem> SHOVEL = GearItemSets.set(GearTypes.SHOVEL, "shovel_head", GearShovelItem::new);
    public static final GearItemSet<GearAxeItem> AXE = GearItemSets.set(GearTypes.AXE, "axe_head", GearAxeItem::new);
    public static final GearItemSet<GearPaxelItem> PAXEL = GearItemSets.set(GearTypes.PAXEL, "paxel_head", GearPaxelItem::new);
    public static final GearItemSet<GearHammerItem> HAMMER = GearItemSets.set(GearTypes.HAMMER, "hammer_head", GearHammerItem::new);
    public static final GearItemSet<GearExcavatorItem> EXCAVATOR = GearItemSets.set(GearTypes.EXCAVATOR, "excavator_head", GearExcavatorItem::new);
    public static final GearItemSet<GearSawItem> SAW = GearItemSets.set(GearTypes.SAW, "saw_blade", GearSawItem::new);
    public static final GearItemSet<GearProspectorHammerItem> PROSPECTOR_HAMMER = GearItemSets.set(GearTypes.PROSPECTOR_HAMMER, "prospector_hammer_head", GearProspectorHammerItem::new);
    public static final GearItemSet<GearHoeItem> HOE = GearItemSets.set(GearTypes.HOE, "hoe_head", GearHoeItem::new);
    public static final GearItemSet<GearMattockItem> MATTOCK = GearItemSets.set(GearTypes.MATTOCK, "mattock_head", GearMattockItem::new);
    public static final GearItemSet<GearSickleItem> SICKLE = GearItemSets.set(GearTypes.SICKLE, "sickle_blade", GearSickleItem::new);
    public static final GearItemSet<GearShearsItem> SHEARS = GearItemSets.set(GearTypes.SHEARS, "shear_blades", GearShearsItem::new);
    public static final GearItemSet<GearFishingRodItem> FISHING_ROD = GearItemSets.set(GearTypes.FISHING_ROD, "fishing_reel_and_hook", GearFishingRodItem::new);
    public static final GearItemSet<GearArmorItem> HELMET = GearItemSets.set(GearTypes.HELMET, "helmet_plates", (gt, props) -> new GearArmorItem((Supplier<GearType>)gt, ArmorType.HELMET, (Item.Properties)props));
    public static final GearItemSet<GearArmorItem> CHESTPLATE = GearItemSets.set(GearTypes.CHESTPLATE, "chestplate_plates", (gt, props) -> new GearArmorItem((Supplier<GearType>)gt, ArmorType.CHESTPLATE, (Item.Properties)props));
    public static final GearItemSet<GearArmorItem> LEGGINGS = GearItemSets.set(GearTypes.LEGGINGS, "legging_plates", (gt, props) -> new GearArmorItem((Supplier<GearType>)gt, ArmorType.LEGGINGS, (Item.Properties)props));
    public static final GearItemSet<GearArmorItem> BOOTS = GearItemSets.set(GearTypes.BOOTS, "boot_plates", (gt, props) -> new GearArmorItem((Supplier<GearType>)gt, ArmorType.BOOTS, (Item.Properties)props));
    public static final GearItemSet<GearElytraItem> ELYTRA = GearItemSets.set(GearTypes.ELYTRA, "elytra_wings", GearElytraItem::new);
    public static final GearItemSet<GearCurioItem> RING = GearItemSets.set(GearTypes.RING, "ring_shank", (gt, props) -> new GearCurioItem((Supplier<GearType>)gt, "ring", (Item.Properties)props), GearItemSets.unstackableItemProperties());
    public static final GearItemSet<GearCurioItem> BRACELET = GearItemSets.set(GearTypes.BRACELET, "bracelet_band", (gt, props) -> new GearCurioItem((Supplier<GearType>)gt, "bracelet", (Item.Properties)props), GearItemSets.unstackableItemProperties());
    public static final GearItemSet<GearCurioItem> NECKLACE = GearItemSets.set(GearTypes.NECKLACE, "necklace_chain", (gt, props) -> new GearCurioItem((Supplier<GearType>)gt, "necklace", (Item.Properties)props), GearItemSets.unstackableItemProperties());

    private static <I extends Item> GearItemSet<I> set(DeferredHolder<GearType, GearType> type, String partName, BiFunction<Supplier<GearType>, Item.Properties, I> itemFactory) {
        return GearItemSets.set(type, partName, itemFactory, GearHelper.getBaseItemProperties());
    }

    private static <I extends Item> GearItemSet<I> set(DeferredHolder<GearType, GearType> type, String partName, BiFunction<Supplier<GearType>, Item.Properties, I> itemFactory, Item.Properties gearItemProperties) {
        return GearItemSets.set(new GearItemSet<I>(type, partName, itemFactory, gearItemProperties));
    }

    private static <I extends Item> GearItemSet<I> set(GearItemSet<I> set) {
        LIST.add(set);
        return set;
    }

    static void registerGearItems() {
        LIST.forEach(set -> set.registerGearItem(SgItems.ITEMS));
    }

    static void registerMainPartItems() {
        LIST.forEach(set -> set.registerMainPartItem(SgItems.ITEMS));
    }

    static void registerBlueprintItems() {
        LIST.forEach(set -> set.registerBlueprintItem(SgItems.ITEMS));
    }

    static void registerTemplateItems() {
        LIST.forEach(set -> set.registerTemplateItem(SgItems.ITEMS));
    }

    public static Iterator<GearItemSet<?>> getIterator() {
        return LIST.iterator();
    }

    private static Item.Properties unstackableItemProperties() {
        return new Item.Properties().stacksTo(1);
    }
}

