/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.renderer.SgClientItemExtensions;
import net.silentchaos512.gear.client.renderer.entity.GearArrowRenderer;
import net.silentchaos512.gear.client.renderer.entity.GearThrownTridentRenderer;
import net.silentchaos512.gear.entity.GearFishingHook;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;
import net.silentchaos512.gear.entity.projectile.GearThrownTrident;
import net.silentchaos512.gear.entity.projectile.SlingshotProjectile;
import net.silentchaos512.gear.setup.GearItemSets;

public final class SgEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"silentgear");
    public static final DeferredHolder<EntityType<?>, EntityType<GearArrowEntity>> ARROW = SgEntities.register("arrow", GearArrowEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<GearFishingHook>> FISHING_HOOK = SgEntities.register("fishing_hook", GearFishingHook::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<SlingshotProjectile>> SLINGSHOT_PROJECTILE = SgEntities.register("slingshot_projectile", SlingshotProjectile::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<GearThrownTrident>> TRIDENT_PROJECTILE = ENTITIES.register("thrown_trident", () -> EntityType.Builder.of(GearThrownTrident::new, (MobCategory)MobCategory.MISC).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)SilentGear.getId("thrown_trident"))));

    private SgEntities() {
        throw new IllegalAccessError("Utility class");
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.EntityFactory<T> factory, MobCategory type) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)type).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)SilentGear.getId(name))));
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="silentgear")
    public static class Events {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ARROW.get(), GearArrowRenderer::new);
            event.registerEntityRenderer((EntityType)FISHING_HOOK.get(), FishingHookRenderer::new);
            event.registerEntityRenderer((EntityType)SLINGSHOT_PROJECTILE.get(), ThrownItemRenderer::new);
            event.registerEntityRenderer((EntityType)TRIDENT_PROJECTILE.get(), GearThrownTridentRenderer::new);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem((IClientItemExtensions)new SgClientItemExtensions(), new Item[]{GearItemSets.TRIDENT.gearItem()});
        }

        @SubscribeEvent
        public static void registerAdditional(ModelEvent.RegisterStandalone event) {
        }
    }
}

