/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.JewelerKitItem;
import net.silentchaos512.gear.item.ModKitItem;
import net.silentchaos512.gear.item.ProcessedMaterialItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.lib.util.TimeUtils;

public final class SgItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"silentgear");
    public static final DeferredItem<BlueprintPackageItem> BLUEPRINT_PACKAGE = SgItems.register("blueprint_package", BlueprintPackageItem::new);
    public static final DeferredItem<Item> MOD_KIT = SgItems.register("mod_kit", ModKitItem::new, properties -> properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    public static final DeferredItem<Item> VERY_CRUDE_REPAIR_KIT = SgItems.register("very_crude_repair_kit", p -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitVeryCrudeCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitVeryCrudeEfficiency).get(), (Item.Properties)p), properties -> properties.stacksTo(1).rarity(Rarity.COMMON));
    public static final DeferredItem<Item> CRUDE_REPAIR_KIT = SgItems.register("crude_repair_kit", p -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitCrudeCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitCrudeEfficiency).get(), (Item.Properties)p), properties -> properties.stacksTo(1).rarity(Rarity.COMMON));
    public static final DeferredItem<Item> STURDY_REPAIR_KIT = SgItems.register("sturdy_repair_kit", p -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitSturdyCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitSturdyEfficiency).get(), (Item.Properties)p), properties -> properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    public static final DeferredItem<Item> CRIMSON_REPAIR_KIT = SgItems.register("crimson_repair_kit", p -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitCrimsonCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitCrimsonEfficiency).get(), (Item.Properties)p), properties -> properties.stacksTo(1).rarity(Rarity.RARE));
    public static final DeferredItem<Item> AZURE_REPAIR_KIT = SgItems.register("azure_repair_kit", p -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitAzureCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitAzureEfficiency).get(), (Item.Properties)p), properties -> properties.stacksTo(1).rarity(Rarity.EPIC));
    public static final DeferredItem<Item> COATING_SMITHING_TEMPLATE = SgItems.register("coating_smithing_template", Item::new);
    public static final DeferredItem<Item> CRUDE_KNIFE = SgItems.register("crude_knife", Item::new, properties -> properties.durability(32));
    public static final DeferredItem<Item> CRUDE_HAMMER = SgItems.register("crude_hammer", Item::new, properties -> properties.durability(32));
    public static final DeferredItem<BlueprintBookItem> BLUEPRINT_BOOK = SgItems.register("blueprint_book", BlueprintBookItem::new, properties -> properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    public static final DeferredItem<PartBlueprintItem> JEWELER_TOOLS = SgItems.register("jeweler_tools", p -> new JewelerKitItem((Supplier<PartType>)PartTypes.SETTING, BlueprintType.BLUEPRINT, (Item.Properties)p), SgItems.unstackableProps());
    public static final DeferredItem<PartBlueprintItem> ROD_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.ROD, false);
    public static final DeferredItem<PartBlueprintItem> TIP_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.TIP, false);
    @Deprecated
    public static final DeferredItem<PartBlueprintItem> COATING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.COATING, false);
    public static final DeferredItem<PartBlueprintItem> GRIP_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.GRIP, false);
    public static final DeferredItem<PartBlueprintItem> BINDING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.BINDING, false);
    public static final DeferredItem<PartBlueprintItem> LINING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.LINING, false);
    public static final DeferredItem<PartBlueprintItem> CORD_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.CORD, false);
    public static final DeferredItem<PartBlueprintItem> FLETCHING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.FLETCHING, false);
    public static final DeferredItem<PartBlueprintItem> ROD_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> TIP_TEMPLATE;
    @Deprecated
    public static final DeferredItem<PartBlueprintItem> COATING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> GRIP_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> BINDING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> LINING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> CORD_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> FLETCHING_TEMPLATE;
    public static final DeferredItem<CompoundPartItem> ROD;
    public static final DeferredItem<CompoundPartItem> TIP;
    @Deprecated
    public static final DeferredItem<CompoundPartItem> COATING;
    public static final DeferredItem<CompoundPartItem> GRIP;
    public static final DeferredItem<CompoundPartItem> BINDING;
    public static final DeferredItem<CompoundPartItem> LINING;
    public static final DeferredItem<CompoundPartItem> CORD;
    public static final DeferredItem<CompoundPartItem> FLETCHING;
    public static final DeferredItem<CompoundPartItem> SETTING;
    public static final DeferredItem<CompoundMaterialItem> ALLOY_INGOT;
    public static final DeferredItem<CompoundMaterialItem> CRUDE_ALLOY;
    public static final DeferredItem<CompoundMaterialItem> HYBRID_GEM;
    public static final DeferredItem<CompoundMaterialItem> MIXED_FABRIC;
    public static final DeferredItem<CompoundMaterialItem> SUPER_ALLOY;
    public static final DeferredItem<CustomMaterialItem> CUSTOM_INGOT;
    public static final DeferredItem<CustomMaterialItem> CUSTOM_GEM;
    public static final DeferredItem<ProcessedMaterialItem> SHEET_METAL;
    public static final DeferredItem<SlingshotAmmoItem> PEBBLE;
    public static final DeferredItem<BlockItem> FLAX_SEEDS;
    public static final DeferredItem<BlockItem> FLUFFY_SEEDS;
    public static final DeferredItem<Item> NETHER_BANANA;
    public static final DeferredItem<Item> GOLDEN_NETHER_BANANA;
    public static final DeferredItem<Item> NETHERWOOD_CHARCOAL;

    private SgItems() {
    }

    private static UnaryOperator<Item.Properties> baseProps() {
        return UnaryOperator.identity();
    }

    public static UnaryOperator<Item.Properties> unstackableProps() {
        return properties -> properties.stacksTo(1);
    }

    static <T extends Item> DeferredItem<T> register(String name, Function<Item.Properties, T> item) {
        return ITEMS.registerItem(name, item);
    }

    static <T extends Item> DeferredItem<T> register(String name, Function<Item.Properties, T> item, UnaryOperator<Item.Properties> properties) {
        return ITEMS.registerItem(name, item, properties);
    }

    private static DeferredItem<BlockItem> registerSeed(String name, Supplier<? extends Block> plantBlock) {
        return ITEMS.registerSimpleBlockItem(name, plantBlock);
    }

    private static DeferredItem<CompoundPartItem> registerCompoundPart(String name, DeferredHolder<PartType, PartType> partType) {
        return SgItems.register(name, props -> new CompoundPartItem((Supplier<PartType>)partType, (Item.Properties)props), SgItems.baseProps());
    }

    @Deprecated
    private static DeferredItem<PartBlueprintItem> registerPartBlueprint(DeferredHolder<PartType, PartType> partType, boolean singleUse) {
        String name = partType.getId().getPath() + "_" + (singleUse ? "template" : "blueprint");
        BlueprintType blueprintType = singleUse ? BlueprintType.TEMPLATE : BlueprintType.BLUEPRINT;
        return SgItems.register(name, props -> new PartBlueprintItem((Supplier<PartType>)partType, blueprintType, (Item.Properties)props), SgItems.baseProps());
    }

    private static DeferredItem<CompoundMaterialItem> registerCompoundMaterial(String name) {
        return SgItems.register(name, CompoundMaterialItem::new, SgItems.baseProps());
    }

    public static <T> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).filter(clazz::isInstance).map(item -> item).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).filter(predicate).collect(Collectors.toList());
    }

    static {
        GearItemSets.registerBlueprintItems();
        ROD_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.ROD, true);
        TIP_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.TIP, true);
        COATING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.COATING, true);
        GRIP_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.GRIP, true);
        BINDING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.BINDING, true);
        LINING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.LINING, true);
        CORD_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.CORD, true);
        FLETCHING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.FLETCHING, true);
        GearItemSets.registerTemplateItems();
        GearItemSets.registerMainPartItems();
        ROD = SgItems.registerCompoundPart("rod", PartTypes.ROD);
        TIP = SgItems.registerCompoundPart("tip", PartTypes.TIP);
        COATING = SgItems.registerCompoundPart("coating", PartTypes.COATING);
        GRIP = SgItems.registerCompoundPart("grip", PartTypes.GRIP);
        BINDING = SgItems.registerCompoundPart("binding", PartTypes.BINDING);
        LINING = SgItems.registerCompoundPart("lining", PartTypes.LINING);
        CORD = SgItems.registerCompoundPart("cord", PartTypes.CORD);
        FLETCHING = SgItems.registerCompoundPart("fletching", PartTypes.FLETCHING);
        SETTING = SgItems.registerCompoundPart("setting", PartTypes.SETTING);
        ALLOY_INGOT = SgItems.register("alloy_ingot", CompoundMaterialItem::new);
        CRUDE_ALLOY = SgItems.register("crude_alloy", CompoundMaterialItem::new);
        HYBRID_GEM = SgItems.register("hybrid_gem", CompoundMaterialItem::new);
        MIXED_FABRIC = SgItems.register("mixed_fabric", CompoundMaterialItem::new);
        SUPER_ALLOY = SgItems.register("super_alloy", CompoundMaterialItem::new);
        CUSTOM_INGOT = SgItems.register("custom_ingot", CustomMaterialItem::new);
        CUSTOM_GEM = SgItems.register("custom_gem", CustomMaterialItem::new);
        SHEET_METAL = SgItems.register("sheet_metal", ProcessedMaterialItem::new);
        CraftingItems.register(ITEMS);
        PEBBLE = SgItems.register("pebble", SlingshotAmmoItem::new);
        FLAX_SEEDS = SgItems.registerSeed("flax_seeds", () -> (Block)SgBlocks.FLAX_PLANT.get());
        FLUFFY_SEEDS = SgItems.registerSeed("fluffy_seeds", () -> (Block)SgBlocks.FLUFFY_PLANT.get());
        NETHER_BANANA = SgItems.register("nether_banana", props -> new Item(props.food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.4f).build())));
        GOLDEN_NETHER_BANANA = SgItems.register("golden_nether_banana", props -> new Item(props.food(new FoodProperties.Builder().nutrition(10).saturationModifier(1.0f).alwaysEdible().build(), Consumables.defaultFood().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(List.of(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, TimeUtils.ticksFromMinutes((float)10.0f)), new MobEffectInstance(MobEffects.RESISTANCE, TimeUtils.ticksFromMinutes((float)5.0f)), new MobEffectInstance(MobEffects.REGENERATION, TimeUtils.ticksFromSeconds((float)10.0f))))).build())));
        NETHERWOOD_CHARCOAL = SgItems.register("netherwood_charcoal", Item::new);
        GearItemSets.registerGearItems();
    }
}

