/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.loot.condition.HasTraitCondition;
import net.silentchaos512.gear.loot.function.SetPartsFunction;
import net.silentchaos512.gear.loot.modifier.BonusDropsTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.FortuneTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.MagmaticTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.SilkTouchTraitLootModifier;

public final class SgLoot {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"silentgear");
    public static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"silentgear");
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"silentgear");
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> HAS_TRAIT = SgLoot.registerCondition("has_trait", () -> new LootItemConditionType(HasTraitCondition.CODEC));
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<? extends LootItemConditionalFunction>> SET_PARTS = SgLoot.registerFunction("set_parts", () -> new LootItemFunctionType(SetPartsFunction.CODEC));
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<BonusDropsTraitLootModifier>> BONUS_DROPS_TRAIT = SgLoot.registerModifier("bonus_drops_trait", BonusDropsTraitLootModifier.CODEC);
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<MagmaticTraitLootModifier>> MAGMATIC_SMELTING = SgLoot.registerModifier("magmatic_smelting", MagmaticTraitLootModifier.CODEC);
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<SilkTouchTraitLootModifier>> SILK_TOUCH_TRAIT = SgLoot.registerModifier("silk_touch_trait", SilkTouchTraitLootModifier.CODEC);
    public static final DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<FortuneTraitLootModifier>> FORTUNE_TRAIT = SgLoot.registerModifier("fortune_trait", FortuneTraitLootModifier.CODEC);

    private SgLoot() {
    }

    private static <T extends LootItemConditionType> DeferredHolder<LootItemConditionType, T> registerCondition(String name, Supplier<T> condition) {
        return LOOT_CONDITIONS.register(name, condition);
    }

    private static <T extends LootItemFunctionType<? extends LootItemConditionalFunction>> DeferredHolder<LootItemFunctionType<?>, T> registerFunction(String name, Supplier<T> condition) {
        return LOOT_FUNCTIONS.register(name, condition);
    }

    private static <T extends IGlobalLootModifier> DeferredHolder<MapCodec<? extends IGlobalLootModifier>, MapCodec<T>> registerModifier(String name, Supplier<MapCodec<T>> codec) {
        return LOOT_MODIFIERS.register(name, codec);
    }

    @EventBusSubscriber
    public static final class Injector {
        private Injector() {
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            Tables.get(event.getName()).ifPresent(injectorName -> {
                SilentGear.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
                event.getTable().addPool(LootPool.lootPool().name("silentgear_injected").add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)injectorName)).build());
            });
        }

        public static final class Tables {
            private static final Map<Identifier, ResourceKey<LootTable>> MAP = new HashMap<Identifier, ResourceKey<LootTable>>();
            public static final Identifier NETHER_BRIDGE = Tables.inject((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
            public static final Identifier BASTION_TREASURE = Tables.inject((ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE);
            public static final Identifier BASTION_OTHER = Tables.inject((ResourceKey<LootTable>)BuiltInLootTables.BASTION_OTHER);
            public static final Identifier BASTION_BRIDGE = Tables.inject((ResourceKey<LootTable>)BuiltInLootTables.BASTION_BRIDGE);
            public static final Identifier RUINED_PORTAL = Tables.inject((ResourceKey<LootTable>)BuiltInLootTables.RUINED_PORTAL);

            public static Optional<ResourceKey<LootTable>> get(Identifier lootTable) {
                return Optional.ofNullable(MAP.get(lootTable));
            }

            private static Identifier inject(ResourceKey<LootTable> lootTable) {
                Identifier originalId = lootTable.identifier();
                Identifier newId = SilentGear.getId("inject/" + originalId.getNamespace() + "/" + originalId.getPath());
                MAP.put(originalId, (ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)newId));
                return newId;
            }
        }
    }

    public static final class Tables {
        public static final ResourceKey<LootTable> DROPS_LEATHER_SCRAPS_LOW = Tables.table("drops/leather_scraps_low");
        public static final ResourceKey<LootTable> DROPS_LEATHER_SCRAPS_HIGH = Tables.table("drops/leather_scraps_high");
        public static final ResourceKey<LootTable> DROPS_FINE_SILK_LOW = Tables.table("drops/fine_silk_low");
        public static final ResourceKey<LootTable> DROPS_FINE_SILK_HIGH = Tables.table("drops/fine_silk_high");
        public static final ResourceKey<LootTable> DROPS_SINEW = Tables.table("drops/sinew");

        private static ResourceKey<LootTable> table(String path) {
            return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)SilentGear.getId(path));
        }
    }
}

