/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;

public class CodecUtils {
    private CodecUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> StreamCodec<FriendlyByteBuf, TagKey<T>> tagStreamCodec(ResourceKey<? extends Registry<T>> registryKey) {
        return StreamCodec.of((buf, val) -> buf.writeIdentifier(val.location()), buf -> TagKey.create((ResourceKey)registryKey, (Identifier)buf.readIdentifier()));
    }

    public static <T> Codec<List<T>> singleOrListCodec(Codec<T> codec) {
        return Codec.either(codec, (Codec)Codec.list(codec)).xmap(either -> (List)either.map(Collections::singletonList, list -> list), list -> {
            if (list.size() == 1) {
                return Either.left(list.getFirst());
            }
            return Either.right((Object)list);
        });
    }

    public static <B extends FriendlyByteBuf, T> void encodeList(B buf, Collection<T> list, StreamCodec<B, T> streamCodec) {
        buf.writeVarInt(list.size());
        for (T t : list) {
            streamCodec.encode(buf, t);
        }
    }

    public static <B extends FriendlyByteBuf, T> List<T> decodeList(B buf, StreamCodec<B, T> streamCodec) {
        int count = buf.readVarInt();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            list.add(streamCodec.decode(buf));
        }
        return list;
    }

    public static JsonElement encodeIngredient(Ingredient ingredient) {
        return (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).getOrThrow();
    }

    public static <T> Codec<T> byModNameCodec(Registry<T> registry) {
        return CodecUtils.referenceHolderWithLifecycle(registry).flatComapMap(Holder.Reference::value, t -> CodecUtils.safeCastToReference(registry, registry.wrapAsHolder(t)));
    }

    private static <T> Codec<Holder.Reference<T>> referenceHolderWithLifecycle(Registry<T> registry) {
        Codec codec = Identifier.CODEC.comapFlatMap(p_315852_ -> registry.get(p_315852_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.key()) + ": " + String.valueOf(p_315852_))), p_325513_ -> SilentGear.getId(p_325513_.key().identifier().toString()));
        return ExtraCodecs.overrideLifecycle((Codec)codec, p_325514_ -> registry.registrationInfo(p_325514_.key()).map(RegistrationInfo::lifecycle).orElse(Lifecycle.experimental()));
    }

    private static <T> DataResult<Holder.Reference<T>> safeCastToReference(Registry<T> registry, Holder<T> p_326365_) {
        DataResult dataResult;
        Holder holder = p_326365_.getDelegate();
        if (holder instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)holder;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(registry.key()) + ": " + String.valueOf(p_326365_));
        }
        return dataResult;
    }
}

