/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.util.NameUtils;
import org.jetbrains.annotations.Nullable;

public final class GearData {
    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    public static GearPropertiesData getProperties(ItemStack gear) {
        return GearData.getProperties(gear, null);
    }

    public static GearPropertiesData getProperties(ItemStack gear, @javax.annotation.Nullable Player player) {
        GearPropertiesData data = (GearPropertiesData)gear.get(SgDataComponents.GEAR_PROPERTIES);
        if (data != null) {
            return data;
        }
        GearData.recalculateGearData(gear, null);
        return (GearPropertiesData)gear.getOrDefault(SgDataComponents.GEAR_PROPERTIES, (Object)GearPropertiesData.EMPTY);
    }

    public static GearConstructionData getConstruction(ItemStack gear) {
        if (!(gear.getItem() instanceof GearItem)) {
            throw new IllegalArgumentException("Not a gear item: " + String.valueOf(gear));
        }
        return (GearConstructionData)gear.getOrDefault(SgDataComponents.GEAR_CONSTRUCTION, (Object)GearConstructionData.EMPTY);
    }

    public static void recalculateGearData(ItemStack gear, @javax.annotation.Nullable Player player) {
        GearConstructionData gearConstructionData = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        try {
            GearType gearType = GearHelper.getType(gear);
            GearData.tryRecalculateGearData(gear, player, gearType, gearConstructionData);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.forThrowable((Throwable)ex, (String)"Failed to recalculate gear item properties");
            CrashReportCategory itemCategory = report.addCategory("Gear Item");
            itemCategory.setDetail("Name", (Object)(gear.getHoverName().getString() + " (" + String.valueOf(NameUtils.fromItem((ItemStack)gear)) + ")"));
            itemCategory.setDetail("Data", gearConstructionData != null ? gearConstructionData : "null");
            throw new ReportedException(report);
        }
    }

    private static void tryRecalculateGearData(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearConstructionData gearConstructionData) {
        if (gearConstructionData == null) {
            return;
        }
        PartList parts = gearConstructionData.parts();
        if (parts.isEmpty() || parts.getMains().isEmpty()) {
            SilentGear.LOGGER.debug("Not recalculating stats for {}", (Object)GearData.getPlayersItemNameText(gear, player));
        }
        GearPropertiesData oldProperties = (GearPropertiesData)gear.get(SgDataComponents.GEAR_PROPERTIES);
        GearData.onRecalculatePre(gear, player, oldProperties, gearConstructionData);
        GearPropertiesData baseProperties = GearData.calculateBaseProperties(gear, player, gearType, gearConstructionData);
        GearPropertyMap bonusValues = GearData.calculateBonusProperties(gear, player, gearType, baseProperties);
        GearPropertiesData finalProperties = GearData.calculateFinalProperties(gear, player, gearType, baseProperties, bonusValues);
        gear.set(SgDataComponents.GEAR_PROPERTIES, (Object)finalProperties);
        GearData.printStatsForDebugging(gear, oldProperties, baseProperties, bonusValues, finalProperties);
        GearData.onRecalculatePost(gear, player, finalProperties);
    }

    private static void onRecalculatePre(ItemStack gear, @javax.annotation.Nullable Player player, @javax.annotation.Nullable GearPropertiesData oldProperties, GearConstructionData gearConstructionData) {
        Component itemName = GearHelper.getItemName(gear, gearConstructionData);
        if (itemName != null) {
            gear.set(DataComponents.ITEM_NAME, (Object)itemName);
        }
        if (oldProperties == null) {
            return;
        }
        gear.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        Item item = gear.getItem();
        if (item instanceof GearItem) {
            GearItem gearItem = (GearItem)item;
            gearItem.onRecalculatePre(gear, player, oldProperties, gearConstructionData);
        }
        for (TraitInstance trait : oldProperties.getTraits()) {
            if (!trait.isValid()) continue;
            trait.getTrait().onRecalculatePre(gear, trait.getLevel());
        }
    }

    private static void onRecalculatePost(ItemStack gear, @javax.annotation.Nullable Player player, GearPropertiesData finalProperties) {
        Item item = gear.getItem();
        if (item instanceof GearItem) {
            GearItem gearItem = (GearItem)item;
            gearItem.onRecalculatePost(gear, player, finalProperties);
        }
        GearData.setGearAttributeModifiers(gear, finalProperties);
        GearData.setGearDataComponentsFromProperties(gear, finalProperties);
        GearData.modifyEnchantmentData(gear, player);
        for (TraitInstance trait : finalProperties.getTraits()) {
            trait.getTrait().onRecalculatePost(gear, trait.getLevel());
        }
    }

    private static void setGearAttributeModifiers(ItemStack gear, GearPropertiesData finalProperties) {
        ItemAttributeModifiers.Builder attributesBuilder = ItemAttributeModifiers.builder();
        Item item = gear.getItem();
        if (item instanceof GearItem) {
            GearItem gearItem = (GearItem)item;
            gearItem.buildAttributes(gear, attributesBuilder);
        }
        for (GearProperty<?, ? extends GearPropertyValue<?>> gearProperty : finalProperties.keySet()) {
            GearData.addAttributesForProperty(gear, attributesBuilder, finalProperties, gearProperty);
        }
        for (TraitInstance traitInstance : TraitHelper.getTraits(gear)) {
            TraitActionContext context = new TraitActionContext(null, traitInstance, gear);
            traitInstance.getTrait().onGetAttributeModifiers(context, attributesBuilder);
        }
        gear.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)attributesBuilder.build());
    }

    private static void setGearDataComponentsFromProperties(ItemStack gear, GearPropertiesData finalProperties) {
        for (GearProperty<?, ? extends GearPropertyValue<?>> gearProperty : finalProperties.keySet()) {
            GearData.addDataComponentsForProperty(gear, finalProperties, gearProperty);
        }
    }

    private static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> void addAttributesForProperty(ItemStack stack, ItemAttributeModifiers.Builder builder, GearPropertiesData propertiesData, GearProperty<?, ?> propertyIn) {
        GearProperty<?, ?> property = propertyIn;
        Object valueInstance = propertiesData.get(property);
        if (valueInstance != null) {
            T value = ((GearPropertyValue)valueInstance).value();
            property.addAttributes(stack, value, builder);
        }
    }

    private static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> void addDataComponentsForProperty(ItemStack stack, GearPropertiesData propertiesData, GearProperty<?, ?> propertyIn) {
        GearProperty<?, ?> property = propertyIn;
        Object valueInstance = propertiesData.get(property);
        if (valueInstance != null) {
            T value = ((GearPropertyValue)valueInstance).value();
            property.addDataComponents(stack, value);
        }
    }

    private static GearPropertiesData calculateBaseProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearConstructionData gearConstructionData) {
        PartList parts = gearConstructionData.parts();
        GearPropertyMap propertyMods = parts.getPropertyModifiersFromParts(gearType);
        LinkedHashMap finalBaseValues = new LinkedHashMap();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (property.isForMaterialsOnly()) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            Collection<GearPropertyValue<?>> modifiers = propertyMods.get(key);
            GearType statGearType = propertyMods.getMostSpecificKey(key).gearType();
            Object value = property.computeUncheckedForGear(gearType, statGearType, modifiers, parts, gear);
            finalBaseValues.put(property, (GearPropertyValue<?>)value);
        }
        return new GearPropertiesData(finalBaseValues);
    }

    private static GearPropertyMap calculateBonusProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearPropertiesData baseProperties) {
        GearPropertyMap bonusProperties = new GearPropertyMap();
        List traits = (List)baseProperties.getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty()).value();
        Integer damageValue = (Integer)gear.getOrDefault(DataComponents.DAMAGE, (Object)0);
        int baseDurability = gearType.getBaseDurability(baseProperties);
        float damageRatio = Mth.clamp((float)((float)damageValue.intValue() / (float)baseDurability), (float)0.0f, (float)1.0f);
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (property == GearProperties.TRAITS || !baseProperties.contains(property)) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            for (TraitInstance trait : traits) {
                Object baseValue = baseProperties.get(property);
                assert (baseValue != null);
                bonusProperties.putAll(key, trait.getTrait().getBonusProperties(trait.getLevel(), player, property, (GearPropertyValue<?>)baseValue, damageRatio));
            }
            GearPropertyValue<?> configBonus = Config.Common.getPropertyBonusMultiplier(property);
            if (configBonus == null) continue;
            bonusProperties.put(key, configBonus);
        }
        return bonusProperties;
    }

    private static GearPropertiesData calculateFinalProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearPropertiesData baseProperties, GearPropertyMap bonusProperties) {
        GearPropertyMap combinedMods = new GearPropertyMap();
        LinkedHashMap finalValues = new LinkedHashMap();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (!baseProperties.contains(property)) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            combinedMods.put(key, (GearPropertyValue<?>)baseProperties.get(property));
            combinedMods.putAll(key, bonusProperties.get(key));
            finalValues.put(property, (GearPropertyValue<?>)property.computeUnchecked(true, gearType, gearType, combinedMods.get(key)));
        }
        return new GearPropertiesData(finalValues);
    }

    private static void modifyEnchantmentData(ItemStack gear, @javax.annotation.Nullable Player player) {
        String playersItemText = GearData.getPlayersItemNameText(gear, player);
        if (gear.isEnchanted() && ((Boolean)Config.Common.forceRemoveEnchantments.get()).booleanValue()) {
            SilentGear.LOGGER.debug("Forcibly removing all enchantments from {} as per config settings", (Object)playersItemText);
            gear.set(DataComponents.ENCHANTMENTS, null);
        }
    }

    private static String getPlayersItemNameText(ItemStack gear, @Nullable Player player) {
        String playerName = player != null ? player.getScoreboardName() : "somebody";
        return String.format("%s's %s", playerName, gear.getHoverName().getString());
    }

    private static void printStatsForDebugging(ItemStack stack, @javax.annotation.Nullable GearPropertiesData oldProperties, GearPropertiesData baseProperties, GearPropertyMap bonusValues, GearPropertiesData newProperties) {
        if (oldProperties != null && Config.Common.isLoaded() && ((Boolean)Config.Common.propertiesDebugLogging.get()).booleanValue()) {
            SilentGear.LOGGER.debug("{}: properties updated", (Object)stack.getDisplayName().getString());
            GearType gearType = GearHelper.getType(stack);
            for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
                Object oldValue = oldProperties.get(property);
                Object newValue = newProperties.get(property);
                SilentGear.LOGGER.debug(" - {}: {} -> {} -- base: {}, bonuses: [{}]", (Object)property.getDisplayName().getString(), oldValue, newValue, baseProperties.get(property), bonusValues.get(PropertyKey.of(property, gearType)));
            }
        }
    }

    @javax.annotation.Nullable
    public static PartInstance getPartOfType(ItemStack stack, PartType type) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return null;
        }
        for (PartInstance part : data.parts()) {
            if (part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOfType(ItemStack stack, PartType type) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return false;
        }
        for (PartInstance part : data.parts()) {
            if (part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void addUpgradePart(ItemStack gear, PartInstance part) {
        if (!GearHelper.isGear(gear) || !part.isValid()) {
            return;
        }
        ArrayList<PartInstance> parts = new ArrayList<PartInstance>(GearData.getConstruction(gear).parts());
        if (!part.get().canAddToGear(gear, part)) {
            return;
        }
        if (part.get().replacesExistingInPosition(part)) {
            parts.removeIf(p -> p.getType() == part.getType());
        }
        part.onAddToGear(gear);
        for (PartInstance partInList : parts) {
            if (partInList.get() != part.get()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, PartType partType, Predicate<PartInstance> predicate) {
        for (PartInstance partData : GearData.getConstruction(gear).parts()) {
            if (!predicate.test(partData)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, GearPart part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        for (PartInstance partInstance : GearData.getConstruction(gear).parts()) {
            if (!partInstance.isValid() || partInstance.get() != part) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, DataResource<GearPart> part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    private static boolean hasPart(ItemStack gear, String partId) {
        GearConstructionData data = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return false;
        }
        for (PartInstance part : data.parts()) {
            if (!part.getId().toString().equalsIgnoreCase(partId)) continue;
            return true;
        }
        return false;
    }

    public static void addOrReplacePart(ItemStack gear, PartInstance part) {
        PartType partType = part.getType();
        PartList parts = GearData.getConstruction(gear).parts();
        List<PartInstance> partsOfType = parts.getPartsOfType(partType);
        PartInstance removedPart = null;
        if (!partsOfType.isEmpty() && partsOfType.size() >= partType.maxPerItem()) {
            removedPart = partsOfType.getFirst();
            parts.remove(removedPart);
            removedPart.onRemoveFromGear(gear);
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static void addPart(ItemStack gear, PartInstance part) {
        PartList parts = GearData.getConstruction(gear).parts();
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        part.onAddToGear(gear);
    }

    public static boolean removeFirstPartOfType(ItemStack gear, PartType type) {
        PartList parts = GearData.getConstruction(gear).parts();
        ArrayList<PartInstance> partsMutable = new ArrayList<PartInstance>(parts);
        ArrayList<PartInstance> partsOfType = new ArrayList<PartInstance>(parts.getPartsOfType(type));
        if (!partsOfType.isEmpty()) {
            PartInstance removed = (PartInstance)partsOfType.removeFirst();
            partsMutable.remove(removed);
            GearData.writeConstructionParts(gear, partsMutable);
            removed.onRemoveFromGear(gear);
            return true;
        }
        return false;
    }

    public static void writeConstructionParts(ItemStack gear, Collection<PartInstance> parts) {
        if (GearData.checkNonGearItem(gear, "writeConstructionParts")) {
            return;
        }
        GearConstructionData data = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        GearConstructionData newData = new GearConstructionData(PartList.immutable(parts), parts.isEmpty(), data != null ? data.brokenCount() : 0, data != null ? data.repairedCount() : 0);
        gear.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
    }

    public static boolean isExampleGear(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null && data.isExample();
    }

    public static int getBrokenCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null ? data.brokenCount() : 0;
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data != null) {
            GearConstructionData newData = new GearConstructionData(data.parts(), data.isExample(), data.brokenCount() + 1, data.repairedCount());
            stack.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
        }
    }

    public static int getRepairedCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null ? data.repairedCount() : 0;
    }

    public static void incrementRepairedCount(ItemStack stack, int amount) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data != null) {
            GearConstructionData newData = new GearConstructionData(data.parts(), data.isExample(), data.brokenCount(), data.repairedCount() + amount);
            stack.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
        }
    }

    private static boolean checkNonGearItem(ItemStack stack, String methodName) {
        if (GearHelper.isGear(stack)) {
            return false;
        }
        SilentGear.LOGGER.error("Called {} on non-gear item, {}", (Object)methodName, (Object)stack);
        SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
        return true;
    }

    public static void setExampleTag(ItemStack result, boolean value) {
        result.set(SgDataComponents.GEAR_IS_EXAMPLE, (Object)value);
    }

    @Deprecated(forRemoval=true)
    public static String getModelKey(ItemStack stack, int animationFrame) {
        return String.format("%d.%d", stack.getComponents().hashCode(), animationFrame);
    }

    @EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            StackList.from((Container)player.getInventory()).stream().filter(s -> s.getItem() instanceof GearItem).forEach(s -> GearData.recalculateGearData(s, player));
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.getEquippedCurios((LivingEntity)player).forEach(s -> GearData.recalculateGearData(s, player));
            }
        }
    }
}

