/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.PlayerTrigger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwingAnimationType;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GearNamePrefixesEvent;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.HarvestTier;
import net.silentchaos512.gear.api.property.HarvestTierPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgCriteriaTriggers;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.SgSounds;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TimedEvents;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.commons.compress.utils.Lists;

public final class GearHelper {
    private static final Identifier REACH_MODIFIER_ID = SilentGear.getId("reach_modifier");
    private static final Identifier ATTACK_REACH_MODIFIER_ID = SilentGear.getId("attack_reach_modifier");
    private static final float BROKEN_ATTACK_SPEED_CHANGE = 0.7f;
    private static final float BROKEN_DESTROY_SPEED = 0.25f;

    private GearHelper() {
    }

    public static Optional<GearItem> getItem(ItemStack gear) {
        if (gear.getItem() instanceof GearItem) {
            return Optional.of((GearItem)gear.getItem());
        }
        return Optional.empty();
    }

    public static boolean isGear(ItemStack stack) {
        return stack.getItem() instanceof GearItem;
    }

    public static boolean isValidGear(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            return false;
        }
        GearItem item = (GearItem)stack.getItem();
        for (PartType type : item.getRequiredParts()) {
            if (GearData.hasPartOfType(stack, type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAttackingItem(ItemStack gear) {
        GearType type = GearHelper.getType(gear);
        return type.matches((GearType)GearTypes.MELEE_WEAPON.get(), false) || type.matches((GearType)GearTypes.HARVEST_TOOL.get());
    }

    public static void onAddAttackDamageModifier(ItemStack stack, float value, ItemAttributeModifiers.Builder builder) {
        if (!GearHelper.isAttackingItem(stack)) {
            return;
        }
        float adjustedValue = GearHelper.isBroken(stack) ? 1.0f : Math.max(value, 0.0f);
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)adjustedValue, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public static void onAddAttackSpeedModifier(ItemStack stack, float value, ItemAttributeModifiers.Builder builder) {
        if (!GearHelper.isAttackingItem(stack)) {
            return;
        }
        float speed = value - 4.0f;
        if (GearHelper.isBroken(stack)) {
            speed += 0.7f;
        }
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public static void onAddBlockReachModifier(ItemStack stack, float value, ItemAttributeModifiers.Builder builder) {
        builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(REACH_MODIFIER_ID, (double)value, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }

    public static boolean getIsRepairable(ItemStack stack, ItemStack materialItem) {
        MaterialInstance material = MaterialInstance.from(materialItem);
        return material != null && GearHelper.getIsRepairable(stack, material);
    }

    public static boolean getIsRepairable(ItemStack gear, MaterialInstance material) {
        GearConstructionData data = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null && data.getPrimaryPart() != null && material.getRepairValue(gear) > 0 && material.canRepair(gear);
    }

    public static NumberProperty getDurabilityProperty(ItemStack gear) {
        return GearHelper.getItem(gear).map(GearItem::getDurabilityStat).map(Supplier::get).orElse(GearProperties.DURABILITY.get());
    }

    public static float getRepairModifier(ItemStack gear) {
        return GearHelper.getItem(gear).map(item -> Float.valueOf(item.getRepairModifier(gear))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void attemptDamage(ItemStack stack, int amount, LivingEntity entity, InteractionHand hand) {
        GearHelper.attemptDamage(stack, amount, entity, hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
    }

    public static void attemptDamage(ItemStack stack, int amount, LivingEntity entity, EquipmentSlot slot) {
        if (GearHelper.isUnbreakable(stack) || entity instanceof Player && ((Player)entity).getAbilities().instabuild) {
            return;
        }
        ServerPlayer player = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
        int maxDamage = stack.getMaxDamage();
        int previousDamageFactor = GearHelper.getDamageFactor(stack, maxDamage);
        if (!GearHelper.canBreakPermanently(stack)) {
            amount = Math.min(maxDamage - stack.getDamageValue() - 1, amount);
        }
        if (amount < 0) {
            stack.setDamageValue(Math.max(0, stack.getDamageValue() + amount));
        } else {
            stack.hurtAndBreak(amount, entity, slot);
        }
        int currentDamageFactory = GearHelper.getDamageFactor(stack, maxDamage);
        if (currentDamageFactory != previousDamageFactor) {
            GearData.recalculateGearData(stack, (Player)player);
            if (player != null) {
                GearHelper.onDamageFactorChange(player, previousDamageFactor, currentDamageFactory);
            }
        }
        GearHelper.handleBrokenItem(stack, (Player)player, slot);
    }

    private static void handleBrokenItem(ItemStack stack, @Nullable Player player, EquipmentSlot slot) {
        if (GearHelper.isBroken(stack)) {
            GearHelper.onBroken(stack, player, slot);
        } else if (GearHelper.canBreakPermanently(stack) && stack.getDamageValue() > stack.getMaxDamage()) {
            if (player != null) {
                player.onEquippedItemBroken(stack.getItem(), slot);
            }
            stack.shrink(1);
        }
    }

    public static void onBroken(ItemStack stack, @Nullable Player player, EquipmentSlot slot) {
        GearData.incrementBrokenCount(stack);
        GearData.recalculateGearData(stack, player);
        if (player != null) {
            player.onEquippedItemBroken(stack.getItem(), slot);
            GearHelper.notifyPlayerOfBrokenGear(stack, player);
        }
    }

    public static InteractionResult useAndCheckBroken(UseOnContext context, Function<UseOnContext, InteractionResult> useFunction) {
        InteractionResult result = useFunction.apply(context);
        if (context.getPlayer() instanceof ServerPlayer) {
            GearHelper.handleBrokenItem(context.getItemInHand(), context.getPlayer(), context.getHand() == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
        }
        return result;
    }

    private static void onDamageFactorChange(ServerPlayer player, int preDamageFactor, int newDamageFactor) {
        if (newDamageFactor > preDamageFactor) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SgSounds.GEAR_DAMAGED.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            ((PlayerTrigger)SgCriteriaTriggers.DAMAGE_FACTOR_CHANGE.get()).trigger(player);
        }
    }

    private static void notifyPlayerOfBrokenGear(ItemStack stack, Player player) {
        if (((Boolean)Config.Common.sendGearBrokenMessage.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"misc.silentgear.notifyOnBreak", (Object[])new Object[]{stack.getHoverName()}), false);
        }
    }

    private static int getDamageFactor(ItemStack stack, int maxDamage) {
        if (maxDamage == 0) {
            return 1;
        }
        int levels = (Integer)Config.Common.damageFactorLevels.get();
        int step = Math.max(1, maxDamage / (levels < 1 ? 10 : levels));
        return stack.getDamageValue() / step;
    }

    public static int calcDamageClamped(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return 0;
        }
        if (!GearHelper.canBreakPermanently(stack)) {
            damage = damage > stack.getDamageValue() ? Math.min(stack.getMaxDamage(), damage) : Math.max(0, damage);
        }
        return damage;
    }

    private static boolean canBreakPermanently(ItemStack stack) {
        return Config.Common.isLoaded() && (Boolean)Config.Common.gearBreaksPermanently.get() != false || TraitHelper.hasTrait(stack, Const.Traits.RED_CARD);
    }

    public static boolean isBroken(ItemStack stack) {
        if (stack.isEmpty() || GearHelper.canBreakPermanently(stack) || GearHelper.isUnbreakable(stack)) {
            return false;
        }
        int maxDamage = stack.getMaxDamage();
        return maxDamage > 0 && stack.getDamageValue() >= maxDamage - 1;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return TraitHelper.getTraitLevel(stack, Const.Traits.INDESTRUCTIBLE) > 0 || stack.has(DataComponents.UNBREAKABLE);
    }

    public static void setDamage(ItemStack stack, int damage, BiConsumer<ItemStack, Integer> superFunction) {
        boolean alreadyBroken = GearHelper.isBroken(stack);
        int newDamage = GearHelper.calcDamageClamped(stack, damage);
        int diff = newDamage - stack.getDamageValue();
        if (diff > 0 && !GearHelper.isBroken(stack)) {
            GearHelper.damageParts(stack, diff);
        }
        superFunction.accept(stack, newDamage);
        if (!alreadyBroken && GearHelper.isBroken(stack)) {
            GearData.recalculateGearData(stack, null);
        }
    }

    public static <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        int clampedValue;
        boolean gearBreaksPermanently;
        boolean bl = gearBreaksPermanently = Config.Common.isLoaded() && (Boolean)Config.Common.gearBreaksPermanently.get() != false;
        if (GearHelper.isUnbreakable(stack)) {
            clampedValue = 0;
        } else {
            int preTraitValue = amount;
            int postTraitValue = TraitHelper.activateTraits(stack, preTraitValue, (trait, val) -> trait.getTrait().onDurabilityDamage(new TraitActionContext(null, trait, stack), (int)val));
            if (gearBreaksPermanently) {
                clampedValue = postTraitValue;
            } else {
                clampedValue = Math.min(stack.getMaxDamage() - stack.getDamageValue() - 1, postTraitValue);
                if (!GearHelper.isBroken(stack) && stack.getDamageValue() + preTraitValue >= stack.getMaxDamage() - 1) {
                    onBroken.accept(stack.getItem());
                }
            }
        }
        GearHelper.damageParts(stack, clampedValue);
        return clampedValue;
    }

    private static void damageParts(ItemStack stack, int amount) {
        GearConstructionData construction = GearData.getConstruction(stack);
        construction.parts().forEach(part -> {
            if (part.isValid()) {
                part.get().onGearDamaged((PartInstance)part, stack, amount);
            }
        });
    }

    public static Item.Properties getBaseItemProperties() {
        return new Item.Properties().stacksTo(1).durability(100).setNoCombineRepair();
    }

    public static GearType getType(ItemStack gear) {
        return GearHelper.getType(gear, (GearType)GearTypes.NONE.get());
    }

    public static GearType getType(ItemStack gear, GearType defaultType) {
        if (gear.isEmpty() || !(gear.getItem() instanceof GearItem)) {
            return defaultType;
        }
        return ((GearItem)gear.getItem()).getGearType();
    }

    @Deprecated
    public static boolean isEquivalent(ItemStack gear1, ItemStack gear2) {
        if (!GearHelper.isGear(gear1) || !GearHelper.isGear(gear2) || gear1.getItem() != gear2.getItem()) {
            return false;
        }
        GearConstructionData constructionData1 = GearData.getConstruction(gear1);
        GearConstructionData constructionData2 = GearData.getConstruction(gear2);
        return constructionData1.equals(constructionData2);
    }

    public static boolean isCorrectToolForDrops(ItemStack stack, BlockState state, @Nullable TagKey<Block> blocksForTool) {
        if (GearHelper.isBroken(stack)) {
            return false;
        }
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        return tool != null && tool.isCorrectForDrops(state);
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state) {
        if (GearHelper.isBroken(stack)) {
            return 0.25f;
        }
        float speed = GearData.getProperties(stack).getNumber(GearProperties.HARVEST_SPEED);
        if (stack.getItem().isCorrectToolForDrops(stack, state)) {
            return GearHelper.getTraitModifiedMiningSpeed(stack, state, speed);
        }
        return 1.0f;
    }

    private static float getTraitModifiedMiningSpeed(ItemStack stack, BlockState state, float baseSpeed) {
        float totalModifier = 0.0f;
        for (TraitInstance traitInstance : TraitHelper.getTraits(stack)) {
            totalModifier += traitInstance.getTrait().getMiningSpeedModifier(traitInstance.getLevel(), state, baseSpeed);
        }
        return baseSpeed * (1.0f + totalModifier);
    }

    public static void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        boolean isEquipped = slot != null;
        GearHelper.inventoryTick(stack, level, entity, isEquipped);
    }

    public static void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, boolean isEquipped) {
        if (stack.has(SgDataComponents.RECALCULATE_FLAG)) {
            GearData.recalculateGearData(stack, entity instanceof Player ? (Player)entity : null);
            stack.remove(SgDataComponents.RECALCULATE_FLAG);
        }
        TraitHelper.tickTraits((Level)level, entity, stack, isEquipped);
    }

    public static InteractionResult useOn(UseOnContext context) {
        InteractionResult.Pass ret = InteractionResult.PASS;
        for (TraitInstance traitInstance : TraitHelper.getTraits(context.getItemInHand())) {
            InteractionResult result = traitInstance.getTrait().onItemUse(context, traitInstance.getLevel());
            if (result == InteractionResult.PASS) continue;
            ret = result;
        }
        return ret;
    }

    public static void onItemSwing(ItemStack stack, LivingEntity wielder) {
        for (TraitInstance traitInstance : TraitHelper.getTraits(stack)) {
            traitInstance.getTrait().onItemSwing(stack, wielder, traitInstance.getLevel());
        }
    }

    @Nullable
    public static Entity getAttackTargetWithExtraReach(Player player) {
        if (GearHelper.getType(player.getMainHandItem()).matches((GearType)GearTypes.MELEE_WEAPON.get())) {
            return GearHelper.tryAttackWithExtraReach(player, true);
        }
        return null;
    }

    @Nullable
    public static Entity tryAttackWithExtraReach(Player player) {
        return GearHelper.tryAttackWithExtraReach(player, false);
    }

    @Nullable
    private static Entity tryAttackWithExtraReach(Player player, boolean simulate) {
        AABB axisalignedbb;
        double range = GearHelper.getAttackRange((LivingEntity)player);
        Vec3 vector3d = player.getEyePosition(0.0f);
        double rangeSquared = range * range;
        Vec3 vector3d1 = player.getViewVector(1.0f);
        Vec3 vector3d2 = vector3d.add(vector3d1.x * range, vector3d1.y * range, vector3d1.z * range);
        EntityHitResult rayTrace = GearHelper.rayTraceEntities((Entity)player, vector3d, vector3d2, axisalignedbb = player.getBoundingBox().expandTowards(vector3d1.scale(range)).inflate(1.0, 1.0, 1.0), entity -> !entity.isSpectator() && entity.isPickable(), rangeSquared);
        if (rayTrace != null) {
            Entity entity2 = rayTrace.getEntity();
            if (!simulate) {
                player.attack(entity2);
            }
            return entity2;
        }
        return null;
    }

    private static double getAttackRange(LivingEntity entity) {
        ItemStack stack = entity.getMainHandItem();
        double base = GearHelper.getType(stack).matches((GearType)GearTypes.TOOL.get()) ? (double)GearData.getProperties(stack).getNumber(GearProperties.ATTACK_REACH) : (double)((Float)GearProperties.ATTACK_REACH.get().getBaseValue()).floatValue();
        AttributeInstance attribute = entity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        if (attribute != null) {
            double reachBonus = attribute.getValue() - attribute.getBaseValue();
            return base + reachBonus;
        }
        return base;
    }

    @Nullable
    private static EntityHitResult rayTraceEntities(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
        Level world = shooter.level();
        double d0 = distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.getEntities(shooter, boundingBox, filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optional = axisalignedbb.clip(startVec, endVec);
            if (axisalignedbb.contains(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.getRootVehicle() == shooter.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }

    public static Rarity getRarity(ItemStack stack) {
        int rarity = (int)GearData.getProperties(stack).getNumber(GearProperties.RARITY);
        if (stack.isEnchanted()) {
            rarity = ((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue() ? (rarity += 80) : (rarity += 20);
        }
        if (rarity < 40) {
            return Rarity.COMMON;
        }
        if (rarity < 80) {
            return Rarity.UNCOMMON;
        }
        if (rarity < 120) {
            return Rarity.RARE;
        }
        return Rarity.EPIC;
    }

    private static ItemStack createSampleItem(GearItem item, int tier) {
        ItemStack result = GearGenerator.create(item);
        if (result.isEmpty()) {
            ArrayList<PartInstance> parts = new ArrayList<PartInstance>();
            for (PartType partType : item.getRequiredParts()) {
                partType.makeCompoundPart(item.getGearType(), Const.Materials.EXAMPLE).ifPresent(parts::add);
            }
            result = item.construct(parts);
        }
        GearData.setExampleTag(result, true);
        return result;
    }

    private static ItemStack createSampleItem(GearItem item, DataResource<Material> mainMaterial) {
        ArrayList parts = Lists.newArrayList();
        for (PartType partType : item.getRequiredParts()) {
            partType.makeCompoundPart(item.getGearType(), GearHelper.selectMaterialForSample(partType, item.getGearType(), mainMaterial)).ifPresent(parts::add);
        }
        ItemStack result = new ItemStack((ItemLike)item);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateGearData(result, null);
        return result;
    }

    private static DataResource<Material> selectMaterialForSample(PartType partType, GearType gearType, DataResource<Material> main) {
        if (partType == PartTypes.ROD.get()) {
            return Const.Materials.WOOD;
        }
        if (partType == PartTypes.CORD.get()) {
            return Const.Materials.STRING;
        }
        if (partType == PartTypes.FLETCHING.get()) {
            return Const.Materials.FEATHER;
        }
        if (partType == PartTypes.BINDING.get()) {
            return Const.Materials.STRING;
        }
        if (partType == PartTypes.SETTING.get()) {
            return GearHelper.getRandomMaterial(partType, gearType);
        }
        return main;
    }

    private static DataResource<Material> getRandomMaterial(PartType partType, GearType gearType) {
        ArrayList<Material> matsOfTier = new ArrayList<Material>();
        for (Material material : SgRegistries.MATERIAL.getValues(true)) {
            MaterialInstance inst = MaterialInstance.of(material);
            if (!inst.allowedInPart(partType) || !inst.isCraftingAllowed(partType, gearType)) continue;
            matsOfTier.add(inst.get());
        }
        if (!matsOfTier.isEmpty()) {
            Material material = (Material)matsOfTier.get(SilentGear.RANDOM.nextInt(matsOfTier.size()));
            return DataResource.material(SgRegistries.MATERIAL.getKey(material));
        }
        return Const.Materials.EXAMPLE;
    }

    @Nullable
    public static Component getItemName(ItemStack gear, GearConstructionData constructionData) {
        MutableComponent gearName;
        PartInstance part = constructionData.getPrimaryPart();
        if (part == null) {
            return null;
        }
        Component partName = part.getMaterialName(gear);
        if (TimedEvents.isAprilFools()) {
            partName = partName.copy().append((Component)Component.literal((String)" & Knuckles"));
        }
        String prefix = Util.makeDescriptionId((String)"item", (Identifier)NameUtils.fromItem((ItemStack)gear));
        MutableComponent result = gearName = Component.translatable((String)(prefix + ".nameProper"), (Object[])new Object[]{partName});
        Item item = gear.getItem();
        if (item instanceof GearTool) {
            GearTool item2 = (GearTool)item;
            if (item2.requiresPartOfType((PartType)PartTypes.ROD.get()) && GearData.getPartOfType(gear, (PartType)PartTypes.ROD.get()) == null) {
                result = Component.translatable((String)(prefix + ".noRod"), (Object[])new Object[]{gearName});
            } else if (item2.requiresPartOfType((PartType)PartTypes.CORD.get()) && GearData.getPartOfType(gear, (PartType)PartTypes.CORD.get()) == null) {
                result = Component.translatable((String)(prefix + ".unstrung"), (Object[])new Object[]{gearName});
            }
        }
        for (Component t : GearHelper.getNamePrefixes(gear, constructionData.parts())) {
            if (t.getContents() == PlainTextContents.EMPTY) continue;
            result = t.copy().append((Component)TextUtil.misc("space", new Object[0])).append((Component)result);
        }
        return result;
    }

    private static Collection<Component> getNamePrefixes(ItemStack gear, PartList parts) {
        GearNamePrefixesEvent event = new GearNamePrefixesEvent(gear, parts);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getPrefixes();
    }

    public static Collection<PartInstance> getExamplePartsFromRecipe(GearType gearType, Iterable<Ingredient> ingredients) {
        LinkedHashMap map = new LinkedHashMap();
        PartType mainType = (PartType)PartTypes.MAIN.get();
        mainType.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(mainType, p));
        for (Ingredient ingredient : ingredients) {
            ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
            if (!(iCustomIngredient instanceof IGearIngredient)) continue;
            IGearIngredient customGearIngredient = (IGearIngredient)iCustomIngredient;
            PartType type = customGearIngredient.getPartType();
            type.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(type, p));
        }
        return map.values();
    }

    public static Set<ItemAbility> makeItemAbilitySet(ItemAbility ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    public static int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - 13.0f * (float)stack.getDamageValue() / (float)stack.getMaxDamage());
    }

    public static int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)(stack.getMaxDamage() - stack.getDamageValue()) / (float)stack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class Spear {
        public static KineticWeapon createKineticWeapon(ItemStack gear, GearPropertiesData properties) {
            float estimatedTier;
            HarvestTierPropertyValue harvestTier = (HarvestTierPropertyValue)properties.get(GearProperties.HARVEST_TIER);
            float rarity = properties.getNumber(GearProperties.RARITY);
            if (harvestTier != null && ((HarvestTier)harvestTier.value()).levelHint().isPresent()) {
                try {
                    estimatedTier = Float.parseFloat(((HarvestTier)harvestTier.value()).levelHint().get());
                }
                catch (NumberFormatException ex) {
                    estimatedTier = Spear.estimateTierByRarity(rarity);
                }
            } else {
                estimatedTier = Spear.estimateTierByRarity(rarity);
            }
            return new KineticWeapon(10, Spear.delayTicks(estimatedTier), KineticWeapon.Condition.ofAttackerSpeed((int)((int)(Spear.maxDismountDuration(rarity) * 20.0f)), (float)Spear.dismountMinSpeed(estimatedTier)), KineticWeapon.Condition.ofAttackerSpeed((int)((int)(Spear.maxKnockbackDuration(rarity) * 20.0f)), (float)5.1f), KineticWeapon.Condition.ofRelativeSpeed((int)((int)(Spear.maxDamageDuration(estimatedTier) * 20.0f)), (float)4.6f), 0.38f, Spear.damageMultiplier(properties.getNumber(GearProperties.ATTACK_DAMAGE)), Optional.of(estimatedTier < 1.0f ? SoundEvents.SPEAR_WOOD_USE : SoundEvents.SPEAR_USE), Optional.of(estimatedTier < 1.0f ? SoundEvents.SPEAR_WOOD_HIT : SoundEvents.SPEAR_HIT));
        }

        public static SwingAnimation createSwingAnimation(ItemStack gear, GearPropertiesData properties) {
            int duration = Spear.swingDuration(properties.getNumber(GearProperties.RARITY, 0.0f));
            return new SwingAnimation(SwingAnimationType.STAB, duration);
        }

        private static float estimateTierByRarity(float rarity) {
            double result = 0.434248 * Math.pow(rarity, 0.469146);
            return (float)Math.round(2.0 * result) / 2.0f;
        }

        private static int swingDuration(float rarity) {
            double result = 0.631132 + 0.104594 * Math.log(rarity);
            double rounded = (float)Math.round(20.0 * result) / 20.0f;
            return (int)(20.0 * rounded);
        }

        public static int delayTicks(float tier) {
            double result = 0.777915 * Math.pow(0.861644, tier);
            double rounded = (float)Math.round(20.0 * result) / 20.0f;
            return (int)(20.0 * rounded);
        }

        public static float dismountMinSpeed(float tier) {
            double result = tier > 4.0f ? 14.0 * Math.pow(0.84, tier) : -0.166667 * (double)tier * (double)tier * (double)tier + 1.60714 * (double)tier * (double)tier - 5.5119 * (double)tier + 14.01429;
            return (float)Math.round(2.0 * result) / 2.0f;
        }

        public static float damageMultiplier(float attackDamage) {
            float multi = 0.125f * attackDamage + 0.7f;
            return (float)((int)(multi * 100.0f)) / 100.0f;
        }

        public static float maxDismountDuration(float rarity) {
            if (rarity < 1.0f) {
                return 5.0f;
            }
            double result = 4.97761 - 0.543271 * Math.log(rarity);
            return (float)Math.round(4.0 * result) / 4.0f;
        }

        public static float maxKnockbackDuration(float rarity) {
            if (rarity < 1.0f) {
                return 10.0f;
            }
            double result = 10.24271 - 0.949249 * Math.log(rarity);
            return (float)Math.round(4.0 * result) / 4.0f;
        }

        public static float maxDamageDuration(float tier) {
            double result = 15.24935 * Math.pow(0.87033, tier);
            return (float)Math.round(4.0 * result) / 4.0f;
        }
    }
}

