/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.MathUtils;

public interface IAoeTool {
    default public int getAoeRadius(ItemStack stack) {
        return 1 + TraitHelper.getTraitLevel(stack, Const.Traits.WIDEN);
    }

    @Nullable
    public HitResult rayTraceBlocks(Level var1, Player var2);

    default public List<BlockPos> getExtraBlocks(Level world, @Nullable BlockHitResult rt, Player player, ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (player.isCrouching() || rt == null || rt.getBlockPos() == null || rt.getDirection() == null) {
            return positions;
        }
        BlockPos pos = rt.getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (this.isEffectiveOnBlock(stack, state, player)) {
            Direction dir1;
            Direction dir2 = switch (rt.getDirection().getAxis()) {
                case Direction.Axis.Y -> {
                    dir1 = Direction.SOUTH;
                    yield Direction.EAST;
                }
                case Direction.Axis.X -> {
                    dir1 = Direction.UP;
                    yield Direction.SOUTH;
                }
                default -> {
                    dir1 = Direction.UP;
                    yield Direction.EAST;
                }
            };
            int r = this.getAoeRadius(stack);
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    if (i == 0 && j == 0) continue;
                    this.attemptAddExtraBlock(world, state, pos.relative(dir1, i).relative(dir2, j), stack, player, positions);
                }
            }
        }
        return positions;
    }

    default public boolean isEffectiveOnBlock(ItemStack stack, BlockState state, Player player) {
        boolean isCorrectTool = stack.getItem().isCorrectToolForDrops(stack, state);
        return isCorrectTool && stack.getDestroySpeed(state) > 1.0f;
    }

    default public void attemptAddExtraBlock(Level world, BlockState state, BlockPos pos, ItemStack stack, Player player, List<BlockPos> list) {
        BlockState state1 = world.getBlockState(pos);
        if (state1.getDestroySpeed((BlockGetter)world, pos) < 0.0f) {
            return;
        }
        if (!world.isEmptyBlock(pos) && BreakHandler.areBlocksSimilar(state, state1) && this.isEffectiveOnBlock(stack, state1, player)) {
            list.add(pos);
        }
    }

    @EventBusSubscriber
    public static final class BreakHandler {
        private BreakHandler() {
        }

        @SubscribeEvent
        public static void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
            float targetBlockHardness;
            if (event.getPosition().isEmpty()) {
                return;
            }
            Player player = event.getEntity();
            ItemStack tool = player.getMainHandItem();
            Item item = tool.getItem();
            if (!(item instanceof IAoeTool)) {
                return;
            }
            IAoeTool aoeToolItem = (IAoeTool)item;
            BlockState state = event.getState();
            if (!aoeToolItem.isEffectiveOnBlock(tool, state, player)) {
                return;
            }
            Level level = player.level();
            BlockPos pos = (BlockPos)event.getPosition().get();
            HitResult hitResult = aoeToolItem.rayTraceBlocks(level, player);
            if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            List<BlockPos> extraBlocks = aoeToolItem.getExtraBlocks(level, blockHitResult, player, tool);
            if (extraBlocks.isEmpty()) {
                event.setNewSpeed(event.getNewSpeed() * 1.5f);
                return;
            }
            float maxHardness = targetBlockHardness = state.getDestroySpeed((BlockGetter)level, pos);
            for (BlockPos otherPos : extraBlocks) {
                BlockState otherState = level.getBlockState(otherPos);
                float hardness = otherState.getDestroySpeed((BlockGetter)level, otherPos);
                if (!(hardness > maxHardness)) continue;
                maxHardness = hardness;
            }
            if (!MathUtils.floatsEqual((float)targetBlockHardness, (float)maxHardness)) {
                event.setNewSpeed(event.getNewSpeed() * targetBlockHardness / maxHardness);
            }
        }

        @SubscribeEvent
        public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ItemStack tool = player.getMainHandItem();
            Item item = tool.getItem();
            if (!(item instanceof IAoeTool)) {
                return;
            }
            IAoeTool aoeToolItem = (IAoeTool)item;
            Level level = player.level();
            if (level.isClientSide()) {
                return;
            }
            BlockPos pos = event.getPos();
            HitResult hitResult = aoeToolItem.rayTraceBlocks(level, player);
            BlockState stateOriginal = level.getBlockState(pos);
            if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && aoeToolItem.isEffectiveOnBlock(tool, stateOriginal, player)) {
                BlockHitResult brt = (BlockHitResult)hitResult;
                Direction side = brt.getDirection();
                List<BlockPos> extraBlocks = aoeToolItem.getExtraBlocks(level, brt, player, tool);
                for (BlockPos extraPos : extraBlocks) {
                    BlockState extraState = level.getBlockState(extraPos);
                    if (!level.hasChunkAt(extraPos) || !player.mayUseItemAt(extraPos, side, tool) || !extraState.canHarvestBlock((BlockGetter)level, extraPos, player)) continue;
                    Block extraBlock = extraState.getBlock();
                    if (player.getAbilities().instabuild) {
                        if (extraState.onDestroyedByPlayer(level, extraPos, player, tool, true, extraState.getFluidState())) {
                            extraBlock.destroy((LevelAccessor)level, extraPos, extraState);
                        }
                    } else {
                        BlockEntity blockEntity = level.getBlockEntity(extraPos);
                        int xp = extraState.getExpDrop((LevelAccessor)level, extraPos, blockEntity, (Entity)player, tool);
                        tool.getItem().mineBlock(tool, level, extraState, extraPos, (LivingEntity)player);
                        if (extraState.onDestroyedByPlayer(level, extraPos, player, tool, true, extraState.getFluidState())) {
                            extraBlock.destroy((LevelAccessor)level, extraPos, extraState);
                            extraBlock.playerDestroy(level, player, extraPos, extraState, blockEntity, tool);
                            extraBlock.popExperience((ServerLevel)level, extraPos, xp);
                        }
                    }
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
                }
            }
        }

        static boolean areBlocksSimilar(BlockState state1, BlockState state2) {
            int level2;
            MatchMode mode;
            Block block1 = state1.getBlock();
            Block block2 = state2.getBlock();
            boolean isOre1 = BreakHandler.isOre(state1);
            boolean isOre2 = BreakHandler.isOre(state2);
            MatchMode matchMode = mode = isOre1 && isOre2 ? (MatchMode)((Object)Config.Common.matchModeOres.get()) : (MatchMode)((Object)Config.Common.matchModeStandard.get());
            if (mode == MatchMode.LOOSE || block1 == block2) {
                return true;
            }
            if (mode == MatchMode.STRICT || !isOre1 && isOre2) {
                return false;
            }
            int level1 = BreakHandler.guessHarvestLevel(state1);
            return level1 >= (level2 = BreakHandler.guessHarvestLevel(state2)) || level2 == 0;
        }

        private static boolean isOre(BlockState state) {
            return state.is(Tags.Blocks.ORES);
        }

        private static int guessHarvestLevel(BlockState state) {
            if (state.is(Tags.Blocks.NEEDS_NETHERITE_TOOL)) {
                return 4;
            }
            if (state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
                return 3;
            }
            if (state.is(BlockTags.NEEDS_IRON_TOOL)) {
                return 2;
            }
            if (state.is(BlockTags.NEEDS_STONE_TOOL)) {
                return 1;
            }
            return 0;
        }
    }

    public static enum MatchMode {
        LOOSE,
        MODERATE,
        STRICT;

    }
}

