/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientUtils {
    private IngredientUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<ItemStack> getValidItems(Ingredient ingredient) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Holder item : IngredientUtils.getItems(ingredient)) {
            if (item.is(BuiltInRegistries.ITEM.getKey((Object)Items.BARRIER))) continue;
            listBuilder.add((Object)new ItemStack((ItemLike)item.value()));
        }
        return listBuilder.build();
    }

    public static List<ItemStack> getValidItems(Optional<Ingredient> ingredient) {
        return ingredient.map(IngredientUtils::getValidItems).orElseGet(List::of);
    }

    public static HolderSet<Item> getItems(Ingredient ingredient) {
        if (ingredient.isCustom()) {
            return HolderSet.direct(ingredient.items().toList());
        }
        return ingredient.getValues();
    }

    public static List<ItemStack> getItemList(Ingredient ingredient) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Holder item : IngredientUtils.getItems(ingredient)) {
            listBuilder.add((Object)new ItemStack((ItemLike)item.value()));
        }
        return listBuilder.build();
    }

    public static List<ItemStack> getItemList(Optional<Ingredient> ingredient) {
        return ingredient.map(IngredientUtils::getItemList).orElseGet(List::of);
    }
}

