/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.TextUtil;

public final class SynergyUtils {
    private static final double SYNERGY_MULTI = 1.1;
    private static final double MIN_VALUE = 0.1;
    public static final double MAX_VALUE = 2.0;
    public static final double RARITY_WEIGHT = 0.001;
    public static final double NO_SHARED_CATEGORY_PENALTY = 0.2;
    public static final double SHARED_CATEGORY_BONUS = 0.015;

    private SynergyUtils() {
    }

    public static float getSynergy(PartType partType, List<MaterialInstance> materials, Collection<TraitInstance> traits) {
        if (materials.size() < 2) {
            return 1.0f;
        }
        double synergy = SynergyUtils.getBaseSynergy(materials);
        Map<IMaterialCategory, Integer> categoryCounts = SynergyUtils.getCategoryCounts(materials);
        if (!SynergyUtils.hasSharedCategoryOnAllMaterials(categoryCounts, materials.size())) {
            synergy -= 0.2;
        }
        for (int k : categoryCounts.values()) {
            if (k <= 1) continue;
            synergy += 0.015 * (double)k;
        }
        MaterialInstance primary = materials.getFirst();
        double primaryRarity = ((Float)primary.getProperty(partType, GearProperties.RARITY.get())).floatValue();
        double maxRarity = materials.stream().mapToDouble(m -> ((Float)m.getProperty(partType, GearProperties.RARITY.get())).floatValue()).max().orElse(0.0);
        for (MaterialInstance material : SynergyUtils.getUniques(materials)) {
            if (!(maxRarity > 0.0)) continue;
            float rarity = ((Float)material.getProperty(partType, GearProperties.RARITY.get())).floatValue();
            synergy -= 0.001 * Math.abs(primaryRarity - (double)rarity);
        }
        for (TraitInstance trait : traits) {
            synergy = trait.getTrait().onCalculateSynergy(synergy, trait.getLevel());
        }
        return (float)Mth.clamp((double)synergy, (double)0.1, (double)2.0);
    }

    private static Map<IMaterialCategory, Integer> getCategoryCounts(List<MaterialInstance> materials) {
        HashMap<IMaterialCategory, Integer> ret = new HashMap<IMaterialCategory, Integer>();
        for (MaterialInstance mat : materials) {
            for (IMaterialCategory cat : mat.getCategories()) {
                ret.merge(cat, 1, Integer::sum);
            }
        }
        return ret;
    }

    private static boolean hasSharedCategoryOnAllMaterials(Map<IMaterialCategory, Integer> categoryCounts, int materialCount) {
        for (int k : categoryCounts.values()) {
            if (k != materialCount) continue;
            return true;
        }
        return false;
    }

    public static Collection<MaterialInstance> getUniques(Collection<? extends MaterialInstance> materials) {
        LinkedHashMap<Identifier, MaterialInstance> ret = new LinkedHashMap<Identifier, MaterialInstance>();
        for (MaterialInstance materialInstance : materials) {
            ret.put(materialInstance.getId(), materialInstance);
        }
        return ret.values();
    }

    public static Component getDisplayText(float synergy) {
        ChatFormatting color = synergy < 1.0f ? ChatFormatting.RED : (synergy > 1.0f ? ChatFormatting.GREEN : ChatFormatting.WHITE);
        MutableComponent value = Component.literal((String)(Math.round(100.0f * synergy) + "%")).withStyle(color);
        return TextUtil.translate("misc", "synergy", value);
    }

    private static double getBaseSynergy(Collection<? extends MaterialInstance> materials) {
        int x = SynergyUtils.getUniqueCount(materials);
        double a = 1.1;
        return 1.1 * ((double)x / ((double)x + 1.1)) + 0.47619047619047616;
    }

    private static int getUniqueCount(Collection<? extends MaterialInstance> materials) {
        return materials.stream().map(MaterialInstance::getId).collect(Collectors.toSet()).size();
    }
}

