/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    public static <T> T activateTraits(ItemStack gear, T inputValue, TraitFunction<T> action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        TraitListPropertyValue traitListProperty = (TraitListPropertyValue)GearData.getProperties(gear).get(GearProperties.TRAITS.get());
        if (traitListProperty == null) {
            return inputValue;
        }
        List traits = (List)traitListProperty.value();
        T value = inputValue;
        for (TraitInstance trait : traits) {
            value = action.apply(trait, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, DataResource<Trait> trait) {
        if (GearHelper.isGear(gear)) {
            TraitListPropertyValue list = GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
            for (TraitInstance traitInstance : (List)list.value()) {
                if (traitInstance.getTrait() != trait.get()) continue;
                return traitInstance.getLevel();
            }
        }
        return 0;
    }

    public static boolean hasTrait(ItemStack gear, DataResource<Trait> trait) {
        if (GearHelper.isGear(gear)) {
            return TraitHelper.hasTrait(GearData.getProperties(gear), trait);
        }
        return false;
    }

    public static boolean hasTrait(ItemStack gear, Trait trait) {
        if (GearHelper.isGear(gear)) {
            return TraitHelper.hasTrait(GearData.getProperties(gear), trait);
        }
        return false;
    }

    public static boolean hasTrait(GearPropertiesData properties, DataResource<Trait> trait) {
        TraitListPropertyValue list = properties.getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
        for (TraitInstance traitInstance : (List)list.value()) {
            if (traitInstance.getTrait() != trait.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTrait(GearPropertiesData properties, Trait trait) {
        TraitListPropertyValue list = properties.getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
        for (TraitInstance traitInstance : (List)list.value()) {
            if (traitInstance.getTrait() != trait) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTraitEffect(ItemStack gear, TraitEffectType<?> traitEffectType) {
        if (!GearHelper.isGear(gear)) {
            return false;
        }
        List traitList = (List)GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty()).value();
        for (TraitInstance traitInstance : traitList) {
            for (TraitEffect effect : traitInstance.getTrait().getEffects()) {
                if (effect.type() != traitEffectType) continue;
                return true;
            }
        }
        return false;
    }

    public static int getHighestLevelEitherHand(Player player, DataResource<Trait> trait) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return Math.max(TraitHelper.getTraitLevel(main, trait), TraitHelper.getTraitLevel(off, trait));
    }

    public static int getHighestLevelArmor(Player player, DataResource<Trait> trait) {
        int max = 0;
        for (EquipmentSlot equipmentSlot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack stack = player.getItemBySlot(equipmentSlot);
            max = Math.max(max, TraitHelper.getTraitLevel(stack, trait));
        }
        return max;
    }

    public static int getHighestLevelCurio(LivingEntity entity, DataResource<Trait> trait) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getHighestTraitLevel(entity, trait);
        }
        return 0;
    }

    public static int getHighestLevelArmorOrCurio(Player player, DataResource<Trait> trait) {
        return Math.max(TraitHelper.getHighestLevelArmor(player, trait), TraitHelper.getHighestLevelCurio((LivingEntity)player, trait));
    }

    public static boolean hasTraitEitherHand(Player player, DataResource<Trait> trait) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return TraitHelper.hasTrait(main, trait) || TraitHelper.hasTrait(off, trait);
    }

    public static boolean hasTraitArmor(Player player, DataResource<Trait> trait) {
        for (EquipmentSlot equipmentSlot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack stack = player.getItemBySlot(equipmentSlot);
            if (!TraitHelper.hasTrait(stack, trait)) continue;
            return true;
        }
        return false;
    }

    public static List<TraitInstance> getTraits(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return Collections.emptyList();
        }
        GearPropertiesData properties = GearData.getProperties(gear);
        TraitListPropertyValue traitList = (TraitListPropertyValue)properties.get(GearProperties.TRAITS);
        if (traitList != null) {
            return (List)traitList.value();
        }
        return Collections.emptyList();
    }

    public static void addAttributeModifiersFromTraits(ItemStack gear, BiConsumer<Holder<Attribute>, AttributeModifier> adder) {
        ItemAttributeModifiers.Builder traitAttributesBuilder = ItemAttributeModifiers.builder();
        for (TraitInstance trait : TraitHelper.getTraits(gear)) {
            TraitActionContext context = new TraitActionContext(null, trait, gear);
            trait.getTrait().onGetAttributeModifiers(context, traitAttributesBuilder);
        }
        for (ItemAttributeModifiers.Entry modifier : traitAttributesBuilder.build().modifiers()) {
            adder.accept((Holder<Attribute>)modifier.attribute(), modifier.modifier());
        }
    }

    public static void cancelTraits(Map<Trait, Integer> mapToModify, Trait[] keys) {
    }

    static void tickTraits(Level level, Entity entity, ItemStack gear, boolean isEquipped) {
        Player player = entity instanceof Player ? (Player)entity : null;
        TraitListPropertyValue traits = (TraitListPropertyValue)GearData.getProperties(gear, player).get(GearProperties.TRAITS);
        if (traits == null) {
            return;
        }
        for (TraitInstance trait : (List)traits.value()) {
            trait.getTrait().inventoryTick(new TraitActionContext(player, trait, gear), level, entity, isEquipped);
        }
    }
}

