/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;

public record PartGearKey(GearType gearType, PartType partType) {
    private static final Map<Pair<GearType, PartType>, PartGearKey> CACHE = new ConcurrentHashMap<Pair<GearType, PartType>, PartGearKey>();
    public static final Codec<PartGearKey> CODEC = Codec.STRING.comapFlatMap(PartGearKey::tryParseKey, PartGearKey::key).stable();
    public static final PartGearKey ALL_MAIN = PartGearKey.of((GearType)GearTypes.ALL.get(), (PartType)PartTypes.MAIN.get());

    public static PartGearKey of(GearType gearType, PartInstance part) {
        return PartGearKey.of(gearType, part.getType());
    }

    public static PartGearKey of(GearType gearType, PartType partType) {
        return CACHE.computeIfAbsent((Pair<GearType, PartType>)Pair.of((Object)gearType, (Object)partType), pair -> new PartGearKey((GearType)pair.getFirst(), (PartType)pair.getSecond()));
    }

    public static PartGearKey of(Supplier<GearType> gearType, Supplier<PartType> partType) {
        return PartGearKey.of(gearType.get(), partType.get());
    }

    public static PartGearKey ofAll(Supplier<PartType> partType) {
        return PartGearKey.ofAll(partType.get());
    }

    public static PartGearKey ofAll(PartType partType) {
        return PartGearKey.of((GearType)GearTypes.ALL.get(), partType);
    }

    public static PartGearKey ofMain(Supplier<GearType> gearType) {
        return PartGearKey.ofMain(gearType.get());
    }

    public static PartGearKey ofMain(GearType gearType) {
        return PartGearKey.of(gearType, (PartType)PartTypes.MAIN.get());
    }

    @Nullable
    public PartGearKey getParent() {
        Supplier<GearType> parent = this.gearType.parent();
        if (parent != null) {
            return PartGearKey.of(parent.get(), this.partType);
        }
        return null;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public Component getDisplayName() {
        return this.partType.getDisplayName().append(" / ").append(this.gearType.getDisplayName());
    }

    private static DataResult<PartGearKey> tryParseKey(String str) {
        String[] split = str.split("/");
        if (split.length != 2) {
            return DataResult.error(() -> "Invalid key: " + str);
        }
        ResourceLocation partTypeId = SilentGear.getIdWithDefaultNamespace(split[0]);
        ResourceLocation gearTypeId = SilentGear.getIdWithDefaultNamespace(split[1]);
        GearType gearType = (GearType)SgRegistries.GEAR_TYPE.get(gearTypeId);
        if (gearType == null || gearType == GearTypes.NONE.get()) {
            return DataResult.error(() -> "Unknown gear type: " + String.valueOf(gearTypeId));
        }
        PartType partType = (PartType)SgRegistries.PART_TYPE.get(partTypeId);
        if (partType == null || partType == PartTypes.NONE.get()) {
            return DataResult.error(() -> "Unknown part type: " + String.valueOf(partTypeId));
        }
        return DataResult.success((Object)PartGearKey.of(gearType, partType));
    }

    private String key() {
        String partTypeShortStr = SilentGear.shortenId(SgRegistries.PART_TYPE.getKey((Object)this.partType()));
        String gearTypeShortStr = SilentGear.shortenId(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType()));
        return partTypeShortStr + "/" + gearTypeShortStr;
    }
}

