/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.GuideBookItem;
import net.silentchaos512.gear.item.JewelerKitItem;
import net.silentchaos512.gear.item.ModKitItem;
import net.silentchaos512.gear.item.ProcessedMaterialItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.item.SeedItem;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.lib.util.TimeUtils;

public final class SgItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"silentgear");
    public static final DeferredItem<GuideBookItem> GUIDE_BOOK = SgItems.register("guide_book", () -> new GuideBookItem(SgItems.unstackableProps()));
    public static final DeferredItem<BlueprintPackageItem> BLUEPRINT_PACKAGE = SgItems.register("blueprint_package", () -> new BlueprintPackageItem(SilentGear.getId("starter_blueprints")));
    public static final DeferredItem<Item> MOD_KIT = SgItems.register("mod_kit", () -> new ModKitItem(SgItems.unstackableProps().rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> VERY_CRUDE_REPAIR_KIT = SgItems.register("very_crude_repair_kit", () -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitVeryCrudeCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitVeryCrudeEfficiency).get(), SgItems.unstackableProps().rarity(Rarity.COMMON)));
    public static final DeferredItem<Item> CRUDE_REPAIR_KIT = SgItems.register("crude_repair_kit", () -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitCrudeCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitCrudeEfficiency).get(), SgItems.unstackableProps().rarity(Rarity.COMMON)));
    public static final DeferredItem<Item> STURDY_REPAIR_KIT = SgItems.register("sturdy_repair_kit", () -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitSturdyCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitSturdyEfficiency).get(), SgItems.unstackableProps().rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> CRIMSON_REPAIR_KIT = SgItems.register("crimson_repair_kit", () -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitCrimsonCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitCrimsonEfficiency).get(), SgItems.unstackableProps().rarity(Rarity.RARE)));
    public static final DeferredItem<Item> AZURE_REPAIR_KIT = SgItems.register("azure_repair_kit", () -> new RepairKitItem(() -> ((ModConfigSpec.IntValue)Config.Common.repairKitAzureCapacity).get(), () -> ((ModConfigSpec.DoubleValue)Config.Common.repairKitAzureEfficiency).get(), SgItems.unstackableProps().rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> COATING_SMITHING_TEMPLATE = SgItems.register("coating_smithing_template", () -> new Item(SgItems.baseProps()));
    public static final DeferredItem<Item> CRUDE_KNIFE = SgItems.register("crude_knife", () -> new Item(SgItems.baseProps().durability(32)));
    public static final DeferredItem<Item> CRUDE_HAMMER = SgItems.register("crude_hammer", () -> new Item(SgItems.baseProps().durability(32)));
    public static final DeferredItem<BlueprintBookItem> BLUEPRINT_BOOK = SgItems.register("blueprint_book", () -> new BlueprintBookItem(SgItems.unstackableProps().rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<PartBlueprintItem> JEWELER_TOOLS = SgItems.register("jeweler_tools", () -> new JewelerKitItem((Supplier<PartType>)PartTypes.SETTING, BlueprintType.BLUEPRINT, SgItems.unstackableProps()));
    public static final DeferredItem<PartBlueprintItem> ROD_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.ROD, false);
    public static final DeferredItem<PartBlueprintItem> TIP_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.TIP, false);
    public static final DeferredItem<PartBlueprintItem> COATING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.COATING, false);
    public static final DeferredItem<PartBlueprintItem> GRIP_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.GRIP, false);
    public static final DeferredItem<PartBlueprintItem> BINDING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.BINDING, false);
    public static final DeferredItem<PartBlueprintItem> LINING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.LINING, false);
    public static final DeferredItem<PartBlueprintItem> CORD_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.CORD, false);
    public static final DeferredItem<PartBlueprintItem> FLETCHING_BLUEPRINT = SgItems.registerPartBlueprint(PartTypes.FLETCHING, false);
    public static final DeferredItem<PartBlueprintItem> ROD_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> TIP_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> COATING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> GRIP_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> BINDING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> LINING_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> CORD_TEMPLATE;
    public static final DeferredItem<PartBlueprintItem> FLETCHING_TEMPLATE;
    public static final DeferredItem<CompoundPartItem> ROD;
    public static final DeferredItem<CompoundPartItem> TIP;
    public static final DeferredItem<CompoundPartItem> COATING;
    public static final DeferredItem<CompoundPartItem> GRIP;
    public static final DeferredItem<CompoundPartItem> BINDING;
    public static final DeferredItem<CompoundPartItem> LINING;
    public static final DeferredItem<CompoundPartItem> CORD;
    public static final DeferredItem<CompoundPartItem> FLETCHING;
    public static final DeferredItem<CompoundPartItem> SETTING;
    public static final DeferredItem<CompoundMaterialItem> ALLOY_INGOT;
    public static final DeferredItem<CompoundMaterialItem> CRUDE_ALLOY;
    public static final DeferredItem<CompoundMaterialItem> HYBRID_GEM;
    public static final DeferredItem<CompoundMaterialItem> MIXED_FABRIC;
    public static final DeferredItem<CompoundMaterialItem> SUPER_ALLOY;
    public static final DeferredItem<CustomMaterialItem> CUSTOM_INGOT;
    public static final DeferredItem<CustomMaterialItem> CUSTOM_GEM;
    public static final DeferredItem<ProcessedMaterialItem> SHEET_METAL;
    public static final DeferredItem<SlingshotAmmoItem> PEBBLE;
    public static final DeferredItem<ItemNameBlockItem> FLAX_SEEDS;
    public static final DeferredItem<ItemNameBlockItem> FLUFFY_SEEDS;
    public static final DeferredItem<Item> NETHER_BANANA;
    public static final DeferredItem<Item> GOLDEN_NETHER_BANANA;
    public static final DeferredItem<Item> NETHERWOOD_CHARCOAL;

    private SgItems() {
    }

    private static Item.Properties baseProps() {
        return new Item.Properties();
    }

    public static Item.Properties unstackableProps() {
        return SgItems.baseProps().stacksTo(1);
    }

    private static <T extends Item> DeferredItem<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    private static <T extends CompoundPartItem> DeferredItem<T> registerCompoundPart(String name, Supplier<T> item) {
        return SgItems.register(name, item);
    }

    @Deprecated
    private static DeferredItem<PartBlueprintItem> registerPartBlueprint(DeferredHolder<PartType, PartType> partType, boolean singleUse) {
        String name = partType.getId().getPath() + "_" + (singleUse ? "template" : "blueprint");
        return SgItems.register(name, () -> new PartBlueprintItem((Supplier<PartType>)partType, singleUse ? BlueprintType.TEMPLATE : BlueprintType.BLUEPRINT, SgItems.baseProps()));
    }

    public static <T> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).filter(clazz::isInstance).map(item -> item).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(DeferredHolder::get).filter(predicate).collect(Collectors.toList());
    }

    static {
        GearItemSets.registerBlueprintItems();
        ROD_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.ROD, true);
        TIP_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.TIP, true);
        COATING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.COATING, true);
        GRIP_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.GRIP, true);
        BINDING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.BINDING, true);
        LINING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.LINING, true);
        CORD_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.CORD, true);
        FLETCHING_TEMPLATE = SgItems.registerPartBlueprint(PartTypes.FLETCHING, true);
        GearItemSets.registerTemplateItems();
        GearItemSets.registerMainPartItems();
        ROD = SgItems.registerCompoundPart("rod", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.ROD, SgItems.baseProps()));
        TIP = SgItems.registerCompoundPart("tip", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.TIP, SgItems.baseProps()));
        COATING = SgItems.registerCompoundPart("coating", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.COATING, SgItems.baseProps()));
        GRIP = SgItems.registerCompoundPart("grip", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.GRIP, SgItems.baseProps()));
        BINDING = SgItems.registerCompoundPart("binding", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.BINDING, SgItems.baseProps()));
        LINING = SgItems.registerCompoundPart("lining", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.LINING, SgItems.baseProps()));
        CORD = SgItems.registerCompoundPart("cord", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.CORD, SgItems.baseProps()));
        FLETCHING = SgItems.registerCompoundPart("fletching", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.FLETCHING, SgItems.baseProps()));
        SETTING = SgItems.registerCompoundPart("setting", () -> new CompoundPartItem((Supplier<PartType>)PartTypes.SETTING, SgItems.baseProps()));
        ALLOY_INGOT = SgItems.register("alloy_ingot", () -> new CompoundMaterialItem(SgItems.baseProps()));
        CRUDE_ALLOY = SgItems.register("crude_alloy", () -> new CompoundMaterialItem(SgItems.baseProps()));
        HYBRID_GEM = SgItems.register("hybrid_gem", () -> new CompoundMaterialItem(SgItems.baseProps()));
        MIXED_FABRIC = SgItems.register("mixed_fabric", () -> new CompoundMaterialItem(SgItems.baseProps()));
        SUPER_ALLOY = SgItems.register("super_alloy", () -> new CompoundMaterialItem(SgItems.baseProps()));
        CUSTOM_INGOT = SgItems.register("custom_ingot", () -> new CustomMaterialItem(SgItems.baseProps()));
        CUSTOM_GEM = SgItems.register("custom_gem", () -> new CustomMaterialItem(SgItems.baseProps()));
        SHEET_METAL = SgItems.register("sheet_metal", () -> new ProcessedMaterialItem(SgItems.baseProps()));
        CraftingItems.register(ITEMS);
        PEBBLE = SgItems.register("pebble", () -> new SlingshotAmmoItem(SgItems.baseProps()));
        FLAX_SEEDS = SgItems.register("flax_seeds", () -> new SeedItem((Block)SgBlocks.FLAX_PLANT.get(), SgItems.baseProps()));
        FLUFFY_SEEDS = SgItems.register("fluffy_seeds", () -> new SeedItem((Block)SgBlocks.FLUFFY_PLANT.get(), SgItems.baseProps()));
        NETHER_BANANA = SgItems.register("nether_banana", () -> new Item(SgItems.baseProps().food(new FoodProperties.Builder().nutrition(5).saturationModifier(0.4f).build())));
        GOLDEN_NETHER_BANANA = SgItems.register("golden_nether_banana", () -> new Item(SgItems.baseProps().food(new FoodProperties.Builder().nutrition(10).saturationModifier(1.0f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, TimeUtils.ticksFromMinutes((float)10.0f)), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, TimeUtils.ticksFromMinutes((float)5.0f)), 1.0f).effect(() -> new MobEffectInstance(MobEffects.REGENERATION, TimeUtils.ticksFromSeconds((float)10.0f)), 1.0f).build())));
        NETHERWOOD_CHARCOAL = SgItems.register("netherwood_charcoal", () -> new Item(SgItems.baseProps()));
        GearItemSets.registerGearItems();
    }
}

