/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;

public final class StatGearKey {
    private static final Map<Pair<IItemStat, GearType>, StatGearKey> CACHE = new ConcurrentHashMap<Pair<IItemStat, GearType>, StatGearKey>();
    private final String key;
    private final IItemStat stat;
    private final GearType gearType;

    private StatGearKey(IItemStat stat, GearType gearType) {
        this.stat = stat;
        this.gearType = gearType;
        this.key = gearType != GearType.ALL ? SilentGear.shortenId(stat.getStatId()) + "/" + gearType.getName() : SilentGear.shortenId(stat.getStatId());
    }

    public static StatGearKey of(IItemStat stat, GearType gearType) {
        return CACHE.computeIfAbsent((Pair<IItemStat, GearType>)Pair.of((Object)stat, (Object)gearType), pair -> new StatGearKey((IItemStat)pair.getFirst(), (GearType)pair.getSecond()));
    }

    @Nullable
    public StatGearKey getParent() {
        GearType parent = this.gearType.getParent();
        if (parent != null) {
            return StatGearKey.of(this.stat, parent);
        }
        return null;
    }

    public IItemStat getStat() {
        return this.stat;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    @Nullable
    public static StatGearKey read(String key) {
        GearType gearType;
        String[] parts = key.split("/");
        if (parts.length > 2) {
            throw new JsonParseException("invalid key: " + key);
        }
        ItemStat stat = ItemStats.byName(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace(parts[0])));
        if (stat == null) {
            return null;
        }
        if (parts.length > 1) {
            gearType = GearType.get(parts[1]);
            if (gearType.isInvalid()) {
                throw new JsonParseException("Unknown gear type: " + parts[1]);
            }
        } else {
            gearType = GearType.ALL;
        }
        return new StatGearKey(stat, gearType);
    }

    @Nullable
    public static StatGearKey read(FriendlyByteBuf buffer) {
        return StatGearKey.read(buffer.m_130277_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.key);
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatGearKey that = (StatGearKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

