/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;

public final class SetDamageCommand {
    private SetDamageCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set_damage").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SetDamageCommand.run((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))).then(Commands.m_82127_((String)"max").executes(context -> SetDamageCommand.run((CommandContext<CommandSourceStack>)context, -1))));
    }

    private static int run(CommandContext<CommandSourceStack> context, int amount) throws CommandSyntaxException {
        ServerPlayer playerMP = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack stack = playerMP.m_21205_();
        if (stack.m_41763_()) {
            int correctedAmount = amount < 0 ? SetDamageCommand.getMaxDamage(stack) : amount;
            int clamped = Mth.m_14045_((int)correctedAmount, (int)0, (int)SetDamageCommand.getMaxDamage(stack));
            stack.m_41721_(clamped);
            if (stack.m_41720_() instanceof ICoreItem) {
                GearData.recalculateStats(stack, (Player)playerMP);
            }
            return 1;
        }
        MutableComponent msg = TextUtil.translate("command", "set_damage.notDamageable", stack.m_41786_());
        ((CommandSourceStack)context.getSource()).m_81352_((Component)msg);
        return 0;
    }

    private static int getMaxDamage(ItemStack stack) {
        if (GearHelper.isGear(stack)) {
            return stack.m_41776_() - 1;
        }
        return stack.m_41776_();
    }
}

