/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.util.TextUtil;

public class SalvagingRecipeCategoryJei
implements IRecipeCategory<SalvagingRecipe> {
    private static final int GUI_START_X = 9;
    private static final int GUI_START_Y = 17;
    private static final int GUI_WIDTH = 105;
    private static final int GUI_HEIGHT = 52;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public SalvagingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SalvagerScreen.TEXTURE, 9, 17, 105, 52);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(SgBlocks.SALVAGER));
        this.arrow = guiHelper.drawableBuilder(SalvagerScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.salvaging");
    }

    public RecipeType<SalvagingRecipe> getRecipeType() {
        return SGearJeiPlugin.SALVAGING_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SalvagingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, -1, 17).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getIngredient().m_43908_()));
        List<ItemStack> results = recipe.getPossibleResults((Container)new SimpleContainer(1));
        for (int i = 0; i < 9 && i < results.size(); ++i) {
            int x = 18 * (i % 3) + 61 - 9;
            int y = 18 * (i / 3) + 16 - 17;
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(results.get(i)));
        }
    }

    public void draw(SalvagingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 23, 17);
    }
}

