/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.lib.util.NameUtils;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "silentgear", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Silent Gear - Item Models";
    }

    protected void registerModels() {
        SgBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(this::blockItemModel);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(new ResourceLocation("item/handheld"));
        for (CraftingItems item : CraftingItems.values()) {
            this.builder(item, (ModelFile)itemGenerated, "item/" + item.getName());
        }
        this.builder((ItemLike)SgItems.NETHERWOOD_CHARCOAL, (ModelFile)itemGenerated);
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.SHEET_METAL).parent((ModelFile)itemGenerated)).texture("layer0", "item/sheet_metal")).texture("layer1", "item/sheet_metal_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.ALLOY_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.HYBRID_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        this.builder((ItemLike)SgItems.MIXED_FABRIC, (ModelFile)itemGenerated, "item/mixed_fabric");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.CUSTOM_INGOT).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.CUSTOM_GEM).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)SgItems.BLUEPRINT_BOOK).parent((ModelFile)itemGenerated)).texture("layer0", "item/blueprint_book_cover")).texture("layer1", "item/blueprint_book_pages")).texture("layer2", "item/blueprint_book_deco");
        ((ItemModelBuilder)this.builder((ItemLike)SgItems.FRAGMENT).parent((ModelFile)itemGenerated)).texture("layer0", "item/fragment/metal");
        this.builder((ItemLike)SgItems.JEWELER_TOOLS, (ModelFile)itemGenerated, "item/jeweler_tools");
        SgItems.getItems(PartBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        SgItems.getItems(GearBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        this.builder((ItemLike)SgItems.MOD_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.VERY_CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.STURDY_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.CRIMSON_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.AZURE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.COATING_SMITHING_TEMPLATE, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.GUIDE_BOOK, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.BLUEPRINT_PACKAGE, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.FLAX_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.FLUFFY_SEEDS, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.GOLDEN_NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((ItemLike)SgItems.PEBBLE, (ModelFile)itemGenerated);
        this.tempGearStandardTool(SgItems.SWORD, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.KATANA, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.MACHETE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.SPEAR, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.TRIDENT, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.KNIFE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.DAGGER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.PICKAXE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.SHOVEL, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.AXE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.PAXEL, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.HAMMER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.EXCAVATOR, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.SAW, (ModelFile)this.getExistingFile(this.modLoc("item/saw_base")));
        this.tempGearStandardTool(SgItems.PROSPECTOR_HAMMER, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.HOE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.MATTOCK, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.SICKLE, (ModelFile)itemHandheld);
        this.tempGearStandardTool(SgItems.SHEARS, (ModelFile)itemHandheld);
        this.tempGearBow(SgItems.FISHING_ROD, (ModelFile)itemHandheld);
        this.tempGearArrow(SgItems.ARROW, (ModelFile)itemGenerated);
        this.tempGearArmor(SgItems.HELMET, (ModelFile)itemGenerated);
        this.tempGearArmor(SgItems.CHESTPLATE, (ModelFile)itemGenerated);
        this.tempGearArmor(SgItems.LEGGINGS, (ModelFile)itemGenerated);
        this.tempGearArmor(SgItems.BOOTS, (ModelFile)itemGenerated);
        this.tempGearElytra(SgItems.ELYTRA, (ModelFile)itemGenerated);
        this.tempGearCurio(SgItems.RING, (ModelFile)itemGenerated);
        this.tempGearCurio(SgItems.BRACELET, (ModelFile)itemGenerated);
        this.tempMainPart(SgItems.SWORD_BLADE);
        this.tempMainPart(SgItems.KATANA_BLADE);
        this.tempMainPart(SgItems.MACHETE_BLADE);
        this.tempMainPart(SgItems.SPEAR_TIP);
        this.tempMainPart(SgItems.TRIDENT_PRONGS);
        this.tempMainPart(SgItems.KNIFE_BLADE);
        this.tempMainPart(SgItems.DAGGER_BLADE);
        this.tempMainPart(SgItems.PICKAXE_HEAD);
        this.tempMainPart(SgItems.SHOVEL_HEAD);
        this.tempMainPart(SgItems.AXE_HEAD);
        this.tempMainPart(SgItems.PAXEL_HEAD);
        this.tempMainPart(SgItems.HAMMER_HEAD);
        this.tempMainPart(SgItems.EXCAVATOR_HEAD);
        this.tempMainPart(SgItems.SAW_BLADE);
        this.tempMainPart(SgItems.HOE_HEAD);
        this.tempMainPart(SgItems.MATTOCK_HEAD);
        this.tempMainPart(SgItems.PROSPECTOR_HAMMER_HEAD);
        this.tempMainPart(SgItems.SICKLE_BLADE);
        this.tempMainPart(SgItems.SHEARS_BLADES);
        this.tempMainPart(SgItems.FISHING_REEL_AND_HOOK);
        this.tempMainPart(SgItems.BOW_LIMBS);
        this.tempMainPart(SgItems.CROSSBOW_LIMBS);
        this.tempMainPart(SgItems.SLINGSHOT_LIMBS);
        this.tempMainPart(SgItems.SHIELD_PLATE);
        this.tempMainPart(SgItems.HELMET_PLATES);
        this.tempMainPart(SgItems.CHESTPLATE_PLATES);
        this.tempMainPart(SgItems.LEGGING_PLATES);
        this.tempMainPart(SgItems.BOOT_PLATES);
        this.tempMainPart(SgItems.ELYTRA_WINGS);
        this.tempMainPart(SgItems.ARROW_HEADS);
        this.tempMainPart(SgItems.RING_SHANK);
        this.tempMainPart(SgItems.BRACELET_BAND);
        this.tempGearPart(SgItems.ROD);
        this.tempGearPart(SgItems.TIP);
        this.tempCoatingPart(SgItems.COATING);
        this.tempGearPart(SgItems.GRIP);
        this.tempGearPart(SgItems.BINDING);
        this.tempGearPart(SgItems.LINING, "item/part/lining_cloth");
        this.tempGearPart(SgItems.CORD);
        this.tempGearPart(SgItems.FLETCHING);
        this.tempGearPart(SgItems.ADORNMENT);
    }

    private ItemModelBuilder tempGearStandardTool(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        String path = item.getId().m_135815_();
        ModelFile.UncheckedModelFile mainModelFile = new ModelFile.UncheckedModelFile(this.modLoc("item/" + path));
        ItemModelBuilder model_lc = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc");
        ItemModelBuilder model_hc = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight");
        ItemModelBuilder model_lc_tip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_tip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/" + name + "/tip_sharp");
        ItemModelBuilder model_hc_tip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_tip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/tip_sharp");
        ItemModelBuilder model_lc_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/blank")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_hc_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/blank")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_lc_tip_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_lc_tip_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc")).texture("layer2", "item/blank")).texture("layer3", "item/" + name + "/tip_sharp")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder model_hc_tip_grip = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path + "_hc_tip_grip")).parent((ModelFile)mainModelFile)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/tip_sharp")).texture("layer4", "item/" + name + "/grip_wool");
        ItemModelBuilder mainBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent(parent)).override().predicate((ResourceLocation)Const.MODEL, 2.0f).model((ModelFile)model_lc).end().override().predicate((ResourceLocation)Const.MODEL, 3.0f).model((ModelFile)model_hc).end().override().predicate((ResourceLocation)Const.MODEL, 6.0f).model((ModelFile)model_lc_tip).end().override().predicate((ResourceLocation)Const.MODEL, 7.0f).model((ModelFile)model_hc_tip).end().override().predicate((ResourceLocation)Const.MODEL, 10.0f).model((ModelFile)model_lc_grip).end().override().predicate((ResourceLocation)Const.MODEL, 11.0f).model((ModelFile)model_hc_grip).end().override().predicate((ResourceLocation)Const.MODEL, 14.0f).model((ModelFile)model_lc_tip_grip).end().override().predicate((ResourceLocation)Const.MODEL, 15.0f).model((ModelFile)model_hc_tip_grip).end().texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_lc");
        return mainBuilder;
    }

    private ItemModelBuilder tempGear(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight");
    }

    private ItemModelBuilder tempGearBow(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/bowstring_string");
    }

    private ItemModelBuilder tempGearCurio(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/" + name + "/adornment_generic")).texture("layer3", "item/" + name + "/adornment_highlight");
    }

    private ItemModelBuilder tempGearArmor(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight");
    }

    private ItemModelBuilder tempGearElytra(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/" + name + "/binding_generic");
    }

    private ItemModelBuilder tempGearArrow(ItemRegistryObject<? extends ICoreItem> item, ModelFile parent) {
        String name = ((ICoreItem)((Item)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent(parent)).texture("layer0", "item/" + name + "/rod_generic_lc")).texture("layer1", "item/" + name + "/main_generic_hc")).texture("layer2", "item/" + name + "/_highlight")).texture("layer3", "item/" + name + "/fletching_generic");
    }

    private ItemModelBuilder tempMainPart(ItemRegistryObject<MainPartItem> item) {
        String name = ((MainPartItem)((Object)item.get())).getGearType().getName();
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", "item/" + name + "/main_generic_hc")).texture("layer1", "item/" + name + "/_highlight")).texture("layer2", "item/part_marker");
    }

    private ItemModelBuilder tempGearPart(ItemRegistryObject<CompoundPartItem> item) {
        String name = ((CompoundPartItem)((Object)item.get())).getPartType().getName().m_135815_();
        return this.tempGearPart(item, "item/part/" + name);
    }

    private ItemModelBuilder tempGearPart(ItemRegistryObject<CompoundPartItem> item, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", texture)).texture("layer1", "item/part_marker");
    }

    private ItemModelBuilder tempCoatingPart(ItemRegistryObject<CompoundPartItem> item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getId().m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", "item/part/coating_material")).texture("layer1", "item/part/coating_jar")).texture("layer2", "item/part_marker");
    }

    private void blockItemModel(Block block) {
        if (block == SgBlocks.FLAX_PLANT.get() || block == SgBlocks.FLUFFY_PLANT.get()) {
            return;
        }
        if (block == SgBlocks.PHANTOM_LIGHT.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/phantom_light");
        } else if (block == SgBlocks.NETHERWOOD_SAPLING.get() || block == SgBlocks.STONE_TORCH.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "block/" + NameUtils.fromBlock((Block)block).m_135815_());
        } else if (block == SgBlocks.NETHERWOOD_FENCE.get()) {
            this.withExistingParent("netherwood_fence", this.modLoc("block/netherwood_fence_inventory"));
        } else if (block == SgBlocks.NETHERWOOD_DOOR.get()) {
            this.builder((ItemLike)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/netherwood_door");
        } else if (block == SgBlocks.NETHERWOOD_TRAPDOOR.get()) {
            this.withExistingParent("netherwood_trapdoor", this.modLoc("block/netherwood_trapdoor_bottom"));
        } else if (block.m_5456_() != Items.f_41852_) {
            String name = NameUtils.fromBlock((Block)block).m_135815_();
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private ItemModelBuilder builder(ItemLike item) {
        return (ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_());
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent) {
        String name = NameUtils.fromItem((ItemLike)item).m_135815_();
        return this.builder(item, parent, "item/" + name);
    }

    private ItemModelBuilder builder(ItemLike item, ModelFile parent, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).m_135815_())).parent(parent)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, GearBlueprintItem item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getGearType().getName());
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, PartBlueprintItem item) {
        if (item.hasStandardModel()) {
            ((ItemModelBuilder)((ItemModelBuilder)this.builder((ItemLike)item).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getPartType().getName().m_135815_());
        }
    }
}

