/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.loot.condition.HasTraitCondition;
import net.silentchaos512.gear.loot.function.SelectGearTierLootFunction;
import net.silentchaos512.gear.loot.function.SetPartsFunction;
import net.silentchaos512.gear.loot.modifier.BonusDropsTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.MagmaticTraitLootModifier;
import net.silentchaos512.gear.util.ModResourceLocation;

public final class SgLoot {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"silentgear");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"silentgear");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"silentgear");
    public static final RegistryObject<LootItemConditionType> HAS_TRAIT = SgLoot.registerCondition("has_trait", () -> new LootItemConditionType((Serializer)HasTraitCondition.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SELECT_TIER = SgLoot.registerFunction("select_tier", () -> new LootItemFunctionType((Serializer)SelectGearTierLootFunction.SERIALIZER));
    public static final RegistryObject<LootItemFunctionType> SET_PARTS = SgLoot.registerFunction("set_parts", () -> new LootItemFunctionType((Serializer)SetPartsFunction.SERIALIZER));
    public static final RegistryObject<Codec<BonusDropsTraitLootModifier>> BONUS_DROPS_TRAIT = SgLoot.registerModifier("bonus_drops_trait", BonusDropsTraitLootModifier.CODEC);
    public static final RegistryObject<Codec<MagmaticTraitLootModifier>> MAGMATIC_SMELTING = SgLoot.registerModifier("magmatic_smelting", MagmaticTraitLootModifier.CODEC);

    private SgLoot() {
    }

    private static <T extends LootItemConditionType> RegistryObject<T> registerCondition(String name, Supplier<T> condition) {
        return LOOT_CONDITIONS.register(name, condition);
    }

    private static <T extends LootItemFunctionType> RegistryObject<T> registerFunction(String name, Supplier<T> condition) {
        return LOOT_FUNCTIONS.register(name, condition);
    }

    private static <T extends IGlobalLootModifier> RegistryObject<Codec<T>> registerModifier(String name, Supplier<Codec<T>> codec) {
        return LOOT_MODIFIERS.register(name, codec);
    }

    @Mod.EventBusSubscriber
    public static final class Injector {
        private Injector() {
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            Tables.get(event.getName()).ifPresent(injectorName -> {
                SilentGear.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
                event.getTable().addPool(LootPool.m_79043_().name("silentgear_injected").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)injectorName)).m_79082_());
            });
        }

        public static final class Tables {
            private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
            public static final ResourceLocation NETHER_BRIDGE = Tables.inject(BuiltInLootTables.f_78760_);
            public static final ResourceLocation BASTION_TREASURE = Tables.inject(BuiltInLootTables.f_78697_);
            public static final ResourceLocation BASTION_OTHER = Tables.inject(BuiltInLootTables.f_78698_);
            public static final ResourceLocation BASTION_BRIDGE = Tables.inject(BuiltInLootTables.f_78699_);
            public static final ResourceLocation RUINED_PORTAL = Tables.inject(BuiltInLootTables.f_78701_);
            public static final ResourceLocation CAVE_SPIDER = Tables.inject(EntityType.f_20554_.m_20677_());
            public static final ResourceLocation SPIDER = Tables.inject(EntityType.f_20479_.m_20677_());
            public static final ResourceLocation ZOMBIE_VILLAGER = Tables.inject(EntityType.f_20530_.m_20677_());

            public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
                return Optional.ofNullable(MAP.get(lootTable));
            }

            private static ResourceLocation inject(ResourceLocation lootTable) {
                ModResourceLocation ret = SilentGear.getId("inject/" + lootTable.m_135827_() + "/" + lootTable.m_135815_());
                MAP.put(lootTable, ret);
                return ret;
            }
        }
    }
}

