/*
 * Decompiled with CFR 0.152.
 */
package dev.rosenoire.legion.client.tooltip;

import dev.rosenoire.legion.client.tooltip.ArmorTooltipData;
import dev.rosenoire.legion.client.tooltip.ArmorTooltipPreviewHandler;
import java.util.ArrayList;
import java.util.List;
import net.collectively.geode.helpers.RenderHelper;
import net.collectively.geode.math.math;
import net.collectively.geode.types.double3;
import net.minecraft.class_10017;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public record ArmorTooltipComponent(ArmorTooltipData data) implements class_5684
{
    private static final List<ArmorTooltipPreviewHandler> PREVIEW_HANDLERS = new ArrayList<ArmorTooltipPreviewHandler>();
    public static final class_1304 BASE_EQUIPMENT_SLOT = null;
    private static final int BASE_HEIGHT = 32;

    public static void registerPreviewHandler(ArmorTooltipPreviewHandler handler) {
        PREVIEW_HANDLERS.add(handler);
    }

    @Nullable
    public static ArmorTooltipPreviewHandler getTooltipPreviewHandler(class_1799 itemStack) {
        class_10192 equippableComponent = (class_10192)itemStack.method_58694(class_9334.field_54196);
        class_1304 slot = equippableComponent == null ? BASE_EQUIPMENT_SLOT : equippableComponent.comp_3174();
        for (ArmorTooltipPreviewHandler handler : PREVIEW_HANDLERS) {
            if (!handler.validate(itemStack, slot)) continue;
            return handler;
        }
        return null;
    }

    public int method_32661(class_327 textRenderer) {
        ArmorTooltipPreviewHandler handler;
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        class_638 world = client.field_1687;
        if (world == null || clientPlayer == null) {
            return 32;
        }
        class_10192 equippableComponent = (class_10192)this.data.itemStack().method_58694(class_9334.field_54196);
        class_1304 slot = BASE_EQUIPMENT_SLOT;
        if (equippableComponent != null) {
            slot = equippableComponent.comp_3174();
        }
        return 32 + ((handler = ArmorTooltipComponent.getTooltipPreviewHandler(this.data().itemStack())) == null ? 0 : handler.getHeight(this, slot).orElse(0));
    }

    public int method_32664(class_327 textRenderer) {
        return 48;
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;
        class_638 world = client.field_1687;
        if (world == null || clientPlayer == null) {
            return;
        }
        class_10192 equippableComponent = (class_10192)this.data.itemStack().method_58694(class_9334.field_54196);
        class_1304 slot = BASE_EQUIPMENT_SLOT;
        if (equippableComponent != null) {
            slot = equippableComponent.comp_3174();
        }
        EntityInfo entityInfo = null;
        ArmorTooltipPreviewHandler validHandler = null;
        for (ArmorTooltipPreviewHandler handler : PREVIEW_HANDLERS) {
            if (!handler.validate(this.data.itemStack(), slot)) continue;
            entityInfo = handler.getEntityInfo(this, slot);
            validHandler = handler;
            break;
        }
        if (entityInfo == null) {
            return;
        }
        class_10017 entityRenderState = entityInfo.renderState();
        if (entityRenderState == null) {
            return;
        }
        validHandler.modifyRenderState(this, entityRenderState);
        double smoothTime = math.lerp((float)RenderHelper.getTickDelta(), (float)(world.method_75260() - 1L), (float)world.method_75260());
        Quaternionf rotation = RenderHelper.rotation((double3)new double3(25.0, smoothTime, 180.0).modify(math::deg2rad));
        Quaternionf cameraAngle = RenderHelper.rotation((double3)new double3(0.0, 0.0, 0.0).modify(math::deg2rad));
        context.method_70856(entityRenderState, entityInfo.scale(), new Vector3f(0.0f, entityInfo.verticalOffset(), 0.0f), rotation, cameraAngle, x, y, x + this.method_32664(textRenderer), y + this.method_32661(textRenderer));
    }

    public record EntityInfo(class_1309 livingEntity, float scale, float verticalOffset) {
        @Nullable
        public class_10017 renderState() {
            class_898 entityRenderManager = class_310.method_1551().method_1561();
            class_897 entityRenderer = entityRenderManager.method_3953((class_1297)this.livingEntity);
            if (entityRenderer == null) {
                return null;
            }
            class_10017 renderState = entityRenderer.method_62425((class_1297)this.livingEntity, RenderHelper.getTickDelta());
            renderState.field_61820 = 0xF000F0;
            renderState.field_61823.clear();
            renderState.field_61821 = 0;
            return renderState;
        }
    }
}

