/*
 * Decompiled with CFR 0.152.
 */
package dev.rosenoire.legion.client.tooltip;

import dev.rosenoire.legion.client.Legion;
import dev.rosenoire.legion.client.tooltip.ArmorTooltipComponent;
import dev.rosenoire.legion.client.tooltip.ArmorTooltipPreviewHandler;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_11903;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8052;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ArmorTrimTooltipPreviewHandler
implements ArmorTooltipPreviewHandler {
    public static final int SWAP_SPEED = 40;

    @Override
    public boolean validate(class_1799 itemStack, @Nullable class_1304 slot) {
        if (slot != null) {
            return false;
        }
        return itemStack.method_7909() instanceof class_8052;
    }

    @Override
    public Optional<Integer> getHeight(ArmorTooltipComponent component, class_1304 slot) {
        return Optional.of(48);
    }

    @Override
    @Nullable
    public ArmorTooltipComponent.EntityInfo getEntityInfo(ArmorTooltipComponent component, class_1304 slot) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return null;
        }
        class_11903 livingEntity = new class_11903((class_1937)world, client.method_73362());
        class_1799 armorTrimStack = component.data().itemStack();
        if (armorTrimStack.method_7909() instanceof class_8052) {
            if (armorTrimStack.method_31574(class_1802.field_41946)) {
                return null;
            }
            ArmorTrimTooltipPreviewHandler.getRandomItemInTag((class_1937)world, (class_6862<class_1792>)class_3489.field_48297, 0).ifPresent(itemStack -> {
                itemStack.method_57379(class_9334.field_49607, (Object)ArmorTrimTooltipPreviewHandler.getRandomMaterialTrim(world, armorTrimStack, 0));
                livingEntity.method_5673(class_1304.field_6169, itemStack);
            });
            ArmorTrimTooltipPreviewHandler.getRandomItemInTag((class_1937)world, (class_6862<class_1792>)class_3489.field_48296, 1).ifPresent(itemStack -> {
                itemStack.method_57379(class_9334.field_49607, (Object)ArmorTrimTooltipPreviewHandler.getRandomMaterialTrim(world, armorTrimStack, 1));
                livingEntity.method_5673(class_1304.field_6174, itemStack);
            });
            ArmorTrimTooltipPreviewHandler.getRandomItemInTag((class_1937)world, (class_6862<class_1792>)class_3489.field_48295, 2).ifPresent(itemStack -> {
                itemStack.method_57379(class_9334.field_49607, (Object)ArmorTrimTooltipPreviewHandler.getRandomMaterialTrim(world, armorTrimStack, 2));
                livingEntity.method_5673(class_1304.field_6172, itemStack);
            });
            ArmorTrimTooltipPreviewHandler.getRandomItemInTag((class_1937)world, (class_6862<class_1792>)class_3489.field_48294, 3).ifPresent(itemStack -> {
                itemStack.method_57379(class_9334.field_49607, (Object)ArmorTrimTooltipPreviewHandler.getRandomMaterialTrim(world, armorTrimStack, 3));
                livingEntity.method_5673(class_1304.field_6166, itemStack);
            });
        }
        float scale = 32.0f;
        float verticalOffset = 0.8f;
        return new ArmorTooltipComponent.EntityInfo((class_1309)livingEntity, scale, verticalOffset);
    }

    private static Optional<class_1799> getRandomItemInTag(class_1937 world, class_6862<class_1792> tag, int equipmentOffset) {
        Optional headArmors = class_7923.field_41178.method_46733(tag);
        if (headArmors.isPresent()) {
            class_6885.class_6888 tagContent = (class_6885.class_6888)headArmors.get();
            int index = (int)((world.method_75260() / 40L + (long)equipmentOffset) % (long)tagContent.method_40247());
            class_6880 item = tagContent.method_40240(index);
            return Optional.of(new class_1799(item));
        }
        return Optional.empty();
    }

    @Nullable
    private static class_8053 getRandomMaterialTrim(class_638 world, class_1799 itemStack, int materialOffset) {
        class_5455 registries = world.method_30349();
        Optional potentialTrimPatternRegistry = registries.method_46759(class_7924.field_42082);
        if (potentialTrimPatternRegistry.isPresent()) {
            Optional potentialTrimMaterialRegistry;
            class_2378 trimPatternRegistry = (class_2378)potentialTrimPatternRegistry.get();
            class_2960 itemIdentifier = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
            String armorTrimPatternPath = itemIdentifier.method_12832().replace("_armor_trim_smithing_template", "");
            class_2960 armorTrimPatternIdentifier = class_2960.method_60655((String)itemIdentifier.method_12836(), (String)armorTrimPatternPath);
            class_8056 armorTrim = (class_8056)trimPatternRegistry.method_63535(armorTrimPatternIdentifier);
            if (armorTrim != null && (potentialTrimMaterialRegistry = registries.method_46759(class_7924.field_42083)).isPresent()) {
                int index;
                class_2378 trimMaterialRegistry = (class_2378)potentialTrimMaterialRegistry.get();
                class_8054 material = (class_8054)trimMaterialRegistry.method_10200(index = (int)((world.method_75260() / 40L + (long)materialOffset) % (long)trimMaterialRegistry.method_10204()));
                if (material == null) {
                    Legion.LOGGER.error("Could not load trim material at index {}/{}!", (Object)index, (Object)trimMaterialRegistry.method_10204());
                    return null;
                }
                return new class_8053(trimMaterialRegistry.method_47983((Object)material), trimPatternRegistry.method_47983((Object)armorTrim));
            }
        }
        return null;
    }

    @Override
    public void modifyRenderState(ArmorTooltipComponent component, class_10017 renderState) {
        if (renderState instanceof class_10055) {
            class_10055 playerEntityRenderState = (class_10055)renderState;
            class_310 client = class_310.method_1551();
            class_746 clientPlayer = client.field_1724;
            if (clientPlayer == null) {
                return;
            }
            playerEntityRenderState.field_53520 = clientPlayer.method_52814();
            playerEntityRenderState.field_53446 = 0.0f;
            playerEntityRenderState.field_53447 = 0.0f;
        }
    }
}

