/*
 * Decompiled with CFR 0.152.
 */
package dev.rosenoire.legion.client.tooltip;

import dev.rosenoire.legion.client.tooltip.PotionTooltipData;
import dev.rosenoire.legion.fundation.util.RomanNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class PotionTooltipComponent
implements class_5684 {
    private final PotionTooltipData tooltipData;
    private final RenderableStatusEffect[] renderableStatusEffects;

    public PotionTooltipComponent(PotionTooltipData tooltipData) {
        this.tooltipData = tooltipData;
        this.renderableStatusEffects = (RenderableStatusEffect[])this.tooltipData.getEffects().stream().map(instance -> RenderableStatusEffect.fromInstance(instance, this.tooltipData.getDurationMultiplier(), this.tooltipData.getChance((class_1293)instance))).toArray(RenderableStatusEffect[]::new);
    }

    public int method_32661(class_327 textRenderer) {
        return 20 * this.renderableStatusEffects.length + 3;
    }

    public int method_32664(class_327 textRenderer) {
        return 24 + Math.max(Arrays.stream(this.renderableStatusEffects).map(this::getPotionStatsText).map(text -> textRenderer.method_30880(text.method_30937())).max(Integer::compare).orElse(0), Arrays.stream(this.renderableStatusEffects).map(this::getNameText).map(text -> textRenderer.method_30880(text.method_30937())).max(Integer::compare).orElse(0));
    }

    private class_2561 getNameText(RenderableStatusEffect renderable) {
        class_5250 nameText = class_2561.method_43471((String)renderable.nameTranslationKey());
        class_5250 levelText = class_2561.method_43470((String)(" " + RomanNumber.toRoman(renderable.amplifier() + 1)));
        class_5250 chanceText = class_2561.method_43470((String)"");
        if (renderable.chance < 1.0f) {
            int chanceInt = Math.round(renderable.chance * 100.0f);
            chanceText = class_2561.method_43470((String)(" (" + chanceInt + "%)")).method_27692(class_124.field_1063);
        }
        return nameText.method_10852((class_2561)levelText).method_54663(((class_1291)renderable.effect().comp_349()).method_5556()).method_10852((class_2561)chanceText);
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        int stackHeight = -1;
        for (RenderableStatusEffect statusEffect : this.renderableStatusEffects) {
            context.method_52707(class_10799.field_56883, class_329.method_71644(statusEffect.effect()), x + 2, y + 2 + stackHeight, 18, 18, -1);
            context.method_51439(textRenderer, this.getNameText(statusEffect), x + 18 + 2 + 4, y + 2 + stackHeight, -1, false);
            class_5250 bottomText = this.getPotionStatsText(statusEffect);
            class_5250 class_52502 = bottomText.method_27692(class_124.field_1080);
            Objects.requireNonNull(textRenderer);
            context.method_51439(textRenderer, (class_2561)class_52502, x + 18 + 2 + 4, y + 2 + stackHeight + 9, -1, false);
            stackHeight += 20;
        }
    }

    private class_5250 getPotionStatsText(RenderableStatusEffect effect) {
        class_5250 text = effect.durationText().method_27661().method_27693(" ");
        HashMap entityAttributeModifiers = new HashMap();
        for (Map.Entry entry : ((class_1291)effect.effect().comp_349()).field_5885.entrySet()) {
            if (!entityAttributeModifiers.containsKey(entry.getKey())) {
                entityAttributeModifiers.put((class_6880)entry.getKey(), new ArrayList());
            }
            ((List)entityAttributeModifiers.get(entry.getKey())).add(((class_1291.class_8634)entry.getValue()).method_52522(effect.amplifier()));
        }
        if (entityAttributeModifiers.isEmpty()) {
            return text;
        }
        for (Map.Entry entry : entityAttributeModifiers.entrySet()) {
            class_6880 attribute = (class_6880)entry.getKey();
            for (class_1322 modifier : (List)entry.getValue()) {
                double value = modifier.comp_2449();
                double effectiveValue = modifier.comp_2449();
                if (modifier.comp_2450() == class_1322.class_1323.field_6330 || modifier.comp_2450() == class_1322.class_1323.field_6331) {
                    effectiveValue *= 100.0;
                }
                if (value > 0.0) {
                    text.method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(effectiveValue), class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830())}).method_27692(class_124.field_1078));
                } else if (value < 0.0) {
                    text.method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(effectiveValue *= -1.0), class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830())}).method_27692(class_124.field_1061));
                }
                text = text.method_27693(" ");
            }
        }
        return text;
    }

    private record RenderableStatusEffect(class_6880<class_1291> effect, String nameTranslationKey, class_2561 durationText, int amplifier, float chance) {
        @Nullable
        public static RenderableStatusEffect fromInstance(class_1293 instance, double durationMultiplier, float chance) {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) {
                return null;
            }
            float tickRate = client.field_1687.method_54719().method_54748();
            class_2561 durationText = class_1292.method_5577((class_1293)instance, (float)((float)durationMultiplier), (float)tickRate);
            return new RenderableStatusEffect((class_6880<class_1291>)instance.method_5579(), instance.method_5586(), durationText, instance.method_5578(), chance);
        }
    }
}

