/*
 * Decompiled with CFR 0.152.
 */
package dev.rosenoire.legion.fundation.util;

public class RomanNumber {
    private static final int MIN_VALUE = 1;
    private static final int MAX_VALUE = 3999;
    private static final String[] RN_M = new String[]{"", "M", "MM", "MMM"};
    private static final String[] RN_C = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    private static final String[] RN_X = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    private static final String[] RN_I = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};

    public static String toRoman(int number) {
        if (number < 1 || number > 3999) {
            throw new IllegalArgumentException(String.format("The number must be in the range [%d, %d]", 1, 3999));
        }
        return RN_M[number / 1000] + RN_C[number % 1000 / 100] + RN_X[number % 100 / 10] + RN_I[number % 10];
    }
}

