/*
 * Decompiled with CFR 0.152.
 */
package net.collectively.geode.datagen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.collectively.geode.datagen.DataGenRunnable;
import net.collectively.geode.datagen.EnchantmentEntry;
import net.collectively.geode.datagen.GeodeEnchantmentGenerator;
import net.collectively.geode.datagen.IncompleteGetter;
import net.collectively.geode.helpers.RegistryHelper;
import net.collectively.geode.helpers.StringHelper;
import net.collectively.geode.registration.GeodeEnchantment;
import net.collectively.geode.registration.GeodeItemGroup;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_10795;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3495;
import net.minecraft.class_3902;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_790;
import net.minecraft.class_7924;
import net.minecraft.class_807;
import net.minecraft.class_8110;
import net.minecraft.class_813;
import net.minecraft.class_815;
import net.minecraft.class_819;
import net.minecraft.class_9274;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9636;
import net.minecraft.class_9698;
import net.minecraft.class_9703;
import net.minecraft.class_9710;
import net.minecraft.class_9720;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public abstract class GeodeDataGeneration
implements class_2405 {
    private final List<DataGenRunnable<?>> registeredRunnable = new ArrayList();
    private final DataGen dataGen;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;

    protected final <T extends DataGenRunnable<?>> T addRunnable(T runnable) {
        this.registeredRunnable.add(runnable);
        return (T)this.registeredRunnable.getLast();
    }

    protected final EnchantmentRunnable addEnchantment(GeodeEnchantment value) {
        return this.addRunnable(new EnchantmentRunnable(value));
    }

    protected final ItemGroupRunnable addItemGroup(GeodeItemGroup value) {
        return this.addRunnable(new ItemGroupRunnable(value));
    }

    protected final ItemRunnable addItem(class_1792 value) {
        return this.addRunnable(new ItemRunnable(value));
    }

    protected final BlockRunnable addBlock(class_2248 value) {
        return this.addRunnable(new BlockRunnable(value));
    }

    protected final BlockEntityRunnable addBlockEntity(class_2586 value) {
        return this.addRunnable(new BlockEntityRunnable(value));
    }

    protected final SoundRunnable addSound(class_3414 value) {
        return this.addRunnable(new SoundRunnable(value));
    }

    protected final <U extends class_1297> EntityTypeRunnable<U> addEntityType(class_1299<U> value) {
        return this.addRunnable(new EntityTypeRunnable<U>(value));
    }

    protected abstract void generate();

    public GeodeDataGeneration(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.dataGen = new DataGen(dataOutput, registriesFuture);
        this.registriesFuture = registriesFuture;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registriesFuture.thenCompose(registries -> {
            this.generate();
            for (DataGenRunnable<?> target : this.registeredRunnable) {
                target.run((class_7225.class_7874)registries, this.dataGen);
            }
            return CompletableFuture.allOf(this.dataGen.translations.method_10319(writer), this.dataGen.enchantments.method_10319(writer), this.dataGen.enchantmentTags.method_10319(writer), this.dataGen.models.method_10319(writer));
        });
    }

    public String method_10321() {
        return "GeodeDataGen";
    }

    public abstract String getModId();

    public class_2960 linkedModId(String identifier) {
        return class_2960.method_60655((String)this.getModId(), (String)identifier);
    }

    public static final class EnchantmentRunnable
    extends DataGenRunnable<GeodeEnchantment>
    implements Translatable<EnchantmentRunnable>,
    AutoTranslatable<EnchantmentRunnable> {
        private IncompleteGetter<String> nameTranslation;
        private String descriptionTranslation;
        private IncompleteEnchantment enchantment;
        private final List<class_6862<class_1887>> tags = new ArrayList<class_6862<class_1887>>();

        public EnchantmentRunnable(GeodeEnchantment target) {
            super(target);
        }

        @Override
        protected void run(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull class_7225.class_7874 registries, DataGen dataGen) {
            String nameKey = class_156.method_646((String)"enchantment", (class_2960)((GeodeEnchantment)this.value).identifier());
            dataGen.translations.add(nameKey, this.nameTranslation.complete(registries));
            if (this.descriptionTranslation != null && !this.descriptionTranslation.isBlank()) {
                dataGen.translations.add(nameKey + ".desc", this.descriptionTranslation);
            }
            if (this.enchantment != null) {
                dataGen.enchantments.add((GeodeEnchantment)this.value, this.enchantment);
                if (this.enchantment.definition.isTreasure) {
                    dataGen.enchantmentTags.add((class_6862<class_1887>)class_9636.field_51557, (GeodeEnchantment)this.value);
                } else {
                    dataGen.enchantmentTags.add((class_6862<class_1887>)class_9636.field_51558, (GeodeEnchantment)this.value);
                }
            }
            if (!this.tags.isEmpty()) {
                for (class_6862<class_1887> tag : this.tags) {
                    if (tag == class_9636.field_51558 || tag == class_9636.field_51557) continue;
                    dataGen.enchantmentTags.add(tag, (GeodeEnchantment)this.value);
                }
            }
        }

        @Override
        public EnchantmentRunnable translate(String translation) {
            this.nameTranslation = registries -> translation;
            return this;
        }

        @Override
        public EnchantmentRunnable autoTranslate() {
            this.nameTranslation = registries -> StringHelper.toHumanReadableName(((GeodeEnchantment)this.value).registryKey().method_29177());
            return this;
        }

        public EnchantmentRunnable translateDescription(String translation) {
            this.descriptionTranslation = translation;
            return this;
        }

        public IncompleteEnchantment enchantment(class_6862<class_1792> supportedItems) {
            return new IncompleteEnchantment(this, RegistrationUtils.itemTag(supportedItems));
        }

        public EnchantmentRunnable tag(class_6862<class_1887> tag) {
            this.tags.add(tag);
            return this;
        }
    }

    public static final class ItemGroupRunnable
    extends DataGenRunnable<GeodeItemGroup>
    implements Translatable<ItemGroupRunnable>,
    AutoTranslatable<ItemGroupRunnable> {
        private IncompleteGetter<String> nameTranslation;

        public ItemGroupRunnable(GeodeItemGroup value) {
            super(value);
        }

        @Override
        protected void run(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull class_7225.class_7874 registries, DataGen dataGen) {
            dataGen.translations.add(((GeodeItemGroup)this.value).getTranslationKey(), this.nameTranslation.complete(registries));
        }

        @Override
        public ItemGroupRunnable translate(String translation) {
            this.nameTranslation = registries -> translation;
            return this;
        }

        @Override
        public ItemGroupRunnable autoTranslate() {
            this.nameTranslation = registries -> StringHelper.toHumanReadableName(((GeodeItemGroup)this.value).registryKey().method_29177());
            return this;
        }
    }

    public static final class ItemRunnable
    extends DataGenRunnable<class_1792>
    implements Translatable<ItemRunnable>,
    AutoTranslatable<ItemRunnable> {
        private IncompleteGetter<String> nameTranslation;

        public ItemRunnable(class_1792 item) {
            super(item);
        }

        @Override
        protected void run(@NotNull class_7225.class_7874 registries, DataGen dataGen) {
            dataGen.translations.add(((class_1792)this.value).method_7876(), this.nameTranslation.complete(registries));
        }

        @Override
        public ItemRunnable translate(String translation) {
            this.nameTranslation = registries -> translation;
            return this;
        }

        @Override
        public ItemRunnable autoTranslate() {
            this.nameTranslation = registries -> Optional.ofNullable(RegistryHelper.getIdentifierOf(registries, class_7924.field_41197, (class_1792)this.value)).map(StringHelper::toHumanReadableName).orElse(((class_1792)this.value).method_7876());
            return this;
        }
    }

    public final class BlockRunnable
    extends DataGenRunnable<class_2248>
    implements Translatable<BlockRunnable>,
    AutoTranslatable<BlockRunnable> {
        private IncompleteGetter<String> nameTranslation;
        private class_4917 blockStateDefinitionCreator;

        public BlockRunnable(class_2248 block) {
            super(block);
        }

        @Override
        protected void run(@NotNull class_7225.class_7874 registries, DataGen dataGen) {
            dataGen.translations.add(((class_2248)this.value).method_63499(), this.nameTranslation.complete(registries));
            if (this.blockStateDefinitionCreator != null) {
                dataGen.models.addBlockState(this.blockStateDefinitionCreator);
            }
        }

        @Override
        public BlockRunnable translate(String translation) {
            this.nameTranslation = registries -> translation;
            return this;
        }

        @Override
        public BlockRunnable autoTranslate() {
            this.nameTranslation = registries -> Optional.ofNullable(RegistryHelper.getIdentifierOf(registries, class_7924.field_41254, (class_2248)this.value)).map(StringHelper::toHumanReadableName).orElse(((class_2248)this.value).method_63499());
            return this;
        }

        public BlockRunnable variantsBlockstate(Function<class_4925.class_10796, class_4925> definition) {
            this.blockStateDefinitionCreator = (class_4917)definition.apply(class_4925.method_67852((class_2248)((class_2248)this.getValue())));
            return this;
        }

        public BlockRunnable multipartBlockstate(UnaryOperator<MultipartDefinitionCreator> definition) {
            this.blockStateDefinitionCreator = (class_4917)definition.apply(new MultipartDefinitionCreator((class_2248)this.getValue()));
            return this;
        }
    }

    public static final class BlockEntityRunnable
    extends DataGenRunnable<class_2586> {
        public BlockEntityRunnable(class_2586 blockEntity) {
            super(blockEntity);
        }

        @Override
        protected void run(@NotNull class_7225.class_7874 registries, DataGen dataGen) {
        }
    }

    public static final class SoundRunnable
    extends DataGenRunnable<class_3414> {
        private IncompleteGetter<String> subtitleTranslation = null;

        public SoundRunnable(class_3414 sound) {
            super(sound);
        }

        @Override
        protected void run(@NotNull class_7225.class_7874 registries, DataGen dataGen) {
            String key = class_156.method_646((String)"subtitle", (class_2960)((class_3414)this.value).comp_3319());
            dataGen.translations.add(key, Optional.ofNullable(this.subtitleTranslation.complete(registries)).orElse(key));
        }

        public SoundRunnable subtitle(String translation) {
            this.subtitleTranslation = registries -> translation;
            return this;
        }
    }

    public static final class EntityTypeRunnable<U extends class_1297>
    extends DataGenRunnable<class_1299<U>>
    implements Translatable<EntityTypeRunnable<U>>,
    AutoTranslatable<EntityTypeRunnable<U>> {
        private IncompleteGetter<String> nameTranslation;

        public EntityTypeRunnable(class_1299<U> entityType) {
            super(entityType);
        }

        @Override
        protected void run(@NotNull class_7225.class_7874 registries, DataGen dataGen) {
            dataGen.translations.add(((class_1299)this.value).method_5882(), this.nameTranslation.complete(registries));
        }

        @Override
        public EntityTypeRunnable<U> translate(String translation) {
            this.nameTranslation = registries -> translation;
            return this;
        }

        @Override
        public EntityTypeRunnable<U> autoTranslate() {
            this.nameTranslation = registries -> Optional.ofNullable(RegistryHelper.getIdentifierOf(registries, class_7924.field_41266, (class_1299)this.value)).map(StringHelper::toHumanReadableName).orElse(((class_1299)this.value).method_5882());
            return this;
        }
    }

    public static class DataGen {
        public final LanguageGenerator translations;
        public final EnchantmentGenerator enchantments;
        public final EnchantmentTagGenerator enchantmentTags;
        public final ModelGenerator models;
        private final Map<String, String> registeredTranslations = new HashMap<String, String>();
        private final Map<class_2960, IncompleteEnchantment> registeredEnchantments = new HashMap<class_2960, IncompleteEnchantment>();
        private final Map<class_6862<class_1887>, List<class_2960>> registeredEnchantmentTags = new HashMap<class_6862<class_1887>, List<class_2960>>();
        private final List<class_4917> blockStateModelGenerators = new ArrayList<class_4917>();

        public DataGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
            this.translations = new LanguageGenerator(dataOutput, registriesFuture);
            this.enchantments = new EnchantmentGenerator((class_7784)dataOutput, registriesFuture);
            this.enchantmentTags = new EnchantmentTagGenerator(dataOutput, registriesFuture);
            this.models = new ModelGenerator(dataOutput);
        }

        public final class LanguageGenerator
        extends FabricLanguageProvider {
            public LanguageGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
                super(dataOutput, registryLookup);
            }

            public void generateTranslations(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
                DataGen.this.registeredTranslations.forEach((arg_0, arg_1) -> ((FabricLanguageProvider.TranslationBuilder)translationBuilder).add(arg_0, arg_1));
            }

            public void add(String key, String value) {
                DataGen.this.registeredTranslations.put(key, value);
            }
        }

        public final class EnchantmentGenerator
        extends GeodeEnchantmentGenerator {
            public void add(GeodeEnchantment geodeEnchantment, IncompleteEnchantment incompleteEnchantment) {
                DataGen.this.registeredEnchantments.put(geodeEnchantment.identifier(), incompleteEnchantment);
            }

            public EnchantmentGenerator(class_7784 output, CompletableFuture<class_7225.class_7874> registriesFuture) {
                super(output, registriesFuture, List.of((registries, exporter) -> {
                    for (Map.Entry<class_2960, IncompleteEnchantment> enchantment : net$collectively$geode$datagen$GeodeDataGeneration$DataGen$this.registeredEnchantments.entrySet()) {
                        exporter.accept(new EnchantmentEntry(enchantment.getKey(), enchantment.getValue().complete(enchantment.getKey(), registries)));
                    }
                }));
            }
        }

        public final class EnchantmentTagGenerator
        extends FabricTagProvider<class_1887> {
            public void add(class_6862<class_1887> tag, GeodeEnchantment enchantment) {
                if (!DataGen.this.registeredEnchantmentTags.containsKey(tag)) {
                    DataGen.this.registeredEnchantmentTags.put(tag, new ArrayList());
                }
                DataGen.this.registeredEnchantmentTags.get(tag).add(enchantment.identifier());
            }

            private EnchantmentTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
                super(output, class_7924.field_41265, registriesFuture);
            }

            protected void method_10514(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull class_7225.class_7874 wrapperLookup) {
                DataGen.this.registeredEnchantmentTags.forEach((enchantment, identifiers) -> {
                    class_3495 builder = this.method_27169((class_6862)enchantment);
                    identifiers.forEach(arg_0 -> ((class_3495)builder).method_34891(arg_0));
                    builder.method_26782();
                });
            }
        }

        public final class ModelGenerator
        extends FabricModelProvider {
            public void addBlockState(class_4917 definitionCreator) {
                DataGen.this.blockStateModelGenerators.add(definitionCreator);
            }

            private ModelGenerator(FabricDataOutput output) {
                super(output);
            }

            public void generateBlockStateModels(@NonNull class_4910 blockStateModelGenerator) {
                for (class_4917 definitionCreator : DataGen.this.blockStateModelGenerators) {
                    blockStateModelGenerator.field_22830.accept(definitionCreator);
                }
            }

            public void generateItemModels(class_4915 itemModelGenerator) {
            }
        }
    }

    public class MultipartDefinitionCreator
    implements class_4917 {
        private final List<Part> parts = new ArrayList<Part>();
        private final class_2248 block;

        public MultipartDefinitionCreator(class_2248 block) {
            this.block = block;
        }

        public class_2248 method_25743() {
            return this.block;
        }

        public MultipartDefinitionCreator with(@Nullable class_815 condition, class_807 variant) {
            if (condition != null) {
                this.validate(condition);
            }
            Part part = new Part(Optional.ofNullable(condition), variant);
            this.parts.add(part);
            return this;
        }

        public MultipartDefinitionCreator with(@Nullable class_815 condition, UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with(condition, class_4910.method_67833((class_813[])((class_813[])Arrays.stream(variants).map(class_4910::method_67806).map(operator).toArray(class_813[]::new))));
        }

        public MultipartDefinitionCreator with(@Nullable class_815 condition, UnaryOperator<class_813> operator, String ... variants) {
            return this.with(condition, operator, (class_2960[])Arrays.stream(variants).map(GeodeDataGeneration.this::linkedModId).toArray(class_2960[]::new));
        }

        public MultipartDefinitionCreator with(@Nullable class_815 condition, class_2960 ... variants) {
            return this.with(condition, ignored -> ignored, variants);
        }

        public MultipartDefinitionCreator with(@Nullable class_815 condition, String ... variants) {
            return this.with(condition, ignored -> ignored, variants);
        }

        public MultipartDefinitionCreator with(@Nullable class_10795 condition, UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with((class_815)Optional.ofNullable(condition).map(class_10795::method_67845).orElse(null), operator, variants);
        }

        public MultipartDefinitionCreator with(@Nullable class_10795 condition, UnaryOperator<class_813> operator, String ... variants) {
            return this.with((class_815)Optional.ofNullable(condition).map(class_10795::method_67845).orElse(null), operator, variants);
        }

        public MultipartDefinitionCreator with(@Nullable class_10795 condition, class_2960 ... variants) {
            return this.with((class_815)Optional.ofNullable(condition).map(class_10795::method_67845).orElse(null), ignored -> ignored, variants);
        }

        public MultipartDefinitionCreator with(@Nullable class_10795 condition, String ... variants) {
            return this.with((class_815)Optional.ofNullable(condition).map(class_10795::method_67845).orElse(null), ignored -> ignored, variants);
        }

        public <T extends Comparable<T>> MultipartDefinitionCreator with(class_2769<T> property, T value, UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value), operator, variants);
        }

        public <T extends Comparable<T>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2960 ... variants) {
            return this.with(property, value, ignored -> ignored, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value).method_67847(property2, value2), operator, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, class_2960 ... variants) {
            return this.with(property, value, property2, value2, ignored -> ignored, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, class_2769<V> property3, V value3, UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value).method_67847(property2, value2).method_67847(property3, value3), operator, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, class_2769<V> property3, V value3, class_2960 ... variants) {
            return this.with(property, value, property2, value2, property3, value3, ignored -> ignored, variants);
        }

        public <T extends Comparable<T>> MultipartDefinitionCreator with(class_2769<T> property, T value, UnaryOperator<class_813> operator, String ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value), operator, variants);
        }

        public <T extends Comparable<T>> MultipartDefinitionCreator with(class_2769<T> property, T value, String ... variants) {
            return this.with(property, value, ignored -> ignored, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, UnaryOperator<class_813> operator, String ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value).method_67847(property2, value2), operator, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, String ... variants) {
            return this.with(property, value, property2, value2, ignored -> ignored, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, class_2769<V> property3, V value3, UnaryOperator<class_813> operator, String ... variants) {
            return this.with(class_4910.method_67834().method_67847(property, value).method_67847(property2, value2).method_67847(property3, value3), operator, variants);
        }

        public <T extends Comparable<T>, U extends Comparable<U>, V extends Comparable<V>> MultipartDefinitionCreator with(class_2769<T> property, T value, class_2769<U> property2, U value2, class_2769<V> property3, V value3, String ... variants) {
            return this.with(property, value, property2, value2, property3, value3, ignored -> ignored, variants);
        }

        public MultipartDefinitionCreator with(UnaryOperator<class_813> operator, class_2960 ... variants) {
            return this.with((class_815)null, operator, variants);
        }

        public MultipartDefinitionCreator with(UnaryOperator<class_813> operator, String ... variants) {
            return this.with((class_815)null, operator, variants);
        }

        public MultipartDefinitionCreator with(class_2960 ... variants) {
            return this.with((class_815)null, ignored -> ignored, variants);
        }

        public MultipartDefinitionCreator with(String ... variants) {
            return this.with((class_815)null, ignored -> ignored, variants);
        }

        private void validate(class_815 selector) {
            selector.instantiate(this.block.method_9595());
        }

        public class_790 method_67844() {
            return new class_790(Optional.empty(), Optional.of(new class_790.class_9982(this.parts.stream().map(Part::toComponent).toList())));
        }

        @Environment(value=EnvType.CLIENT)
        private record Part(Optional<class_815> condition, class_807 variants) {
            public class_819 toComponent() {
                return new class_819(this.condition, this.variants.method_68471());
            }
        }
    }

    public static final class IncompleteEnchantment {
        private final EnchantmentRunnable parent;
        private final IncompleteDefinition definition;
        private IncompleteGetter<class_6885<class_1887>> exclusiveSet = lookup -> class_6885.method_40246((class_6880[])new class_6880[0]);
        private final Map<class_9331<?>, List<?>> effectLists = new HashMap();
        private final class_9323.class_9324 effectMap = class_9323.method_57827();

        private IncompleteEnchantment(EnchantmentRunnable parent, IncompleteGetter<class_6885<class_1792>> supportedItems) {
            this.parent = parent;
            this.definition = new IncompleteDefinition(supportedItems);
        }

        public EnchantmentRunnable build() {
            this.parent.enchantment = this;
            return this.parent;
        }

        public IncompleteEnchantment exclusiveSet(class_6862<class_1887> exclusiveSet) {
            this.exclusiveSet = RegistrationUtils.enchantmentTag(exclusiveSet);
            return this;
        }

        @NotNull
        public <E> IncompleteEnchantment addEffect(class_9331<List<class_9698<E>>> effectType, E effect, class_5341.class_210 requirements) {
            this.getEffectsList(effectType).add(new class_9698(effect, Optional.of(requirements.build())));
            return this;
        }

        @NotNull
        public <E> IncompleteEnchantment addEffect(class_9331<List<class_9698<E>>> effectType, E effect) {
            this.getEffectsList(effectType).add(new class_9698(effect, Optional.empty()));
            return this;
        }

        @NotNull
        public <E> IncompleteEnchantment addEffect(class_9331<List<class_9710<E>>> type, class_9703 enchanted, class_9703 affected, E effect, class_5341.class_210 requirements) {
            this.getEffectsList(type).add(new class_9710(enchanted, affected, effect, Optional.of(requirements.build())));
            return this;
        }

        @NotNull
        public <E> IncompleteEnchantment addEffect(class_9331<List<class_9710<E>>> type, class_9703 enchanted, class_9703 affected, E effect) {
            this.getEffectsList(type).add(new class_9710(enchanted, affected, effect, Optional.empty()));
            return this;
        }

        @NotNull
        public IncompleteEnchantment addEffect(class_9331<List<class_9720>> type, class_9720 effect) {
            this.getEffectsList(type).add(effect);
            return this;
        }

        @NotNull
        public <E> IncompleteEnchantment addNonListEffect(class_9331<E> type, E effect) {
            this.effectMap.method_57840(type, effect);
            return this;
        }

        @NotNull
        public IncompleteEnchantment addEffect(class_9331<class_3902> type) {
            this.effectMap.method_57840(type, (Object)class_3902.field_17274);
            return this;
        }

        private <E> List<E> getEffectsList(class_9331<List<E>> type) {
            return this.effectLists.computeIfAbsent(type, ignored -> {
                ArrayList arrayList = new ArrayList();
                this.effectMap.method_57840(type, arrayList);
                return arrayList;
            });
        }

        public IncompleteEnchantment primaryItems(class_6862<class_1792> items) {
            this.definition.primaryItems = Optional.ofNullable(items == null ? null : RegistrationUtils.itemTag(items));
            return this;
        }

        public IncompleteEnchantment weight(int weight) {
            this.definition.weight = weight;
            return this;
        }

        public IncompleteEnchantment maxLevel(int maxLevel) {
            this.definition.maxLevel = maxLevel;
            return this;
        }

        public IncompleteEnchantment minCost(int base, int perLevelAboveFirst) {
            this.definition.minCost = new class_1887.class_9426(base, perLevelAboveFirst);
            return this;
        }

        public IncompleteEnchantment maxCost(int base, int perLevelAboveFirst) {
            this.definition.maxCost = new class_1887.class_9426(base, perLevelAboveFirst);
            return this;
        }

        public IncompleteEnchantment anvilCost(int anvilCost) {
            this.definition.anvilCost = anvilCost;
            return this;
        }

        public IncompleteEnchantment isTreasure(boolean isTreasure) {
            this.definition.isTreasure = isTreasure;
            return this;
        }

        public IncompleteEnchantment addSlot(class_9274 slot) {
            if (!this.definition.slots.contains(slot)) {
                this.definition.slots.add(slot);
            }
            return this;
        }

        public class_1887 complete(class_2960 identifier, class_7225.class_7874 registries) {
            return new class_1887((class_2561)class_2561.method_43471((String)class_156.method_646((String)"enchantment", (class_2960)identifier)), this.definition.complete(identifier, registries), this.exclusiveSet.complete(registries), this.effectMap.method_57838());
        }

        public static class IncompleteDefinition {
            public final List<class_9274> slots = new ArrayList<class_9274>();
            public final IncompleteGetter<class_6885<class_1792>> supportedItems;
            public Optional<IncompleteGetter<class_6885<class_1792>>> primaryItems = Optional.empty();
            public int weight = 1;
            public int maxLevel = 1;
            public class_1887.class_9426 minCost = new class_1887.class_9426(1, 1);
            public class_1887.class_9426 maxCost = new class_1887.class_9426(1, 1);
            public int anvilCost = 1;
            public boolean isTreasure;

            private IncompleteDefinition(IncompleteGetter<class_6885<class_1792>> supportedItems) {
                this.supportedItems = supportedItems;
            }

            public class_1887.class_9427 complete(class_2960 identifier, class_7225.class_7874 registries) {
                return new class_1887.class_9427(this.supportedItems.complete(registries), this.primaryItems.map(x -> (class_6885)x.complete(registries)), this.weight, this.maxLevel, this.minCost, this.maxCost, this.anvilCost, this.slots);
            }
        }
    }

    public static interface RegistrationUtils {
        public static <T> class_7225.class_7226<T> getRegistry(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull class_7225.class_7874 registriesFuture, class_5321<? extends class_2378<T>> registryKey) {
            return registriesFuture.method_46762(registryKey);
        }

        public static IncompleteGetter<class_6885<class_1792>> itemTag(class_6862<class_1792> tag) {
            return registries -> RegistrationUtils.getRegistry(registries, class_7924.field_41197).method_46735(tag);
        }

        public static IncompleteGetter<class_6885<class_8110>> damageTag(class_6862<class_8110> tag) {
            return registries -> RegistrationUtils.getRegistry(registries, class_7924.field_42534).method_46735(tag);
        }

        public static IncompleteGetter<class_6885<class_1887>> enchantmentTag(class_6862<class_1887> tag) {
            return registries -> RegistrationUtils.getRegistry(registries, class_7924.field_41265).method_46735(tag);
        }

        public static IncompleteGetter<class_6885<class_2248>> blockTag(class_6862<class_2248> tag) {
            return registries -> RegistrationUtils.getRegistry(registries, class_7924.field_41254).method_46735(tag);
        }

        public static IncompleteGetter<class_6885<class_1299<?>>> entityTypeTag(class_6862<class_1299<?>> tag) {
            return registries -> RegistrationUtils.getRegistry(registries, class_7924.field_41266).method_46735(tag);
        }
    }

    public static interface AutoTranslatable<T extends DataGenRunnable<?>> {
        public T autoTranslate();

        default public <U> Optional<String> getHumanReadableName(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull class_7225.class_7874 registries, @NotNull U value, @NotNull class_5321<class_2378<U>> registryKey) {
            return Optional.ofNullable(RegistryHelper.getIdentifierOf(registries, registryKey, value)).map(StringHelper::toHumanReadableName);
        }
    }

    public static interface Translatable<T extends DataGenRunnable<?>> {
        public T translate(String var1);
    }
}

