/*
 * Decompiled with CFR 0.152.
 */
package net.collectively.geode.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.collectively.geode.helpers.EntityHelper;
import net.collectively.geode.types.double3;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public interface WorldHelper {
    @Nullable
    public static class_1297 raymarchToClosest(class_1937 world, @Nullable class_1297 except, double3 direction, double3 startPosition, RaymarchSettings settings) {
        class_1297 closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        for (int i = 0; i < settings.stepCount(); ++i) {
            double3 pos = startPosition.add(direction.mul(settings.increment() * (double)i));
            double radius = settings.startingRadius() + (double)i * settings.radiusIncrement();
            List<class_1297> entities = EntityHelper.getEntitiesAround(except, world, pos, radius);
            for (class_1297 entity : entities) {
                double distance = entity.method_73189().method_1022(pos.toVec3d());
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestEntity = entity;
            }
        }
        return closestEntity;
    }

    public static List<class_1297> raymarchAll(class_1937 world, @Nullable class_1297 except, double3 direction, double3 startPosition, RaymarchSettings settings) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (int i = 0; i < settings.stepCount(); ++i) {
            double3 pos = startPosition.add(direction.mul(settings.increment() * (double)i));
            double radius = settings.startingRadius() + (double)i * settings.radiusIncrement();
            entities.addAll(EntityHelper.getEntitiesAround(except, world, pos, radius));
        }
        return entities;
    }

    public record RaymarchSettings(int stepCount, double increment, double startingRadius, double radiusIncrement, Predicate<class_1297> validate) {
    }
}

