/*
 * Decompiled with CFR 0.152.
 */
package net.collectively.geode.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_11719;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class TextBuilder {
    public static class_2583 DEFAULT_STYLE = class_2583.field_24360;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final class_2583 defaultStyle;

    public static void resetDefaultStyle() {
        DEFAULT_STYLE = class_2583.field_24360;
    }

    public static TextBuilder of(class_2583 defaultStyle) {
        return new TextBuilder(defaultStyle);
    }

    public static TextBuilder of() {
        return new TextBuilder(DEFAULT_STYLE);
    }

    private TextBuilder(class_2583 defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public class_5250 build() {
        class_5250 current = class_2561.method_43473();
        for (Entry entry : this.entries) {
            current.method_10852((class_2561)entry.build());
        }
        return current;
    }

    private TextBuilder addEntry(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    public TextBuilder text(class_2561 text, class_2583 style) {
        return this.addEntry(new Entry((class_5250)text, style));
    }

    public TextBuilder text(String text, class_2583 style) {
        return this.text((class_2561)class_2561.method_43470((String)text), style);
    }

    public TextBuilder text(Object object, class_2583 style) {
        return this.text(String.valueOf(object), style);
    }

    public TextBuilder text(class_2561 text) {
        return this.text(text, this.defaultStyle);
    }

    public TextBuilder text(String text) {
        return this.text(text, this.defaultStyle);
    }

    public TextBuilder text(Object object) {
        return this.text(object, this.defaultStyle);
    }

    public TextBuilder style(class_2583 style) {
        this.entries.getLast().modify(ignored -> style);
        return this;
    }

    public TextBuilder style(UnaryOperator<class_2583> modifier) {
        this.entries.getLast().modify(modifier);
        return this;
    }

    public TextBuilder formatting(class_124 formatting) {
        this.entries.getLast().modify(style -> style.method_27706(formatting));
        return this;
    }

    public TextBuilder color(int color) {
        return this.style(style -> style.method_36139(color));
    }

    public TextBuilder shadowColor(int color) {
        return this.style(style -> style.method_65302(color));
    }

    public TextBuilder bold(boolean bold) {
        return this.style(style -> style.method_10982(Boolean.valueOf(bold)));
    }

    public TextBuilder italic(boolean italic) {
        return this.style(style -> style.method_10978(Boolean.valueOf(italic)));
    }

    public TextBuilder underline(boolean underlined) {
        return this.style(style -> style.method_30938(Boolean.valueOf(underlined)));
    }

    public TextBuilder strikethrough(boolean strikethrough) {
        return this.style(style -> style.method_36140(Boolean.valueOf(strikethrough)));
    }

    public TextBuilder obfuscated(boolean obfuscated) {
        return this.style(style -> style.method_36141(Boolean.valueOf(obfuscated)));
    }

    public TextBuilder clickEvent(class_2558 clickEvent) {
        return this.style(style -> style.method_10958(clickEvent));
    }

    public TextBuilder hoverEvent(class_2568 hoverEvent) {
        return this.style(style -> style.method_10949(hoverEvent));
    }

    public TextBuilder font(class_11719 font) {
        return this.style(style -> style.method_27704(font));
    }

    private static class Entry {
        public final class_5250 text;
        public class_2583 style;

        public Entry(class_5250 text, class_2583 style) {
            this.text = text;
            this.style = style;
        }

        public void modify(UnaryOperator<class_2583> modifier) {
            this.style = (class_2583)modifier.apply(this.style);
        }

        public class_5250 build() {
            return this.text.method_10862(this.style);
        }
    }
}

