/*
 * Decompiled with CFR 0.152.
 */
package net.collectively.geode.types;

import com.mojang.serialization.Codec;
import java.util.List;
import net.collectively.geode.math.math;
import net.minecraft.class_156;
import net.minecraft.class_241;
import org.joml.Vector2d;
import org.joml.Vector2f;

public record double2(double x, double y) implements Comparable<double2>
{
    public static final Codec<double2> CODEC = Codec.DOUBLE.listOf().comapFlatMap(c -> class_156.method_33141((List)c, (int)2).map(coords -> new double2((Double)coords.getFirst(), (Double)coords.get(1))), v -> List.of(Double.valueOf(v.x), Double.valueOf(v.y)));

    public double2(double x) {
        this(x, x);
    }

    public double2(Vector2d xy) {
        this(xy.x, xy.y);
    }

    public double2(Vector2f xy) {
        this(xy.x, xy.y);
    }

    public double2(class_241 xy) {
        this(xy.field_1343, xy.field_1342);
    }

    public Vector2d toVector2d() {
        return new Vector2d(this.x, this.y);
    }

    public Vector2f toVector2f() {
        return new Vector2f((float)this.x, (float)this.y);
    }

    public class_241 toVec2f() {
        return new class_241((float)this.x, (float)this.y);
    }

    @Override
    public int compareTo(double2 other) {
        return (int)Math.round(this.y == other.y ? this.x - other.x : this.y - other.y);
    }

    public double2 normalize() {
        double squaredMagnitude = this.x * this.x + this.y * this.y;
        double inv = math.invSqrt(squaredMagnitude);
        return new double2(this.x * inv, this.y * inv);
    }

    public double2 add(double2 xy) {
        return new double2(this.x + xy.x, this.y + xy.y);
    }

    public double2 add(double x, double y) {
        return this.add(new double2(x, y));
    }

    public double2 add(double x) {
        return this.add(x, x);
    }

    public double2 addX(double x) {
        return this.add(x, 0.0);
    }

    public double2 addY(double y) {
        return this.add(0.0, y);
    }

    public double2 sub(double2 xy) {
        return new double2(this.x - xy.x, this.y - xy.y);
    }

    public double2 sub(double x, double y) {
        return this.sub(new double2(x, y));
    }

    public double2 sub(double x) {
        return this.sub(x, x);
    }

    public double2 subX(double x) {
        return this.sub(x, 0.0);
    }

    public double2 subY(double y) {
        return this.sub(0.0, y);
    }

    public double2 mul(double2 xy) {
        return new double2(this.x * xy.x, this.y * xy.y);
    }

    public double2 mul(double x, double y) {
        return this.mul(new double2(x, y));
    }

    public double2 mul(double x) {
        return this.mul(x, x);
    }

    public double2 mulX(double x) {
        return this.mul(x, 0.0);
    }

    public double2 mulY(double y) {
        return this.mul(0.0, y);
    }

    public double2 div(double2 xy) {
        return new double2(this.x / xy.x, this.y / xy.y);
    }

    public double2 div(double x, double y) {
        return this.div(new double2(x, y));
    }

    public double2 div(double x) {
        return this.div(x, x);
    }

    public double2 divX(double x) {
        return this.div(x, 0.0);
    }

    public double2 divY(double y) {
        return this.div(0.0, y);
    }

    public double2 lerp(double delta, double2 to) {
        return math.lerp(delta, this, to);
    }
}

