/*
 * Decompiled with CFR 0.152.
 */
package net.collectively.geode.types;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.collectively.geode.math.math;
import net.collectively.geode.types.double2;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import org.joml.Vector3f;

public record double3(double x, double y, double z) implements class_2374,
Comparable<class_2374>
{
    public static final Codec<double3> CODEC = Codec.DOUBLE.listOf().comapFlatMap(c -> class_156.method_33141((List)c, (int)3).map(coords -> new double3((Double)coords.getFirst(), (Double)coords.get(1), (Double)coords.get(2))), v -> List.of(Double.valueOf(v.x), Double.valueOf(v.y), Double.valueOf(v.z)));
    public static double3 zero = new double3(0.0);
    public static double3 one = new double3(1.0);
    public static double3 half = new double3(0.5);
    public static double3 right = new double3(1.0, 0.0, 0.0);
    public static double3 left = new double3(-1.0, 0.0, 0.0);
    public static double3 up = new double3(0.0, 1.0, 0.0);
    public static double3 down = new double3(0.0, -1.0, 0.0);
    public static double3 fwd = new double3(0.0, 0.0, 1.0);
    public static double3 bwd = new double3(0.0, 0.0, -1.0);

    public double3(double x, double y) {
        this(x, y, 0.0);
    }

    public double3(double x) {
        this(x, x, x);
    }

    public double3(class_2374 xyz) {
        this(xyz.method_10216(), xyz.method_10214(), xyz.method_10215());
    }

    public double3(class_2338 pos) {
        this(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public double3(Vector3f xyz) {
        this(xyz.x(), xyz.y(), xyz.z());
    }

    public double method_10216() {
        return this.x;
    }

    public double method_10214() {
        return this.y;
    }

    public double method_10215() {
        return this.z;
    }

    public class_243 toVec3d() {
        return new class_243(this.x, this.y, this.z);
    }

    public class_2338 toBlockPos() {
        return class_2338.method_49638((class_2374)this);
    }

    public Vector3f toVec3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public double3 modify(UnaryOperator<Double> modifier) {
        return new double3((Double)modifier.apply(this.x), (Double)modifier.apply(this.y), (Double)modifier.apply(this.z));
    }

    @Override
    public int compareTo(class_2374 other) {
        if (this.method_10214() == other.method_10214()) {
            return (int)Math.round(this.method_10215() == other.method_10215() ? this.method_10216() - other.method_10216() : this.method_10215() - other.method_10215());
        }
        return (int)Math.round(this.method_10214() - other.method_10214());
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public double3 normalize() {
        return this.mul(math.invSqrt(this.squaredMag()));
    }

    public double squaredMag() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double squaredHorMag() {
        return this.x * this.x + this.z * this.z;
    }

    public double3 cross(class_2374 v) {
        return new double3(this.y * v.method_10215() - this.z * v.method_10214(), this.z * v.method_10216() - this.x * v.method_10215(), this.x * v.method_10214() - this.y * v.method_10216());
    }

    public double dot(class_2374 vec) {
        return this.x * vec.method_10216() + this.y * vec.method_10214() + this.z * vec.method_10215();
    }

    public double3 add(class_2374 xyz) {
        return new double3(this.x + xyz.method_10216(), this.y + xyz.method_10214(), this.z + xyz.method_10215());
    }

    public double3 add(class_2338 xyz) {
        return this.add((class_2374)xyz.method_46558());
    }

    public double3 add(double x, double y, double z) {
        return this.add(new double3(x, y, z));
    }

    public double3 add(double x) {
        return this.add(x, x, x);
    }

    public double3 addX(double x) {
        return this.add(x, 0.0, 0.0);
    }

    public double3 addY(double y) {
        return this.add(0.0, y, 0.0);
    }

    public double3 addZ(double z) {
        return this.add(0.0, 0.0, z);
    }

    public double3 sub(class_2374 xyz) {
        return new double3(this.x - xyz.method_10216(), this.y - xyz.method_10214(), this.z - xyz.method_10215());
    }

    public double3 sub(class_2338 xyz) {
        return this.sub((class_2374)xyz.method_46558());
    }

    public double3 sub(double x, double y, double z) {
        return this.sub(new double3(x, y, z));
    }

    public double3 sub(double x) {
        return this.sub(x, x, x);
    }

    public double3 subX(double x) {
        return this.sub(x, 0.0, 0.0);
    }

    public double3 subY(double y) {
        return this.sub(0.0, y, 0.0);
    }

    public double3 subZ(double z) {
        return this.sub(0.0, 0.0, z);
    }

    public double3 mul(class_2374 xyz) {
        return new double3(this.x * xyz.method_10216(), this.y * xyz.method_10214(), this.z * xyz.method_10215());
    }

    public double3 mul(class_2338 xyz) {
        return this.mul((class_2374)xyz.method_46558());
    }

    public double3 mul(double x, double y, double z) {
        return this.mul(new double3(x, y, z));
    }

    public double3 mul(double x) {
        return this.mul(x, x, x);
    }

    public double3 mulX(double x) {
        return this.mul(x, 0.0, 0.0);
    }

    public double3 mulY(double y) {
        return this.mul(0.0, y, 0.0);
    }

    public double3 mulZ(double z) {
        return this.mul(0.0, 0.0, z);
    }

    public double3 div(class_2374 xyz) {
        return new double3(this.x / xyz.method_10216(), this.y / xyz.method_10214(), this.z / xyz.method_10215());
    }

    public double3 div(class_2338 xyz) {
        return this.div((class_2374)xyz.method_46558());
    }

    public double3 div(double x, double y, double z) {
        return this.div(new double3(x, y, z));
    }

    public double3 div(double x) {
        return this.div(x, x, x);
    }

    public double3 divX(double x) {
        return this.div(x, 0.0, 0.0);
    }

    public double3 divY(double y) {
        return this.div(0.0, y, 0.0);
    }

    public double3 divZ(double z) {
        return this.div(0.0, 0.0, z);
    }

    public double3 lerp(double delta, class_2374 to) {
        return math.lerp(delta, (class_2374)this, to);
    }

    public double3 withX(double x) {
        return new double3(x, this.y, this.z);
    }

    public double3 withY(double y) {
        return new double3(this.x, y, this.z);
    }

    public double3 withZ(double z) {
        return new double3(z, this.y, this.z);
    }

    public double3 xyz() {
        return new double3(this.x, this.y, this.z);
    }

    public double3 zyx() {
        return new double3(this.z, this.y, this.x);
    }

    public double3 zxy() {
        return new double3(this.z, this.x, this.y);
    }

    public double3 yxz() {
        return new double3(this.y, this.x, this.z);
    }

    public double3 yzx() {
        return new double3(this.y, this.z, this.x);
    }

    public double3 xzy() {
        return new double3(this.x, this.z, this.y);
    }

    public double2 xx() {
        return new double2(this.x, this.x);
    }

    public double2 xy() {
        return new double2(this.x, this.y);
    }

    public double2 xz() {
        return new double2(this.x, this.z);
    }

    public double2 yx() {
        return new double2(this.y, this.x);
    }

    public double2 yy() {
        return new double2(this.y, this.y);
    }

    public double2 yz() {
        return new double2(this.y, this.z);
    }

    public double2 zx() {
        return new double2(this.z, this.x);
    }

    public double2 zy() {
        return new double2(this.z, this.y);
    }

    public double2 zz() {
        return new double2(this.z, this.z);
    }

    public String toPrettyString() {
        return "[%s, %s, %s]".formatted(this.x, this.y, this.z);
    }
}

