/*
 * Decompiled with CFR 0.152.
 */
package net.masuno.render;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.masuno.config.MasConfig;
import net.minecraft.class_11658;
import net.minecraft.class_12249;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public final class MaceShockwaveRenderer {
    private static final int DURATION_TICKS = 12;
    private static final int RING_SEGMENTS = 80;
    private static final int TIP_COUNT = 8;
    private static final List<Shockwave> SHOCKWAVES = new ArrayList<Shockwave>();

    private MaceShockwaveRenderer() {
    }

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || SHOCKWAVES.isEmpty()) {
                return;
            }
            long time = client.field_1687.method_75260();
            SHOCKWAVES.removeIf(wave -> time - wave.startTick > 12L);
        });
        WorldRenderEvents.AFTER_ENTITIES.register(MaceShockwaveRenderer::render);
    }

    public static void spawn(class_243 pos, float sizeScale) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        float size = Math.max(0.1f, sizeScale);
        SHOCKWAVES.add(new Shockwave(pos, minecraft.field_1687.method_75260(), size));
    }

    private static void render(WorldRenderContext context) {
        class_4587 matrices = context.matrices();
        if (matrices == null || SHOCKWAVES.isEmpty()) {
            return;
        }
        class_11658 worldState = context.worldState();
        if (worldState.field_63082 == null || worldState.field_63082.field_63078 == null) {
            return;
        }
        class_243 cameraPos = worldState.field_63082.field_63078;
        long time = worldState.field_64463;
        class_4597 consumers = context.consumers();
        class_4588 buffer = consumers.method_73477(class_12249.method_76003());
        for (Shockwave wave : SHOCKWAVES) {
            MaceShockwaveRenderer.renderShockwave(matrices, buffer, cameraPos, time, wave);
        }
    }

    private static void renderShockwave(class_4587 matrices, class_4588 buffer, class_243 cameraPos, long time, Shockwave wave) {
        float age = time - wave.startTick;
        float progress = age / 12.0f;
        if (progress < 0.0f || progress > 1.0f) {
            return;
        }
        float eased = 1.0f - (1.0f - progress) * (1.0f - progress);
        float size = wave.size;
        float endRadius = 6.0f * size;
        float startRadius = 0.35f * size;
        float radius = MaceShockwaveRenderer.lerp(startRadius, endRadius, eased);
        float thickness = 0.18f * size;
        float tipLength = 0.55f * size;
        float tipHalfWidth = thickness * 1.6f;
        float baseAlpha = (1.0f - progress) * 0.95f;
        float alpha = Math.clamp(baseAlpha * MasConfig.INSTANCE.MaceShockwaveOpacity, 0.0f, 1.0f);
        if (alpha <= 0.0f) {
            return;
        }
        class_243 rel = wave.pos.method_1020(cameraPos);
        matrices.method_22903();
        matrices.method_22904(rel.field_1352, rel.field_1351 + 0.02, rel.field_1350);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float ringInner = Math.max(0.0f, radius - thickness);
        float ringOuter = radius + thickness;
        MaceShockwaveRenderer.renderRing(matrix, buffer, ringInner, ringOuter, alpha);
        MaceShockwaveRenderer.renderDiamondTips(matrix, buffer, radius, ringInner, tipLength, tipHalfWidth, alpha);
        matrices.method_22909();
    }

    private static void renderRing(Matrix4f matrix, class_4588 buffer, float innerRadius, float outerRadius, float alpha) {
        for (int i = 0; i < 80; ++i) {
            double a1 = (double)i / 80.0 * Math.PI * 2.0;
            double a2 = (double)(i + 1) / 80.0 * Math.PI * 2.0;
            float cos1 = (float)Math.cos(a1);
            float sin1 = (float)Math.sin(a1);
            float cos2 = (float)Math.cos(a2);
            float sin2 = (float)Math.sin(a2);
            float x1 = cos1 * innerRadius;
            float z1 = sin1 * innerRadius;
            float x2 = cos1 * outerRadius;
            float z2 = sin1 * outerRadius;
            float x3 = cos2 * outerRadius;
            float z3 = sin2 * outerRadius;
            float x4 = cos2 * innerRadius;
            float z4 = sin2 * innerRadius;
            MaceShockwaveRenderer.addQuadBothSides(buffer, matrix, x1, 0.0f, z1, x2, 0.0f, z2, x3, 0.0f, z3, x4, 0.0f, z4, alpha);
        }
    }

    private static void renderDiamondTips(Matrix4f matrix, class_4588 buffer, float radius, float ringInnerRadius, float tipLength, float tipHalfWidth, float alpha) {
        float tipAlpha = Math.clamp(alpha * 1.05f, 0.0f, 1.0f);
        float baseRadius = radius + (radius - ringInnerRadius) * 0.25f;
        float backRadius = Math.max(0.0f, radius - (radius - ringInnerRadius) * 0.9f);
        float tipRadius = radius + tipLength;
        for (int i = 0; i < 8; ++i) {
            double a = (double)i / 8.0 * Math.PI * 2.0;
            float cos = (float)Math.cos(a);
            float sin = (float)Math.sin(a);
            float tx = -sin;
            float tz = cos;
            float xTip = cos * tipRadius;
            float zTip = sin * tipRadius;
            float xLeft = cos * baseRadius + tx * tipHalfWidth;
            float zLeft = sin * baseRadius + tz * tipHalfWidth;
            float xBack = cos * backRadius;
            float zBack = sin * backRadius;
            float xRight = cos * baseRadius - tx * tipHalfWidth;
            float zRight = sin * baseRadius - tz * tipHalfWidth;
            MaceShockwaveRenderer.addQuadBothSides(buffer, matrix, xTip, 0.0f, zTip, xLeft, 0.0f, zLeft, xBack, 0.0f, zBack, xRight, 0.0f, zRight, tipAlpha);
        }
    }

    private static void addQuadBothSides(class_4588 buffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float alpha) {
        MaceShockwaveRenderer.addVertex(buffer, matrix, x1, y1, z1, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x2, y2, z2, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x3, y3, z3, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x4, y4, z4, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x4, y4, z4, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x3, y3, z3, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x2, y2, z2, alpha);
        MaceShockwaveRenderer.addVertex(buffer, matrix, x1, y1, z1, alpha);
    }

    private static void addVertex(class_4588 buffer, Matrix4f matrix, float x, float y, float z, float alpha) {
        buffer.method_22918((Matrix4fc)matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, alpha);
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    @Environment(value=EnvType.CLIENT)
    private record Shockwave(class_243 pos, long startTick, float size) {
    }
}

