/*
 * Decompiled with CFR 0.152.
 */
package nel.bettershield;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import nel.bettershield.BetterShieldConfig;
import nel.bettershield.effect.StunStatusEffect;
import nel.bettershield.entity.ThrownShieldEntity;
import nel.bettershield.registry.BetterShieldCriteria;
import nel.bettershield.registry.BetterShieldEnchantments;
import nel.bettershield.registry.BetterShieldLootModifier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bettershield
implements ModInitializer {
    public static final String MOD_ID = "bettershield";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bettershield");
    public static final class_1291 STUN_EFFECT = new StunStatusEffect();
    public static final class_2960 PACKET_SHIELD_ATTACK = new class_2960("bettershield", "shield_attack");
    public static final class_2960 PACKET_SHIELD_THROW = new class_2960("bettershield", "shield_throw");
    public static final class_2960 PACKET_STUN_MOBS = new class_2960("bettershield", "stun_mobs");
    public static final class_2960 PACKET_SYNC_COOLDOWN = new class_2960("bettershield", "sync_cooldown");
    public static final class_2960 PACKET_SLAM_EFFECT = new class_2960("bettershield", "slam_effect");
    public static final class_2400 STUN_STAR_PARTICLE = FabricParticleTypes.simple();
    public static final class_1299<ThrownShieldEntity> THROWN_SHIELD_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960("bettershield", "thrown_shield"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, ThrownShieldEntity::new).dimensions(class_4048.method_18385((float)1.2f, (float)1.2f)).trackRangeBlocks(80).trackedUpdateRate(10).build());
    public static final HashMap<UUID, Long> PARRY_DEBOUNCE = new HashMap();
    public static final HashMap<UUID, Long> BASH_COOLDOWN = new HashMap();
    public static final HashMap<UUID, Long> SLAM_COOLDOWN = new HashMap();
    public static final HashMap<UUID, Long> PARRY_MELEE_COOLDOWN = new HashMap();
    public static final HashMap<UUID, Long> PARRY_PROJECTILE_COOLDOWN = new HashMap();
    public static final HashMap<UUID, Long> THROW_COOLDOWN = new HashMap();
    public static final HashMap<UUID, Integer> BASH_MAX = new HashMap();
    public static final HashMap<UUID, Integer> SLAM_MAX = new HashMap();
    public static final HashMap<UUID, Integer> PARRY_MELEE_MAX = new HashMap();
    public static final HashMap<UUID, Integer> PARRY_PROJECTILE_MAX = new HashMap();
    public static final HashMap<UUID, Integer> THROW_MAX = new HashMap();
    public static final HashMap<UUID, Double> SLAM_START_Y = new HashMap();

    public static BetterShieldConfig getConfig() {
        return (BetterShieldConfig)AutoConfig.getConfigHolder(BetterShieldConfig.class).getConfig();
    }

    public void onInitialize() {
        AutoConfig.register(BetterShieldConfig.class, JanksonConfigSerializer::new);
        BetterShieldEnchantments.register();
        BetterShieldLootModifier.register();
        BetterShieldCriteria.register();
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)new class_2960(MOD_ID, "stun"), (Object)STUN_EFFECT);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "stun_star"), (Object)STUN_STAR_PARTICLE);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_SHIELD_THROW, (server, player, handler, buf, responseSender) -> {
            int chargeTicks = buf.readInt();
            server.execute(() -> {
                if (player != null) {
                    BetterShieldConfig config = Bettershield.getConfig();
                    long now = player.method_37908().method_8510();
                    if (THROW_COOLDOWN.containsKey(player.method_5667()) && now < THROW_COOLDOWN.get(player.method_5667())) {
                        return;
                    }
                    class_1799 mainStack = player.method_6047();
                    class_1799 offStack = player.method_6079();
                    class_1799 shieldToThrow = null;
                    boolean isOffhand = false;
                    if (mainStack.method_31574(class_1802.field_8255) && class_1890.method_8225((class_1887)class_1893.field_9120, (class_1799)mainStack) > 0) {
                        shieldToThrow = mainStack;
                        isOffhand = false;
                    } else if (offStack.method_31574(class_1802.field_8255) && class_1890.method_8225((class_1887)class_1893.field_9120, (class_1799)offStack) > 0) {
                        shieldToThrow = offStack;
                        isOffhand = true;
                    }
                    if (shieldToThrow != null) {
                        int effectiveTicks = Math.max(1, chargeTicks);
                        float maxChargeTicks = 20.0f;
                        float ratio = Math.min(1.0f, (float)effectiveTicks / maxChargeTicks);
                        float minDmg = 0.5f;
                        float maxDmg = (float)config.combat.shieldThrowDamage;
                        float finalBaseDamage = minDmg + ratio * (maxDmg - minDmg);
                        ThrownShieldEntity thrownShield = new ThrownShieldEntity(player.method_37908(), (class_1309)player, shieldToThrow.method_7972());
                        thrownShield.setOriginalSlot(isOffhand);
                        thrownShield.setImpactDamage(finalBaseDamage);
                        thrownShield.setStunEnabled(config.stunMechanics.throwStunEnabled);
                        float speed = 1.0f + ratio * 1.0f;
                        thrownShield.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, speed, 1.0f);
                        player.method_37908().method_8649((class_1297)thrownShield);
                        if (!player.method_7337()) {
                            if (isOffhand) {
                                player.method_6122(class_1268.field_5810, class_1799.field_8037);
                            } else {
                                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                            }
                        }
                        int masterineLevel = class_1890.method_8225((class_1887)BetterShieldEnchantments.MASTERINE, (class_1799)shieldToThrow);
                        int baseCd = config.cooldowns.throwCooldown;
                        int finalCd = (int)((float)baseCd * (1.0f - (float)masterineLevel * 0.2f));
                        Bettershield.triggerCooldown((class_1657)player, 5, finalCd);
                        float pitch = 0.8f + ratio * 0.4f;
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15001, class_3419.field_15248, 1.0f, pitch);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_SHIELD_ATTACK, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            if (player != null) {
                BetterShieldConfig config = Bettershield.getConfig();
                class_1799 shieldStack = null;
                if (player.method_6047().method_31574(class_1802.field_8255)) {
                    shieldStack = player.method_6047();
                } else if (player.method_6079().method_31574(class_1802.field_8255)) {
                    shieldStack = player.method_6079();
                }
                if (shieldStack != null) {
                    long now = player.method_37908().method_8510();
                    if (player.method_24828()) {
                        if (BASH_COOLDOWN.containsKey(player.method_5667()) && now < BASH_COOLDOWN.get(player.method_5667())) {
                            return;
                        }
                        class_243 rotation = player.method_5720();
                        double bashSpeed = 1.5;
                        if (config.funCombos.allowVerticalBash) {
                            player.method_18800(rotation.field_1352 * bashSpeed, rotation.field_1351 * bashSpeed, rotation.field_1350 * bashSpeed);
                        } else {
                            player.method_18800(rotation.field_1352 * bashSpeed, 0.0, rotation.field_1350 * bashSpeed);
                        }
                        player.field_6037 = true;
                        class_243 pos = player.method_19538().method_1019(rotation.method_1021(1.5));
                        class_238 box = new class_238(pos.field_1352 - 1.0, pos.field_1351, pos.field_1350 - 1.0, pos.field_1352 + 1.0, pos.field_1351 + 2.0, pos.field_1350 + 1.0);
                        int densityLevel = class_1890.method_8225((class_1887)BetterShieldEnchantments.SHIELD_DENSITY, (class_1799)shieldStack);
                        float damageMult = 1.0f + (float)densityLevel * 0.1f;
                        float baseDamage = (float)config.combat.bashDamage;
                        float finalDamage = baseDamage * damageMult;
                        List targets = player.method_37908().method_8335((class_1297)player, box);
                        for (class_1297 target : targets) {
                            if (!(target instanceof class_1309)) continue;
                            class_1309 living = (class_1309)target;
                            living.method_5643(player.method_48923().method_48802((class_1657)player), finalDamage);
                            double knockbackStrength = config.combat.bashKnockback;
                            living.method_6005(knockbackStrength, player.method_23317() - living.method_23317(), player.method_23321() - living.method_23321());
                            if (!config.stunMechanics.bashStunEnabled) continue;
                            living.method_6092(new class_1293(STUN_EFFECT, config.stunMechanics.stunDuration, 0, false, false, true));
                            class_2540 stunBuf = PacketByteBufs.create();
                            stunBuf.writeInt(living.method_5628());
                            stunBuf.writeInt(config.stunMechanics.stunDuration);
                            player.method_37908().method_18456().forEach(p -> ServerPlayNetworking.send((class_3222)((class_3222)p), (class_2960)PACKET_STUN_MOBS, (class_2540)stunBuf));
                        }
                        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 0.5f);
                        int masterineLevel = class_1890.method_8225((class_1887)BetterShieldEnchantments.MASTERINE, (class_1799)shieldStack);
                        int baseCd = config.cooldowns.bashCooldown;
                        int finalCd = (int)((float)baseCd * (1.0f - (float)masterineLevel * 0.2f));
                        Bettershield.triggerCooldown((class_1657)player, 1, finalCd);
                    } else {
                        if (player.method_5799()) {
                            return;
                        }
                        if (SLAM_COOLDOWN.containsKey(player.method_5667()) && now < SLAM_COOLDOWN.get(player.method_5667())) {
                            return;
                        }
                        double minHeight = config.combat.slamMinimumHeight;
                        class_243 start = player.method_33571();
                        class_243 end = start.method_1031(0.0, -(minHeight + 0.5), 0.0);
                        class_3959 context = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
                        if (player.method_37908().method_17742(context).method_17783() != class_239.class_240.field_1333) {
                            return;
                        }
                        player.method_18800(0.0, -3.0, 0.0);
                        player.field_6037 = true;
                        player.field_6017 = 0.0f;
                        SLAM_START_Y.put(player.method_5667(), player.method_23318());
                        int masterineLevel = class_1890.method_8225((class_1887)BetterShieldEnchantments.MASTERINE, (class_1799)shieldStack);
                        int baseCd = config.cooldowns.slamCooldown;
                        int finalCd = (int)((float)baseCd * (1.0f - (float)masterineLevel * 0.2f));
                        Bettershield.triggerCooldown((class_1657)player, 2, finalCd);
                    }
                }
            }
        }));
    }

    public static void triggerCooldown(class_1657 player, int type, int ticks) {
        long expiry = player.method_37908().method_8510() + (long)ticks;
        if (type == 1) {
            BASH_COOLDOWN.put(player.method_5667(), expiry);
            BASH_MAX.put(player.method_5667(), ticks);
        }
        if (type == 2) {
            SLAM_COOLDOWN.put(player.method_5667(), expiry);
            SLAM_MAX.put(player.method_5667(), ticks);
        }
        if (type == 3) {
            PARRY_MELEE_COOLDOWN.put(player.method_5667(), expiry);
            PARRY_MELEE_MAX.put(player.method_5667(), ticks);
        }
        if (type == 4) {
            PARRY_PROJECTILE_COOLDOWN.put(player.method_5667(), expiry);
            PARRY_PROJECTILE_MAX.put(player.method_5667(), ticks);
        }
        if (type == 5) {
            THROW_COOLDOWN.put(player.method_5667(), expiry);
            THROW_MAX.put(player.method_5667(), ticks);
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(type);
        buf.writeInt(ticks);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)PACKET_SYNC_COOLDOWN, (class_2540)buf);
    }

    public static boolean isParryDebounced(class_1657 player) {
        if (!PARRY_DEBOUNCE.containsKey(player.method_5667())) {
            return false;
        }
        long lastParry = PARRY_DEBOUNCE.get(player.method_5667());
        return player.method_37908().method_8510() - lastParry < 10L;
    }

    public static void setParryDebounce(class_1657 player) {
        PARRY_DEBOUNCE.put(player.method_5667(), player.method_37908().method_8510());
    }
}

