/*
 * Decompiled with CFR 0.152.
 */
package nel.bettershield;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import nel.bettershield.BetterShieldConfig;
import nel.bettershield.Bettershield;
import nel.bettershield.client.ShieldHudOverlay;
import nel.bettershield.client.ThrownShieldEntityRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7923;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class BettershieldClient
implements ClientModInitializer {
    private static final class_2960 STAR_TEXTURE = new class_2960("bettershield", "textures/particle/stun_star.png");
    private static final HashMap<Integer, Long> STUNNED_ENTITIES = new HashMap();
    private boolean wasAttackPressed = false;
    private final Random random = new Random();
    public static int chargeTicks = 0;
    public static boolean isChargingThrow = false;
    public static final class_304 THROW_SHIELD_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bettershield.throw", class_3675.class_307.field_1672, 2, "category.bettershield.title"));

    public void onInitializeClient() {
        HudRenderCallback.EVENT.register((Object)new ShieldHudOverlay());
        EntityRendererRegistry.register(Bettershield.THROWN_SHIELD_ENTITY_TYPE, ThrownShieldEntityRenderer::new);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Bettershield.PACKET_SYNC_COOLDOWN, (client, handler, buf, responseSender) -> {
            int type = buf.readInt();
            int duration = buf.readInt();
            client.execute(() -> {
                if (client.field_1724 != null) {
                    long expiry = client.field_1687.method_8510() + (long)duration;
                    if (type == 1) {
                        Bettershield.BASH_COOLDOWN.put(client.field_1724.method_5667(), expiry);
                        Bettershield.BASH_MAX.put(client.field_1724.method_5667(), duration);
                    }
                    if (type == 2) {
                        Bettershield.SLAM_COOLDOWN.put(client.field_1724.method_5667(), expiry);
                        Bettershield.SLAM_MAX.put(client.field_1724.method_5667(), duration);
                    }
                    if (type == 3) {
                        Bettershield.PARRY_MELEE_COOLDOWN.put(client.field_1724.method_5667(), expiry);
                        Bettershield.PARRY_MELEE_MAX.put(client.field_1724.method_5667(), duration);
                    }
                    if (type == 4) {
                        Bettershield.PARRY_PROJECTILE_COOLDOWN.put(client.field_1724.method_5667(), expiry);
                        Bettershield.PARRY_PROJECTILE_MAX.put(client.field_1724.method_5667(), duration);
                    }
                    if (type == 5) {
                        Bettershield.THROW_COOLDOWN.put(client.field_1724.method_5667(), expiry);
                        Bettershield.THROW_MAX.put(client.field_1724.method_5667(), duration);
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Bettershield.PACKET_STUN_MOBS, (client, handler, buf, responseSender) -> {
            int entityId = buf.readInt();
            int duration = buf.readInt();
            client.execute(() -> {
                if (client.field_1687 != null) {
                    STUNNED_ENTITIES.put(entityId, client.field_1687.method_8510() + (long)duration);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Bettershield.PACKET_SLAM_EFFECT, (client, handler, buf, responseSender) -> {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            String blockId = buf.method_19772();
            client.execute(() -> {
                if (client.field_1687 != null) {
                    class_1799 debrisStack = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(blockId)));
                    if (debrisStack.method_7960()) {
                        debrisStack = new class_1799((class_1935)class_1802.field_20412);
                    }
                    for (int i = 0; i < 600; ++i) {
                        double r = 0.5 + this.random.nextDouble() * 1.5;
                        double angle = this.random.nextDouble() * Math.PI * 2.0;
                        double ox = x + Math.cos(angle) * r;
                        double oz = z + Math.sin(angle) * r;
                        double oy = y + 0.2;
                        double vy = 0.8 + this.random.nextDouble() * 1.2;
                        double speed = 0.1 + this.random.nextDouble() * 0.3;
                        double vx = Math.cos(angle) * speed;
                        double vz = Math.sin(angle) * speed;
                        client.field_1687.method_8406((class_2394)new class_2392(class_2398.field_11218, debrisStack), ox, oy, oz, vx, vy, vz);
                    }
                }
            });
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            long now = client.field_1687.method_8510();
            Iterator<Map.Entry<Integer, Long>> iterator = STUNNED_ENTITIES.entrySet().iterator();
            while (iterator.hasNext()) {
                if (now <= iterator.next().getValue()) continue;
                iterator.remove();
            }
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                if (!STUNNED_ENTITIES.containsKey(entity.method_5628()) && !living.method_6059(Bettershield.STUN_EFFECT)) continue;
                this.renderHalo(context, living);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            class_1799 main = client.field_1724.method_6047();
            class_1799 off = client.field_1724.method_6079();
            boolean mainIsShield = main.method_31574(class_1802.field_8255);
            boolean offIsShield = off.method_31574(class_1802.field_8255);
            boolean blacklisted = false;
            if (offIsShield && !mainIsShield) {
                BetterShieldConfig config = Bettershield.getConfig();
                String itemId = class_7923.field_41178.method_10221((Object)main.method_7909()).toString();
                for (String blocked : config.compatibility.mainHandBlacklist) {
                    if (!itemId.contains(blocked)) continue;
                    blacklisted = true;
                    break;
                }
            }
            if (blacklisted) {
                isChargingThrow = false;
                chargeTicks = 0;
                this.wasAttackPressed = false;
                return;
            }
            boolean isAttacking = client.field_1690.field_1886.method_1434();
            boolean isBlockingInput = client.field_1690.field_1904.method_1434();
            if (isAttacking) {
                if (!this.wasAttackPressed) {
                    boolean hasShield;
                    boolean bl = hasShield = mainIsShield || offIsShield;
                    if (hasShield && isBlockingInput) {
                        ClientPlayNetworking.send((class_2960)Bettershield.PACKET_SHIELD_ATTACK, (class_2540)PacketByteBufs.create());
                        client.field_1724.method_6104(client.field_1724.method_6058());
                    }
                    this.wasAttackPressed = true;
                }
            } else {
                this.wasAttackPressed = false;
            }
            if (THROW_SHIELD_KEY.method_1434()) {
                boolean hasLoyalShield;
                boolean bl = hasLoyalShield = mainIsShield && main.method_7942() || offIsShield && off.method_7942();
                if (hasLoyalShield) {
                    isChargingThrow = true;
                    if (chargeTicks < 20) {
                        ++chargeTicks;
                    }
                } else {
                    isChargingThrow = false;
                    chargeTicks = 0;
                }
            } else if (isChargingThrow) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(chargeTicks);
                ClientPlayNetworking.send((class_2960)Bettershield.PACKET_SHIELD_THROW, (class_2540)buf);
                isChargingThrow = false;
                chargeTicks = 0;
            }
        });
    }

    private void renderHalo(WorldRenderContext context, class_1309 entity) {
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_4597 consumers = context.consumers();
        double x = class_3532.method_16436((double)context.tickDelta(), (double)entity.field_6014, (double)entity.method_23317());
        double y = class_3532.method_16436((double)context.tickDelta(), (double)entity.field_6036, (double)entity.method_23318());
        double z = class_3532.method_16436((double)context.tickDelta(), (double)entity.field_5969, (double)entity.method_23321());
        double height = (double)entity.method_18381(entity.method_18376()) + 0.5;
        float time = (float)entity.field_6012 + context.tickDelta();
        int starCount = 3;
        double radius = 0.65;
        double speed = 0.3;
        class_4588 buffer = consumers.getBuffer(class_1921.method_23580((class_2960)STAR_TEXTURE));
        Quaternionf cameraRot = context.camera().method_23767();
        matrices.method_22903();
        matrices.method_22904(x - cameraPos.field_1352, y - cameraPos.field_1351 + height, z - cameraPos.field_1350);
        for (int i = 0; i < starCount; ++i) {
            matrices.method_22903();
            double angle = (double)time * speed + (double)i * (Math.PI * 2 / (double)starCount);
            double oX = Math.cos(angle) * radius;
            double oZ = Math.sin(angle) * radius;
            matrices.method_22904(oX, 0.0, oZ);
            matrices.method_22907(cameraRot);
            this.drawQuad(matrices, buffer, 0.25f);
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private void drawQuad(class_4587 matrices, class_4588 buffer, float size) {
        class_4587.class_4665 entry = matrices.method_23760();
        int light = 0xF000F0;
        buffer.method_22918(entry.method_23761(), -size, -size, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(entry.method_23761(), size, -size, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(entry.method_23761(), size, size, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(entry.method_23761(), -size, size, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }
}

