/*
 * Decompiled with CFR 0.152.
 */
package nel.bettershield.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import nel.bettershield.BetterShieldConfig;
import nel.bettershield.Bettershield;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ShieldHudOverlay
implements HudRenderCallback {
    private static final class_2960 BASH_ICON = new class_2960("bettershield", "textures/gui/bash.png");
    private static final class_2960 SLAM_ICON = new class_2960("bettershield", "textures/gui/slam.png");
    private static final class_2960 PARRY_MELEE_ICON = new class_2960("bettershield", "textures/gui/parry_melee.png");
    private static final class_2960 PARRY_PROJ_ICON = new class_2960("bettershield", "textures/gui/parry_proj.png");
    private static final class_2960 THROW_ICON = new class_2960("bettershield", "textures/gui/shield_throw.png");
    private long bashFinishTime = 0L;
    private long slamFinishTime = 0L;
    private long meleeFinishTime = 0L;
    private long projFinishTime = 0L;
    private long throwFinishTime = 0L;

    public void onHudRender(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        BetterShieldConfig config = (BetterShieldConfig)AutoConfig.getConfigHolder(BetterShieldConfig.class).getConfig();
        if (config.hud.hudMode == BetterShieldConfig.Hud.HudMode.OFF) {
            return;
        }
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        int x = width / 2 + config.hud.xOffset;
        int y = height / 2 + config.hud.yOffset;
        float scale = config.hud.scale;
        UUID uuid = client.field_1724.method_5667();
        long now = client.field_1687.method_8510();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        ArrayList<IconData> iconsToRender = new ArrayList<IconData>();
        this.checkAndAdd(iconsToRender, uuid, now, Bettershield.BASH_COOLDOWN, Bettershield.BASH_MAX, this.bashFinishTime, BASH_ICON, config.hud.hudMode, "bash");
        this.checkAndAdd(iconsToRender, uuid, now, Bettershield.SLAM_COOLDOWN, Bettershield.SLAM_MAX, this.slamFinishTime, SLAM_ICON, config.hud.hudMode, "slam");
        this.checkAndAdd(iconsToRender, uuid, now, Bettershield.PARRY_MELEE_COOLDOWN, Bettershield.PARRY_MELEE_MAX, this.meleeFinishTime, PARRY_MELEE_ICON, config.hud.hudMode, "melee");
        this.checkAndAdd(iconsToRender, uuid, now, Bettershield.PARRY_PROJECTILE_COOLDOWN, Bettershield.PARRY_PROJECTILE_MAX, this.projFinishTime, PARRY_PROJ_ICON, config.hud.hudMode, "proj");
        this.checkAndAdd(iconsToRender, uuid, now, Bettershield.THROW_COOLDOWN, Bettershield.THROW_MAX, this.throwFinishTime, THROW_ICON, config.hud.hudMode, "throw");
        int spacing = 12;
        for (int i = 0; i < iconsToRender.size(); ++i) {
            IconData data = (IconData)iconsToRender.get(i);
            this.drawBar(context, i * spacing, 0, data.icon, data.progress);
            if (data.progress >= 1.0f) {
                this.updateFinishTimer(data.type, now);
                continue;
            }
            this.resetFinishTimer(data.type);
        }
        context.method_51448().method_22909();
    }

    private void checkAndAdd(List<IconData> list, UUID uuid, long now, HashMap<UUID, Long> cdMap, HashMap<UUID, Integer> maxMap, long finishTime, class_2960 icon, BetterShieldConfig.Hud.HudMode mode, String type) {
        boolean justFinished;
        long expiry = cdMap.getOrDefault(uuid, 0L);
        boolean isActive = expiry > now;
        boolean bl = justFinished = finishTime != 0L && now - finishTime < 20L;
        if (mode == BetterShieldConfig.Hud.HudMode.ALWAYS_SHOW || isActive || justFinished) {
            float progress = this.getProgress(expiry, maxMap.getOrDefault(uuid, 100), now);
            list.add(new IconData(icon, progress, type));
        }
    }

    private void updateFinishTimer(String type, long now) {
        if (type.equals("bash") && this.bashFinishTime == 0L) {
            this.bashFinishTime = now;
        }
        if (type.equals("slam") && this.slamFinishTime == 0L) {
            this.slamFinishTime = now;
        }
        if (type.equals("melee") && this.meleeFinishTime == 0L) {
            this.meleeFinishTime = now;
        }
        if (type.equals("proj") && this.projFinishTime == 0L) {
            this.projFinishTime = now;
        }
        if (type.equals("throw") && this.throwFinishTime == 0L) {
            this.throwFinishTime = now;
        }
    }

    private void resetFinishTimer(String type) {
        if (type.equals("bash")) {
            this.bashFinishTime = 0L;
        }
        if (type.equals("slam")) {
            this.slamFinishTime = 0L;
        }
        if (type.equals("melee")) {
            this.meleeFinishTime = 0L;
        }
        if (type.equals("proj")) {
            this.projFinishTime = 0L;
        }
        if (type.equals("throw")) {
            this.throwFinishTime = 0L;
        }
    }

    private float getProgress(long expiry, int maxTime, long now) {
        if (now >= expiry) {
            return 1.0f;
        }
        long remaining = expiry - now;
        return 1.0f - (float)remaining / (float)maxTime;
    }

    private void drawBar(class_332 context, int x, int y, class_2960 icon, float progress) {
        int destW = 10;
        int destH = 10;
        int srcW = 16;
        int srcH = 16;
        context.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        context.method_25293(icon, x, y, destW, destH, 0.0f, 0.0f, srcW, srcH, srcW, srcH);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int filledDestH = (int)((float)destH * progress);
        int emptyDestH = destH - filledDestH;
        float ratio = (float)srcH / (float)destH;
        int srcStartV = (int)((float)emptyDestH * ratio);
        int srcFilledH = srcH - srcStartV;
        if (filledDestH > 0) {
            context.method_25293(icon, x, y + emptyDestH, destW, filledDestH, 0.0f, (float)srcStartV, srcW, srcFilledH, srcW, srcH);
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private static class IconData {
        class_2960 icon;
        float progress;
        String type;

        public IconData(class_2960 icon, float progress, String type) {
            this.icon = icon;
            this.progress = progress;
            this.type = type;
        }
    }
}

